/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    @Override
    protected void performAction(Document document, JTextComponent jTextComponent, int n, HyperlinkType hyperlinkType) {
        this.goToDeclaration(document, jTextComponent, n, hyperlinkType);
    }

    @Override
    protected boolean isValidToken(TokenItem<CppTokenId> tokenItem, HyperlinkType hyperlinkType) {
        return CsmHyperlinkProvider.isSupportedToken(tokenItem, hyperlinkType);
    }

    public static boolean isSupportedToken(TokenItem<CppTokenId> tokenItem, HyperlinkType hyperlinkType) {
        if (tokenItem != null) {
            if (hyperlinkType == HyperlinkType.ALT_HYPERLINK) {
                return !"whitespace".equals(((CppTokenId)tokenItem.id()).primaryCategory()) && !"comment".equals(((CppTokenId)tokenItem.id()).primaryCategory());
            }
            switch ((CppTokenId)tokenItem.id()) {
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: 
                case OPERATOR: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean goToDeclaration(Document document, JTextComponent jTextComponent, int n, HyperlinkType hyperlinkType) {
        if (!this.preJump(document, jTextComponent, n, "opening-csm-element", hyperlinkType)) {
            return false;
        }
        TokenItem<CppTokenId> tokenItem = this.getJumpToken();
        CsmOffsetable csmOffsetable = (CsmOffsetable)this.findTargetObject(document, tokenItem, n, true);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-csm-element");
    }

    CsmObject findTargetObject(Document document, TokenItem<CppTokenId> tokenItem, int n, boolean bl) {
        CsmObject csmObject;
        CsmObject csmObject2 = null;
        assert (tokenItem != null);
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        CsmObject csmObject3 = csmObject = csmFile == null ? null : ReferencesSupport.findDeclaration(csmFile, document, tokenItem, n);
        if (csmObject != null) {
            csmObject2 = bl ? this.toJumpObject(csmObject, csmFile, n) : csmObject;
        }
        return csmObject2;
    }

    private CsmOffsetable toJumpObject(CsmObject csmObject, CsmFile csmFile, int n) {
        Object object = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmVariableDefinition csmVariableDefinition;
            object = (CsmOffsetable)csmObject;
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmObject).getDefinition();
                if (csmFunctionDefinition != null) {
                    if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                        if (csmFunctionDefinition.getDeclaration() != null) {
                            object = csmFunctionDefinition.getDeclaration();
                        } else if (csmObject.equals(csmFunctionDefinition)) {
                            object = (CsmOffsetable)csmObject;
                        }
                    } else {
                        object = csmFunctionDefinition;
                    }
                } else {
                    CsmReference csmReference = CsmFunctionDefinitionResolver.getDefault().getFunctionDefinition((CsmFunction)csmObject);
                    if (csmReference != null) {
                        object = csmReference;
                    }
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)csmObject;
                if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                    object = csmFunctionDefinition.getDeclaration() != null ? csmFunctionDefinition.getDeclaration() : csmFunctionDefinition;
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmObject) && (csmVariableDefinition = ((CsmVariable)csmObject).getDefinition()) != null) {
                object = csmVariableDefinition;
                if (csmFile.equals(csmVariableDefinition.getContainingFile()) && csmVariableDefinition.getStartOffset() <= n && n <= csmVariableDefinition.getEndOffset()) {
                    object = (CsmVariable)csmObject;
                }
            }
        } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmObject;
            Collection collection = csmNamespace.getDefinitions();
            CsmNamespaceDefinition csmNamespaceDefinition = null;
            for (CsmNamespaceDefinition csmNamespaceDefinition2 : collection) {
                CsmFile csmFile2;
                if (csmNamespaceDefinition == null) {
                    csmNamespaceDefinition = csmNamespaceDefinition2;
                }
                if (!csmFile.equals(csmFile2 = csmNamespaceDefinition2.getContainingFile())) continue;
                csmNamespaceDefinition = csmNamespaceDefinition2;
                break;
            }
            object = csmNamespaceDefinition;
        }
        return object;
    }

    @Override
    protected String getTooltipText(Document document, TokenItem<CppTokenId> tokenItem, int n, HyperlinkType hyperlinkType) {
        CharSequence charSequence;
        CsmObject csmObject = this.findTargetObject(document, tokenItem, n, false);
        CharSequence charSequence2 = charSequence = csmObject == null ? null : CsmDisplayUtilities.getTooltipText((CsmObject)csmObject);
        if (charSequence != null && CsmKindUtilities.isMacro((CsmObject)csmObject)) {
            charSequence = this.getAlternativeHyperlinkTip(document, charSequence);
        }
        return charSequence == null ? null : ((Object)charSequence).toString();
    }

    private CharSequence getAlternativeHyperlinkTip(Document document, CharSequence charSequence) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)NbEditorUtilities.getMimeType((Document)document)).lookup(Preferences.class);
        int n = preferences.getInt("alt-hyperlink-activation-modifiers", 640);
        return NbBundle.getMessage(CsmHyperlinkProvider.class, (String)"AltHyperlinkHint", (Object)charSequence, (Object)InputEvent.getModifiersExText(n));
    }
}

