/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionUtilities {
    private CompletionUtilities() {
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(Document document, int n, FileReferencesContext fileReferencesContext) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (csmFile == null || !csmFile.isValid()) {
            return Collections.emptyList();
        }
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n, fileReferencesContext);
        return CsmContextUtilities.findFunctionLocalVariables(csmContext);
    }

    public static List<CsmField> findClassFields(Document document, int n) {
        CsmClass csmClass = CompletionUtilities.findClassOnPosition(document, n);
        List<CsmField> list = null;
        if (csmClass != null) {
            list = new CsmProjectContentResolver().getFields(csmClass, false);
        }
        return list;
    }

    public static List<CsmDeclaration> findFileVariables(Document document, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (csmFile == null || !csmFile.isValid()) {
            return Collections.emptyList();
        }
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n, null);
        return CsmContextUtilities.findFileLocalVariables(csmContext);
    }

    public static CsmClass findClassOnPosition(Document document, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (csmFile == null || !csmFile.isValid()) {
            return null;
        }
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n, null);
        CsmClass csmClass = CsmContextUtilities.getClass(csmContext, true, false);
        return csmClass;
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(Document document, int n) {
        return CompletionUtilities.findFunDefinitionOrClassOnPosition(document, n, null);
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(Document document, int n, FileReferencesContext fileReferencesContext) {
        CsmContext csmContext;
        CsmFunctionDefinition csmFunctionDefinition = null;
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (!(csmFile == null || (csmFunctionDefinition = CsmContextUtilities.getFunctionDefinition(csmContext = CsmOffsetResolver.findContext(csmFile, n, fileReferencesContext))) != null && CsmContextUtilities.isInFunctionBodyOrInitializerList(csmContext, n))) {
            csmFunctionDefinition = CsmContextUtilities.getClass(csmContext, false, false);
        }
        return csmFunctionDefinition;
    }

    public static Collection<CsmObject> findItemsReferencedAtCaretPos(JTextComponent jTextComponent, Document document, CsmCompletionQuery csmCompletionQuery, int n) {
        List<CsmObject> list = new ArrayList<CsmObject>();
        try {
            int[] nArray;
            BaseDocument baseDocument = null;
            if (document instanceof BaseDocument) {
                baseDocument = (BaseDocument)document;
            }
            if ((nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)(baseDocument = baseDocument != null ? baseDocument : (BaseDocument)jTextComponent.getDocument()), (int)n)) == null) {
                nArray = new int[]{n, n};
            }
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false);
            boolean bl = nArray.length == 3;
            for (int i = nArray.length - 1; i >= 1; --i) {
                CsmCompletionQuery.CsmCompletionResult csmCompletionResult;
                int n2;
                CsmCompletionQuery.CsmCompletionResult csmCompletionResult2 = csmCompletionQuery.query(jTextComponent, baseDocument, nArray[i], true, false, false);
                if (csmCompletionResult2 == null || csmCompletionResult2.getItems().isEmpty()) continue;
                List<CsmObject> list2 = CompletionUtilities.getAssociatedObjects(csmCompletionResult2.getItems(), bl, csmFile);
                List<CsmObject> list3 = list = !list2.isEmpty() ? list2 : CompletionUtilities.getAssociatedObjects(csmCompletionResult2.getItems(), false, csmFile);
                if (list2.size() > 1 && bl && (n2 = CompletionUtilities.findEndOfMethod((Document)baseDocument, nArray[i] - 1)) > -1 && (csmCompletionResult = csmCompletionQuery.query(jTextComponent, baseDocument, n2, true, false, false)) != null && !csmCompletionResult.getItems().isEmpty()) {
                    list = CompletionUtilities.getAssociatedObjects(csmCompletionResult.getItems(), false, csmFile);
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return list;
    }

    private static List<CsmObject> getAssociatedObjects(List list, boolean bl, CsmFile csmFile) {
        ArrayList<CsmObject> arrayList = new ArrayList<CsmObject>();
        ArrayList<CsmObject> arrayList2 = new ArrayList<CsmObject>();
        ArrayList<CsmObject> arrayList3 = new ArrayList<CsmObject>();
        ArrayList<CsmObject> arrayList4 = new ArrayList<CsmObject>();
        for (Object e : list) {
            if (!(e instanceof CsmResultItem)) continue;
            CsmObject csmObject = CompletionUtilities.getAssociatedObject(e);
            boolean bl2 = csmFile == null ? false : CsmIncludeResolver.getDefault().isObjectVisible(csmFile, csmObject);
            boolean bl3 = CsmKindUtilities.isFunction((CsmObject)csmObject);
            if (bl3) {
                if (bl2) {
                    arrayList4.add(csmObject);
                } else {
                    arrayList3.add(csmObject);
                }
            }
            if (bl2) {
                arrayList.add(csmObject);
                continue;
            }
            arrayList2.add(csmObject);
        }
        ArrayList<CsmObject> arrayList5 = bl ? (!arrayList4.isEmpty() ? arrayList4 : arrayList3) : (!arrayList.isEmpty() ? arrayList : arrayList2);
        return arrayList5;
    }

    private static CsmObject getAssociatedObject(Object object) {
        CsmObject csmObject;
        if (object instanceof CsmResultItem && (csmObject = (CsmObject)((CsmResultItem)object).getAssociatedObject()) != null) {
            return csmObject;
        }
        return null;
    }

    static int findEndOfMethod(Document document, int n) {
        int n2 = 0;
        CharSequence charSequence = DocumentUtilities.getText((Document)document);
        for (int i = n; i < document.getLength(); ++i) {
            char c = charSequence.charAt(i);
            if (c == ';') {
                return -1;
            }
            if (c == '(') {
                ++n2;
            }
            if (c != ')' || --n2 != 0) continue;
            return i + 1;
        }
        return -1;
    }
}

