/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;

public class DocOffsPositionImpl
implements CsmOffsetable.Position {
    private int line;
    private int col;
    private final int offset;
    private final BaseDocument doc;

    public DocOffsPositionImpl(BaseDocument baseDocument, int n) {
        this(-1, -1, n, baseDocument);
    }

    public DocOffsPositionImpl(CsmOffsetable.Position position) {
        if (position != null) {
            this.line = position.getLine();
            this.col = position.getColumn();
            this.offset = position.getOffset();
        } else {
            this.line = -1;
            this.col = -1;
            this.offset = 0;
        }
        this.doc = null;
    }

    public DocOffsPositionImpl(int n, int n2, int n3, BaseDocument baseDocument) {
        this.line = n;
        this.col = n2;
        this.offset = n3;
        this.doc = baseDocument;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.getLine(true);
    }

    public int getColumn() {
        return this.getColumn(true);
    }

    public int getLine(boolean bl) {
        if (bl && this.line == -1 && this.doc != null) {
            try {
                this.line = Utilities.getLineOffset((BaseDocument)this.doc, (int)this.offset) + 1;
            }
            catch (BadLocationException badLocationException) {
                this.line = -1;
            }
        }
        return this.line;
    }

    public int getColumn(boolean bl) {
        if (bl && this.col == -1 && this.doc != null) {
            try {
                this.col = Utilities.getVisualColumn((BaseDocument)this.doc, (int)this.offset) + 1;
            }
            catch (BadLocationException badLocationException) {
                this.col = -1;
            }
        }
        return this.col;
    }

    BaseDocument getDocument() {
        return this.doc;
    }

    public String toString() {
        return "" + this.getLine(true) + ':' + this.getColumn(true) + '/' + this.getOffset();
    }
}

