/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.PartType;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

public class CsmIncludeCompletionItem
implements CompletionItem {
    protected static final String QUOTE = "\"";
    protected static final String SYS_OPEN = "<";
    protected static final String SYS_CLOSE = ">";
    protected static final String SLASH = "/";
    protected static final String PARENT_COLOR_TAG = "<font color=\"#557755\">";
    private final int substitutionOffset;
    private final int priority;
    private final String item;
    private final String parentFolder;
    private final String childSubdir;
    private final boolean isSysInclude;
    private final boolean isFolder;
    private final boolean supportInstantSubst;
    private static final int FOLDER_PRIORITY = 30;
    private static final int FILE_PRIORITY = 10;
    private static final int SYS_VS_USR = 5;

    protected CsmIncludeCompletionItem(int n, int n2, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this.substitutionOffset = n;
        this.priority = n2;
        this.parentFolder = string == null ? "" : string;
        this.childSubdir = string2 == null ? "" : string2;
        this.isSysInclude = bl;
        this.isFolder = bl2;
        assert (string3 != null);
        this.item = string3;
        this.supportInstantSubst = bl3;
    }

    public static CsmIncludeCompletionItem createItem(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = bl3 ? (bl2 ? 25 : 35) : (bl2 ? 5 : 15);
        String string4 = string;
        return new CsmIncludeCompletionItem(n, n2, string2, string3, string4, bl, bl3, bl4);
    }

    public String getItemText() {
        return this.item;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            boolean bl = this.isFolder();
            if (!bl) {
                Completion.get().hideCompletion();
            }
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, this.isFolder() ? SLASH : null);
            if (bl) {
                Completion.get().showCompletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processKeyEvent(KeyEvent keyEvent) {
        block12: {
            if (keyEvent.getID() != 400) break block12;
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = jTextComponent.getSelectionEnd();
            int n2 = n - this.substitutionOffset;
            if (n2 < 0) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            switch (keyEvent.getKeyChar()) {
                case '>': {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    break;
                }
                case '\"': {
                    baseDocument.readLock();
                    boolean bl = false;
                    try {
                        String string;
                        if (n2 > 0 && (string = baseDocument.getText(this.substitutionOffset, n2)).startsWith(QUOTE) && n2 > 1) {
                            bl = true;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                    if (!bl) break;
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    break;
                }
                case '/': {
                    if (n2 <= 1 || !this.isFolder()) break;
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                    this.substituteText(jTextComponent, this.substitutionOffset, n2, SLASH);
                    keyEvent.consume();
                    Completion.get().showCompletion();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (this.supportInstantSubst) {
            this.defaultAction(jTextComponent);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightText(false, File.separator), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)(PARENT_COLOR_TAG + this.getRightText(true, File.separator)), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isFolder() ? "[D] " : "[F] ");
        stringBuilder.append(this.isSysInclude() ? SYS_OPEN : QUOTE);
        stringBuilder.append(this.getLeftHtmlText(false));
        stringBuilder.append(this.isSysInclude() ? SYS_CLOSE : QUOTE);
        stringBuilder.append(" : ");
        stringBuilder.append(this.getRightText(false, SLASH));
        return stringBuilder.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.item;
    }

    public CharSequence getInsertPrefix() {
        return this.item;
    }

    protected ImageIcon getIcon() {
        return CsmImageLoader.getIncludeImageIcon((boolean)this.isSysInclude(), (boolean)this.isFolder());
    }

    protected String getLeftHtmlText(boolean bl) {
        return (bl ? (this.isFolder() ? "<i>" : "") : "") + this.getItemText();
    }

    protected String getRightText(boolean bl, String string) {
        return CsmDisplayUtilities.shrinkPath((CharSequence)(this.getParentFolder() + string + this.getChildSubdir()), (boolean)bl, (String)string, (int)35, (int)2, (int)2);
    }

    protected void substituteText(final JTextComponent jTextComponent, final int n, final int n2, final String string) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final String string2 = this.getItemText();
        if (string2 != null) {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        String string5;
                        int n3 = n2;
                        String string22 = string2;
                        if (string != null) {
                            string22 = string22 + string;
                        }
                        TokenItem tokenItem = CndTokenUtilities.getToken((Document)baseDocument, (int)n, (boolean)true);
                        String string3 = CsmIncludeCompletionItem.QUOTE;
                        String string4 = CsmIncludeCompletionItem.QUOTE;
                        if (tokenItem != null) {
                            boolean bl = false;
                            switch ((CppTokenId)tokenItem.id()) {
                                case WHITESPACE: 
                                case PREPROCESSOR_IDENTIFIER: {
                                    string3 = CsmIncludeCompletionItem.this.isSysInclude ? CsmIncludeCompletionItem.SYS_OPEN : CsmIncludeCompletionItem.QUOTE;
                                    string4 = CsmIncludeCompletionItem.this.isSysInclude ? CsmIncludeCompletionItem.SYS_CLOSE : CsmIncludeCompletionItem.QUOTE;
                                    break;
                                }
                                case PREPROCESSOR_USER_INCLUDE: {
                                    string3 = CsmIncludeCompletionItem.QUOTE;
                                    string4 = CsmIncludeCompletionItem.QUOTE;
                                    bl = true;
                                    break;
                                }
                                case PREPROCESSOR_SYS_INCLUDE: {
                                    string3 = CsmIncludeCompletionItem.SYS_OPEN;
                                    string4 = CsmIncludeCompletionItem.SYS_CLOSE;
                                    bl = true;
                                }
                            }
                            if (bl) {
                                n3 = tokenItem.offset() + tokenItem.length() - n - (tokenItem.partType() == PartType.COMPLETE ? 0 : 1);
                            }
                        }
                        if ((string5 = CsmIncludeCompletionItem.this.getChildSubdir()).length() > 0 && !string5.endsWith(CsmIncludeCompletionItem.SLASH)) {
                            string5 = string5 + CsmIncludeCompletionItem.SLASH;
                        }
                        string22 = string3 + string5 + string22 + string4;
                        Position position = baseDocument.createPosition(n);
                        Position position2 = baseDocument.createPosition(n + n3);
                        baseDocument.remove(n, n3);
                        baseDocument.insertString(position.getOffset(), string22, null);
                        if (jTextComponent != null && CsmIncludeCompletionItem.this.isFolder()) {
                            jTextComponent.setCaretPosition(position2.getOffset() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected boolean isFolder() {
        return this.isFolder;
    }

    protected String getParentFolder() {
        return this.parentFolder;
    }

    protected String getChildSubdir() {
        return this.childSubdir;
    }

    protected boolean isSysInclude() {
        return this.isSysInclude;
    }
}

