/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.TreeTableOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.OptionsViewAction;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.nodes.Node;

public class OptionsOperator
extends NbDialogOperator {
    public static final int USER_LEVEL = 2;
    public static final int DEFAULT_LEVEL = 3;
    private static final Action invokeAction = new OptionsViewAction();
    private static final long BEFORE_EDITING_TIMEOUT = 2000L;
    private static int DEFINE_HERE = 0;
    private static final String CLASSIC_VIEW_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.options.Bundle", "CTL_Classic");
    private static final String MODERN_VIEW_LABEL = Bundle.getStringTrimmed("org.netbeans.modules.options.Bundle", "CTL_Modern");
    private Component sourceInternal;
    private static final ComponentChooser optionsSubchooser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionsOperator() {
        super(OptionsOperator.waitJDialog((ComponentChooser)optionsSubchooser));
        String string = Bundle.getString("org.netbeans.modules.options.Bundle", "CTL_Loading_Options");
        long l = this.getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
        try {
            this.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 5000L);
            new JLabelOperator((ContainerOperator)this, string).waitComponentShowing(false);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
        }
        finally {
            this.getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", l);
        }
    }

    public static OptionsOperator invoke() {
        invokeAction.perform();
        return new OptionsOperator();
    }

    public JButtonOperator btClassicView() {
        return new JButtonOperator((ContainerOperator)this, CLASSIC_VIEW_LABEL);
    }

    public JButtonOperator btModernView() {
        return new JButtonOperator((ContainerOperator)this, MODERN_VIEW_LABEL);
    }

    public TreeTableOperator treeTable() {
        return new TreeTableOperator((ContainerOperator)this);
    }

    public int selectOption(String string) {
        TreePath treePath = this.treeTable().tree().findPath(string, "|");
        if (!this.treeTable().tree().isPathSelected(treePath)) {
            this.treeTable().tree().selectPath(treePath);
        }
        int n = this.treeTable().tree().getRowForPath(treePath);
        this.treeTable().scrollToCell(n, 0);
        new EventTool().waitNoEvent(500L);
        return n;
    }

    public PropertySheetOperator getPropertySheet(String string) {
        this.selectOption(string);
        final String string2 = this.treeTable().tree().getSelectionPath().getLastPathComponent().toString();
        try {
            return (PropertySheetOperator)((Object)new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    PropertySheetOperator propertySheetOperator = new PropertySheetOperator((ContainerOperator)((OptionsOperator)((Object)object)));
                    return propertySheetOperator.getDescriptionHeader().equals(string2) ? propertySheetOperator : null;
                }

                public String getDescription() {
                    return "Wait Property sheet for \"" + string2 + "\" is showing.";
                }
            }).waitAction((Object)this));
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public void showLevels() {
        if (this.treeTable().getColumnCount() == 2) {
            this.clickOnSecondHeader();
        }
    }

    public void hideLevels() {
        if (this.treeTable().getColumnCount() > 2) {
            this.clickOnSecondHeader();
        }
    }

    public void setLevel(String string, final int n) {
        this.showLevels();
        int n2 = this.getLevel(string);
        this.getOutput().printLine("Setting " + n + " level for \"" + string + "\" option. \nCurrent level: " + n2);
        final int n3 = this.selectOption(string);
        if (n > n2) {
            this.produceNoBlocking(new Operator.NoBlockingAction("Setting property definition level"){

                public Object doAction(Object object) {
                    OptionsOperator.this.setLevel(n3, n);
                    return null;
                }
            });
            JDialogOperator jDialogOperator = new JDialogOperator(Bundle.getString("org.openide.Bundle", "NTF_QuestionTitle"));
            new JButtonOperator((ContainerOperator)jDialogOperator, Bundle.getString("org.openide.Bundle", "CTL_YES")).push();
        } else if (n < n2) {
            this.setLevel(n3, n);
        }
    }

    public int getLevel(String string) {
        int n = this.selectOption(string);
        if (this.getValue(n, 2) == DEFINE_HERE) {
            return 2;
        }
        if (this.getValue(n, 3) == DEFINE_HERE) {
            return 3;
        }
        return -1;
    }

    public void setUserLevel(String string) {
        this.setLevel(string, 2);
    }

    public void setDefaultLevel(String string) {
        this.setLevel(string, 3);
    }

    protected void setLevel(int n, int n2) {
        if (n2 == 2) {
            this.defineHere(n, n2);
        } else if (n2 == 3) {
            this.revertLevel(n, n2);
        }
    }

    protected int getValue(int n, int n2) {
        try {
            Node.Property property = (Node.Property)this.treeTable().getValueAt(n, n2);
            return (Integer)property.getValue();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JemmyException("Can not access value!", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JemmyException("Can not access value!", (Throwable)invocationTargetException);
        }
    }

    protected void revertLevel(int n, int n2) {
        this.editLevel(n, n2, Bundle.getString("org.netbeans.modules.options.classic.Bundle", "LBL_action_revert"));
    }

    protected void defineHere(int n, int n2) {
        this.editLevel(n, n2, Bundle.getString("org.netbeans.modules.options.classic.Bundle", "LBL_action_define"));
    }

    protected void editLevel(int n, int n2, String string) {
        Point point = this.treeTable().getPointToClick(n, n2);
        this.treeTable().clickOnCell(n, n2);
        JComboBoxOperator jComboBoxOperator = new JComboBoxOperator((ContainerOperator)this.treeTable());
        this.getTimeouts().sleep("OptionsOperator.BeforeEditingTimeout");
        jComboBoxOperator.selectItem(string);
    }

    protected void clickOnSecondHeader() {
        JTableHeader jTableHeader = this.treeTable().getTableHeader();
        Rectangle rectangle = jTableHeader.getHeaderRect(1);
        new ComponentOperator((Component)jTableHeader).clickMouse(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, 1);
    }

    public void switchToClassicView() {
        if (JButtonOperator.findJButton((Container)((Container)this.getSource()), (String)CLASSIC_VIEW_LABEL, (boolean)true, (boolean)true) != null) {
            this.btClassicView().push();
        }
        this.sourceInternal = new OptionsOperator().getSource();
    }

    public Component getSource() {
        if (this.sourceInternal == null) {
            this.sourceInternal = super.getSource();
        }
        return this.sourceInternal;
    }

    public void switchToModernView() {
        if (JButtonOperator.findJButton((Container)((Container)this.getSource()), (String)MODERN_VIEW_LABEL, (boolean)true, (boolean)true) != null) {
            this.btModernView().push();
        }
        this.sourceInternal = new OptionsOperator().getSource();
    }

    public void selectCategory(final String string) {
        final Operator.StringComparator stringComparator = this.getComparator();
        new JLabelOperator((ContainerOperator)this, new ComponentChooser(){

            public boolean checkComponent(Component component) {
                if ((component.getClass().getName().equals("org.netbeans.modules.options.OptionsPanel$CategoryButton") || component.getClass().getName().equals("org.netbeans.modules.options.OptionsPanel$NimbusCategoryButton")) && ((JLabel)component).getText() != null) {
                    return stringComparator.equals(((JLabel)component).getText(), string);
                }
                return false;
            }

            public String getDescription() {
                return "OptionsPanel$CategoryButton with text " + string;
            }
        }).clickMouse();
    }

    public void selectGeneral() {
        Bundle.getStringTrimmed("org.netbeans.modules.options.advanced.Bundle", "CTL_Advanced_Options");
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.core.ui.options.general.Bundle", "CTL_General_Options"));
    }

    public void selectEditor() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.editor.Bundle", "CTL_Editor"));
    }

    public void selectFontAndColors() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.colors.Bundle", "CTL_Font_And_Color_Options"));
    }

    public void selectKeymap() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.keymap.Bundle", "CTL_Keymap_Options"));
    }

    public void selectMiscellaneous() {
        this.selectCategory(Bundle.getStringTrimmed("org.netbeans.modules.options.advanced.Bundle", "CTL_Advanced_Options"));
    }

    public void verify() {
        this.btClose();
        this.btHelp();
        this.treeTable().verify();
    }

    static {
        Timeouts.initDefault((String)"OptionsOperator.BeforeEditingTimeout", (long)2000L);
        optionsSubchooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return null != new ComponentSearcher((Container)component).findComponent(new ComponentChooser(){

                    public boolean checkComponent(Component component) {
                        return component.getClass().getName().endsWith("OptionsPanel");
                    }

                    public String getDescription() {
                        return "org.netbeans.modules.options.OptionsPanel";
                    }
                });
            }

            public String getDescription() {
                return "Options";
            }
        };
    }
}

