/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.FindAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;

public class OutputTabOperator
extends JComponentOperator {
    ComponentOperator outputPaneOperator;
    private static final Action findNextAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_FIND_NEXT"), null, KeyStroke.getKeyStroke(114, 0));
    private static final Action selectAllAction = new Action(null, null, null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(65, 4) : KeyStroke.getKeyStroke(65, 2));
    private static final Action wrapTextAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_WRAP"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(87, 4) : KeyStroke.getKeyStroke(87, 2));
    private static final ActionNoBlock saveAsAction = new ActionNoBlock(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_SAVEAS"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(83, 4) : KeyStroke.getKeyStroke(83, 2));
    private static final Action nextErrorAction = new Action(null, null, null, KeyStroke.getKeyStroke(123, 0));
    private static final Action previousErrorAction = new Action(null, null, null, KeyStroke.getKeyStroke(123, 1));
    private static final Action closeAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_CLOSE"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(115, 4) : KeyStroke.getKeyStroke(115, 2));
    private static final Action clearAction = new Action(null, Bundle.getString("org.netbeans.core.output2.Bundle", "ACTION_CLEAR"), null, System.getProperty("os.name").toLowerCase().indexOf("mac") > -1 ? KeyStroke.getKeyStroke(76, 4) : KeyStroke.getKeyStroke(76, 2));
    private static final CopyAction copyAction = new CopyAction();
    private static final FindAction findAction = new FindAction();

    public OutputTabOperator(JComponent jComponent) {
        super(jComponent);
    }

    public OutputTabOperator(String string) {
        this(string, 0);
    }

    public OutputTabOperator(String string, int n) {
        super((JComponent)new OutputOperator().waitSubComponent(new OutputTabSubchooser(string), n));
        this.makeComponentVisible();
    }

    public void makeComponentVisible() {
        if (this.getParent() instanceof JTabbedPane) {
            super.makeComponentVisible();
            new JTabbedPaneOperator((JTabbedPane)this.getParent()).setSelectedComponent(this.getSource());
        } else {
            new OutputOperator().makeComponentVisible();
        }
    }

    public int getLength() {
        return this.runMapping(new Operator.MapIntegerAction("getLength"){

            public int map() {
                Document document = ((AbstractOutputTab)OutputTabOperator.this.getSource()).getOutputPane().getDocument();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.core.output2.OutputDocument");
                    Method method = clazz.getDeclaredMethod("getLength", null);
                    method.setAccessible(true);
                    return (Integer)method.invoke((Object)document, (Object[])null);
                }
                catch (Exception exception) {
                    throw new JemmyException("getLength() by reflection failed.", (Throwable)exception);
                }
            }
        });
    }

    public int findLine(String string) {
        int n = this.getLineCount();
        if (n < 1) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.getComparator().equals(this.getLine(i), string)) continue;
            return i;
        }
        return -1;
    }

    public String getText() {
        final int n = this.getLength();
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                Document document = ((AbstractOutputTab)OutputTabOperator.this.getSource()).getOutputPane().getDocument();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.core.output2.OutputDocument");
                    Method method = clazz.getDeclaredMethod("getText", Integer.TYPE, Integer.TYPE);
                    method.setAccessible(true);
                    return method.invoke((Object)document, new Integer(0), new Integer(n)).toString();
                }
                catch (Exception exception) {
                    throw new JemmyException("Getting text by reflection failed.", (Throwable)exception);
                }
            }
        });
    }

    public String getText(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append(this.getLine(i));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void waitText(final String string) {
        this.getOutput().printLine("Wait \"" + string + "\" text in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" text");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return OutputTabOperator.this.findLine(string) > -1;
            }

            public String getDescription() {
                return "\"" + string + "\" text";
            }
        });
    }

    public int getLineCount() {
        return (Integer)this.runMapping(new Operator.MapAction("getLineCount"){

            public Object map() {
                Document document = ((AbstractOutputTab)OutputTabOperator.this.getSource()).getOutputPane().getDocument();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.core.output2.OutputDocument");
                    Method method = clazz.getDeclaredMethod("getElementCount", null);
                    method.setAccessible(true);
                    return (Integer)method.invoke((Object)document, (Object[])null);
                }
                catch (Exception exception) {
                    throw new JemmyException("getElementCount() by reflection failed.", (Throwable)exception);
                }
            }
        });
    }

    public ComponentOperator outputPaneOperator() {
        this.makeComponentVisible();
        if (this.outputPaneOperator == null) {
            this.outputPaneOperator = ComponentOperator.createOperator((Component)((AbstractOutputTab)this.getSource()).getOutputPane());
            this.outputPaneOperator.copyEnvironment((Operator)this);
        }
        return this.outputPaneOperator;
    }

    public String getLine(final int n) {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                Document document = ((AbstractOutputTab)OutputTabOperator.this.getSource()).getOutputPane().getDocument();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.core.output2.OutputDocument");
                    Method method = clazz.getDeclaredMethod("getLineStart", Integer.TYPE);
                    method.setAccessible(true);
                    Integer n3 = (Integer)method.invoke((Object)document, new Integer(n));
                    Method method2 = clazz.getDeclaredMethod("getLineEnd", Integer.TYPE);
                    method2.setAccessible(true);
                    Integer n2 = (Integer)method2.invoke((Object)document, new Integer(n));
                    if (n3.intValue() == n2.intValue()) {
                        return "";
                    }
                    Method method3 = clazz.getDeclaredMethod("getText", Integer.TYPE, Integer.TYPE);
                    method3.setAccessible(true);
                    return method3.invoke((Object)document, n3, new Integer(n2 - n3)).toString();
                }
                catch (Exception exception) {
                    throw new JemmyException("Getting text by reflection failed.", (Throwable)exception);
                }
            }
        });
    }

    public void verify() {
        this.outputPaneOperator();
    }

    public void copy() {
        copyAction.perform(this.outputPaneOperator());
    }

    public void find() {
        findAction.perform(this.outputPaneOperator());
    }

    public void findNext() {
        findNextAction.perform(this.outputPaneOperator());
    }

    public void nextError() {
        nextErrorAction.perform(this.outputPaneOperator());
    }

    public void previousError() {
        previousErrorAction.perform(this.outputPaneOperator());
    }

    public void wrapText() {
        wrapTextAction.perform(this.outputPaneOperator());
    }

    public void saveAs() {
        saveAsAction.perform(this.outputPaneOperator());
    }

    public void close() {
        closeAction.perform(this.outputPaneOperator());
    }

    public void clear() {
        clearAction.perform(this.outputPaneOperator());
    }

    public void selectAll() {
        selectAllAction.perform(this.outputPaneOperator());
    }

    protected static final class OutputTabSubchooser
    implements ComponentChooser {
        private String tabName = null;

        public OutputTabSubchooser() {
        }

        public OutputTabSubchooser(String string) {
            this.tabName = string;
        }

        public boolean checkComponent(Component component) {
            if (component.getClass().getName().endsWith("OutputTab")) {
                return Operator.getDefaultStringComparator().equals(component.getName(), this.tabName);
            }
            return false;
        }

        public String getDescription() {
            return "org.netbeans.core.output2.OutputTab" + (this.tabName != null ? " with \"" + this.tabName + "\" name" : "");
        }
    }
}

