/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.KeyNode;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesFileEntry
extends PresentableFileEntry
implements CookieSet.Factory {
    static final Logger LOG = Logger.getLogger(PropertiesFileEntry.class.getName());
    private String basicName;
    private transient StructHandler propStruct;
    private transient PropertiesEditorSupport editorSupport;
    transient Object atomicUndoRedoFlag;
    static final long serialVersionUID = -3882240297814143015L;

    PropertiesFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
        FileObject fileObject2;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("new PropertiesFileEntry(<MultiDataObject>, " + FileUtil.getFileDisplayName((FileObject)fileObject) + ')');
            LOG.finer("  - new PresentableFileEntry(<MultiDataObject>, " + FileUtil.getFileDisplayName((FileObject)fileObject) + ')');
        }
        this.basicName = (fileObject2 = this.getDataObject().getPrimaryFile()) == null ? this.getFile().getName() : fileObject2.getName();
        this.getCookieSet().add(PropertiesEditorSupport.class, (CookieSet.Factory)this);
    }

    public FileObject copy(FileObject fileObject, String string) throws IOException {
        String string2;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("copy(" + FileUtil.getFileDisplayName((FileObject)fileObject) + ", " + (string != null ? '\"' + string + '\"' : "<null>") + ')');
        }
        if ((string2 = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix()) == null) {
            return super.copy(fileObject, string);
        }
        FileObject fileObject2 = this.getFile();
        String string3 = this.getDataObject().getPrimaryFile().getName();
        String string4 = string3 + string2 + Util.getLocaleSuffix((MultiDataObject.Entry)this);
        return fileObject2.copy(fileObject, string4, fileObject2.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("delete()");
        }
        this.getHandler().stopParsing();
        try {
            super.delete();
        }
        finally {
            this.getHandler().allowParsing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileObject fileObject, String string) throws IOException {
        String string2;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("move(" + FileUtil.getFileDisplayName((FileObject)fileObject) + ", " + (string != null ? '\"' + string + '\"' : "<null>") + ')');
        }
        if ((string2 = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix()) == null) {
            return super.move(fileObject, string);
        }
        boolean bl = this.isLocked();
        FileObject fileObject2 = this.getFile();
        FileLock fileLock = this.takeLock();
        try {
            String string3 = this.getDataObject().getPrimaryFile().getName();
            String string4 = string3 + string2 + Util.getLocaleSuffix((MultiDataObject.Entry)this);
            FileObject fileObject3 = fileObject2.move(fileLock, fileObject, string4, fileObject2.getExt());
            return fileObject3;
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)this.getPropertiesEditor();
        }
        return null;
    }

    @Override
    protected Node createNodeDelegate() {
        return new PropertiesLocaleNode(this);
    }

    public Children getChildren() {
        return new PropKeysChildren();
    }

    public StructHandler getHandler() {
        if (this.propStruct == null) {
            this.propStruct = new StructHandler(this);
        }
        return this.propStruct;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesEditorSupport getPropertiesEditor() {
        PropertiesFileEntry propertiesFileEntry = this;
        synchronized (propertiesFileEntry) {
            if (this.editorSupport == null) {
                this.editorSupport = new PropertiesEditorSupport(this);
            }
        }
        return this.editorSupport;
    }

    @Override
    public FileObject rename(String string) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("rename(" + string + ')');
        }
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader/rename.");
        }
        FileObject fileObject = super.rename(string + this.getFile().getName().substring(this.basicName.length()));
        this.basicName = string;
        return fileObject;
    }

    @Override
    public FileObject renameEntry(String string) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader / rename");
        }
        if (this.basicName.equals(this.getFile().getName())) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getBundle(PropertiesDataLoader.class).getString("MSG_AttemptToRenamePrimaryFile"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return this.getFile();
        }
        FileObject fileObject = super.rename(string);
        ((PropertiesDataObject)this.getDataObject()).getBundleStructure().notifyOneFileChanged(this.getHandler());
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        byte[] byArray;
        int n;
        OutputStream outputStream;
        InputStream inputStream;
        String string2;
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties createFromTemplate");
        }
        String string3 = this.getFile().getName().substring(this.basicName.length());
        String string4 = string + string3;
        FileObject fileObject2 = fileObject.getFileObject(string4, string2 = this.getFile().getExt());
        if (fileObject2 == null) {
            return super.createFromTemplate(fileObject, string4);
        }
        byte[] byArray2 = new byte[4096];
        FileLock fileLock = fileObject2.lock();
        try {
            inputStream = fileObject2.getInputStream();
            try {
                outputStream = new ByteArrayOutputStream((int)fileObject2.getSize());
                try {
                    while ((n = inputStream.read(byArray2)) != -1) {
                        ((ByteArrayOutputStream)outputStream).write(byArray2, 0, n);
                    }
                }
                finally {
                    byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                    ((ByteArrayOutputStream)outputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
            fileObject2.delete(fileLock);
        }
        finally {
            fileLock.releaseLock();
        }
        inputStream = fileObject.createData(string4, string2);
        fileLock = inputStream.lock();
        try {
            outputStream = inputStream.getOutputStream(fileLock);
            try {
                outputStream.write(byArray);
                InputStream inputStream2 = this.getFile().getInputStream();
                try {
                    while ((n = inputStream2.read(byArray2)) != -1) {
                        outputStream.write(byArray2, 0, n);
                    }
                }
                finally {
                    inputStream2.close();
                }
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
        return inputStream;
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.getFile().canWrite() && !this.basicName.equals(this.getFile().getName());
    }

    @Override
    public boolean isCopyAllowed() {
        return true;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.getFile().canWrite() && this.getDataObject().getPrimaryEntry() != this;
    }

    @Override
    public boolean isRenameAllowed() {
        return this.getFile().canWrite();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("propfiles.creating");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropKeysChildren
    extends Children.Keys<String> {
        private PropertyBundleListener bundleListener = null;

        PropKeysChildren() {
        }

        private void mySetKeys() {
            TreeSet<String> treeSet = new TreeSet<String>(new KeyComparator());
            PropertiesStructure propertiesStructure = PropertiesFileEntry.this.getHandler().getStructure();
            if (propertiesStructure != null) {
                Iterator<Element.ItemElem> iterator = propertiesStructure.allItems();
                while (iterator.hasNext()) {
                    Element.ItemElem itemElem = iterator.next();
                    if (itemElem == null || itemElem.getKey() == null) continue;
                    treeSet.add(itemElem.getKey());
                }
            }
            this.setKeys(treeSet);
        }

        protected void addNotify() {
            this.mySetKeys();
            this.bundleListener = new PropertyBundleListener(){

                public void bundleChanged(PropertyBundleEvent propertyBundleEvent) {
                    int n = propertyBundleEvent.getChangeType();
                    if (n == 1 || n == 2) {
                        PropKeysChildren.this.mySetKeys();
                    } else if (n == 3 && propertyBundleEvent.getEntryName().equals(PropertiesFileEntry.this.getFile().getName())) {
                        PropKeysChildren.this.mySetKeys();
                    }
                }
            };
            this.bundleStructure().addPropertyBundleListener(this.bundleListener);
        }

        protected void removeNotify() {
            this.bundleStructure().removePropertyBundleListener(this.bundleListener);
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String string) {
            return new Node[]{new KeyNode(PropertiesFileEntry.this.getHandler().getStructure(), string)};
        }

        private BundleStructure bundleStructure() {
            return ((PropertiesDataObject)PropertiesFileEntry.this.getDataObject()).getBundleStructure();
        }
    }
}

