/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCParameter;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;
import org.netbeans.modules.db.metadata.model.spi.ProcedureImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCProcedure
extends ProcedureImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCProcedure.class.getName());
    private final JDBCSchema jdbcSchema;
    private final String name;
    private Map<String, Column> columns;
    private Map<String, Parameter> parameters;
    private Value returnValue;

    public JDBCProcedure(JDBCSchema jDBCSchema, String string) {
        this.jdbcSchema = jDBCSchema;
        this.name = string;
    }

    @Override
    public final Schema getParent() {
        return this.jdbcSchema.getSchema();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String string) {
        return MetadataUtilities.find(string, this.initColumns());
    }

    @Override
    public final void refresh() {
        this.columns = null;
        this.parameters = null;
    }

    @Override
    public Collection<Parameter> getParameters() {
        return this.initParameters().values();
    }

    @Override
    public Parameter getParameter(String string) {
        return this.initParameters().get(string);
    }

    @Override
    public Value getReturnValue() {
        return this.initReturnValue();
    }

    public String toString() {
        return "JDBCProcedure[name='" + this.name + "']";
    }

    protected JDBCColumn createJDBCColumn(int n, ResultSet resultSet) throws SQLException {
        return new JDBCColumn(this.getProcedure(), n, JDBCValue.createProcedureValue(resultSet));
    }

    protected JDBCParameter createJDBCParameter(int n, ResultSet resultSet) throws SQLException {
        Parameter.Direction direction = JDBCUtils.getDirection(resultSet.getShort("COLUMN_TYPE"));
        return new JDBCParameter(this, JDBCValue.createProcedureValue(resultSet), direction, n);
    }

    protected JDBCValue createJDBCValue(ResultSet resultSet) throws SQLException {
        return JDBCValue.createProcedureValue(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createProcedureInfo() {
        LOGGER.log(Level.FINE, "Initializing procedure info in " + this);
        LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Parameter> linkedHashMap2 = new LinkedHashMap<String, Parameter>();
        int n = 0;
        int n2 = 0;
        try {
            ResultSet resultSet = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getProcedureColumns(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, "%");
            try {
                block10: while (resultSet.next()) {
                    short s = resultSet.getShort("COLUMN_TYPE");
                    switch (s) {
                        case 3: {
                            this.addColumn(++n, resultSet, linkedHashMap);
                            continue block10;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 4: {
                            this.addParameter(++n2, resultSet, linkedHashMap2);
                            continue block10;
                        }
                        case 5: {
                            this.setReturnValue(resultSet);
                            continue block10;
                        }
                    }
                    LOGGER.log(Level.INFO, "Encountered unexpected column type " + s + " when retrieving metadadta for procedure " + this.name);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.columns = Collections.unmodifiableMap(linkedHashMap);
        this.parameters = Collections.unmodifiableMap(linkedHashMap2);
    }

    private void addColumn(int n, ResultSet resultSet, Map<String, Column> map) throws SQLException {
        Column column = this.createJDBCColumn(n, resultSet).getColumn();
        map.put(column.getName(), column);
        LOGGER.log(Level.FINE, "Created column {0}", column);
    }

    private void addParameter(int n, ResultSet resultSet, Map<String, Parameter> map) throws SQLException {
        Parameter parameter = this.createJDBCParameter(n, resultSet).getParameter();
        map.put(parameter.getName(), parameter);
        LOGGER.log(Level.FINE, "Created parameter {0}", parameter);
    }

    private void setReturnValue(ResultSet resultSet) throws SQLException {
        this.returnValue = this.createJDBCValue(resultSet).getValue();
        LOGGER.log(Level.FINE, "Created return value {0}", this.returnValue);
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.createProcedureInfo();
        return this.columns;
    }

    private Map<String, Parameter> initParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.createProcedureInfo();
        return this.parameters;
    }

    private Value initReturnValue() {
        if (this.returnValue != null) {
            return this.returnValue;
        }
        this.createProcedureInfo();
        return this.returnValue;
    }
}

