/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.config.model.Action;
import org.netbeans.modules.web.struts.dialogs.BrowseFolders;
import org.netbeans.modules.web.struts.dialogs.ValidatingPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddFIActionPanel
extends JPanel
implements ValidatingPanel {
    private StrutsConfigDataObject config;
    private JButton bBrowse;
    private ButtonGroup bgActionType;
    private ButtonGroup bgCall;
    private JComboBox cbAction;
    private JLabel jLabelPath;
    private JPopupMenu jPopupMenu1;
    private JTextField jTextFieldPath;
    private JLabel lActionType;
    private JLabel lCall;
    private JRadioButton rbAction;
    private JRadioButton rbForwardAction;
    private JRadioButton rbIncludeAction;
    private JRadioButton rbResourceFile;
    private JTextField tResourceFile;

    public AddFIActionPanel(StrutsConfigDataObject strutsConfigDataObject) {
        this.config = strutsConfigDataObject;
        this.initComponents();
        List list = StrutsConfigUtilities.getAllActionsInModule(this.config);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cbAction.getModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement(((Action)((Object)iterator.next())).getAttributeValue("path"));
        }
    }

    public String validatePanel() {
        String string = this.getActionPath();
        if (string == null || string.equals("/")) {
            return NbBundle.getMessage(AddFIActionPanel.class, (String)"MSG_EmptyActionPath");
        }
        if (!string.startsWith("/")) {
            return NbBundle.getMessage(AddFIActionPanel.class, (String)"MSG_IncorrectActionPath", (Object)string);
        }
        if (this.containsActionPath(string)) {
            return NbBundle.getMessage(AddFIActionPanel.class, (String)"MSG_DupliciteActionPath", (Object)string);
        }
        if (this.rbResourceFile.isSelected() && this.tResourceFile.getText().trim().length() == 0) {
            return NbBundle.getMessage(AddFIActionPanel.class, (String)"MSG_EmptyResourceFile");
        }
        if (this.rbAction.isSelected() && this.cbAction.getSelectedItem() == null) {
            return NbBundle.getMessage(AddFIActionPanel.class, (String)"MSG_EmptyAction");
        }
        return null;
    }

    public AbstractButton[] getStateChangeComponents() {
        return new AbstractButton[]{this.rbResourceFile};
    }

    public JTextComponent[] getDocumentChangeComponents() {
        return new JTextComponent[]{this.jTextFieldPath, this.tResourceFile};
    }

    private void initComponents() {
        this.bgActionType = new ButtonGroup();
        this.bgCall = new ButtonGroup();
        this.jPopupMenu1 = new JPopupMenu();
        this.lActionType = new JLabel();
        this.rbIncludeAction = new JRadioButton();
        this.rbForwardAction = new JRadioButton();
        this.lCall = new JLabel();
        this.rbResourceFile = new JRadioButton();
        this.rbAction = new JRadioButton();
        this.tResourceFile = new JTextField();
        this.bBrowse = new JButton();
        this.cbAction = new JComboBox();
        this.jLabelPath = new JLabel();
        this.jTextFieldPath = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.lActionType.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_ActionType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lActionType, gridBagConstraints);
        this.bgActionType.add(this.rbIncludeAction);
        this.rbIncludeAction.setMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Include_mnem").charAt(0));
        this.rbIncludeAction.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Include"));
        this.rbIncludeAction.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 20, 0, 0);
        this.add((Component)this.rbIncludeAction, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle");
        this.rbIncludeAction.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_rbIncudeAction"));
        this.bgActionType.add(this.rbForwardAction);
        this.rbForwardAction.setMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Forward_mnem").charAt(0));
        this.rbForwardAction.setSelected(true);
        this.rbForwardAction.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Forward"));
        this.rbForwardAction.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 20, 0, 0);
        this.add((Component)this.rbForwardAction, gridBagConstraints);
        this.rbForwardAction.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_rbForwardAction"));
        this.lCall.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_Call"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lCall, gridBagConstraints);
        this.bgCall.add(this.rbResourceFile);
        this.rbResourceFile.setMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_ResourceFile_mnem").charAt(0));
        this.rbResourceFile.setSelected(true);
        this.rbResourceFile.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_ResourceFile"));
        this.rbResourceFile.setMargin(new Insets(0, 0, 0, 0));
        this.rbResourceFile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AddFIActionPanel.this.rbResourceFileItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 20, 0, 0);
        this.add((Component)this.rbResourceFile, gridBagConstraints);
        this.rbResourceFile.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_rbResourceFile2"));
        this.bgCall.add(this.rbAction);
        this.rbAction.setMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Action_mnem").charAt(0));
        this.rbAction.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"RB_Action"));
        this.rbAction.setMargin(new Insets(0, 0, 0, 0));
        this.rbAction.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AddFIActionPanel.this.rbActionItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 20, 0, 0);
        this.add((Component)this.rbAction, gridBagConstraints);
        this.rbAction.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_rbAction"));
        this.tResourceFile.setMinimumSize(new Dimension(200, 24));
        this.tResourceFile.setPreferredSize(new Dimension(200, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.tResourceFile, gridBagConstraints);
        this.tResourceFile.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_tResourceFile"));
        this.tResourceFile.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_tResourceFile"));
        this.bBrowse.setMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_Browse_mnem").charAt(0));
        this.bBrowse.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_BrowseButton"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddFIActionPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_bBrowse"));
        this.cbAction.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.cbAction, gridBagConstraints);
        this.cbAction.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddFIActionPanel.class, (String)"ACSN_FIAction"));
        this.cbAction.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_cbAction"));
        this.jLabelPath.setDisplayedMnemonic(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_ActionPath_mnem").charAt(0));
        this.jLabelPath.setLabelFor(this.jTextFieldPath);
        this.jLabelPath.setText(NbBundle.getMessage(AddFIActionPanel.class, (String)"LBL_ActionPath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelPath, gridBagConstraints);
        this.jTextFieldPath.setColumns(30);
        this.jTextFieldPath.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jTextFieldPath, gridBagConstraints);
        this.jTextFieldPath.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_jTextFieldPath"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AddFIActionPanel"));
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        try {
            SourceGroup[] sourceGroupArray = StrutsConfigUtilities.getDocBaseGroups(this.config.getPrimaryFile());
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null) {
                String string = "/" + StrutsConfigUtilities.getResourcePath(sourceGroupArray, fileObject, '/', true);
                this.tResourceFile.setText(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void rbResourceFileItemStateChanged(ItemEvent itemEvent) {
        this.tResourceFile.setEnabled(true);
        this.bBrowse.setEnabled(true);
        this.cbAction.setEnabled(false);
    }

    private void rbActionItemStateChanged(ItemEvent itemEvent) {
        this.tResourceFile.setEnabled(false);
        this.bBrowse.setEnabled(false);
        this.cbAction.setEnabled(true);
    }

    public String getActionPath() {
        String string = this.jTextFieldPath.getText().trim();
        return string.length() == 0 ? null : string;
    }

    public boolean isForward() {
        return this.rbForwardAction.isSelected();
    }

    public String getResource() {
        if (this.rbResourceFile.isSelected()) {
            String string = this.tResourceFile.getText().trim();
            return string.length() == 0 ? null : string;
        }
        return StrutsConfigUtilities.getActionAsResource(WebModule.getWebModule((FileObject)this.config.getPrimaryFile()), (String)this.cbAction.getSelectedItem());
    }

    private boolean containsActionPath(String string) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cbAction.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            if (!string.equals(defaultComboBoxModel.getElementAt(i))) continue;
            return true;
        }
        return false;
    }
}

