/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommandLineHelper;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.MacroMap;
import org.netbeans.modules.nativeexecution.support.UnbufferSupport;
import org.openide.util.NbBundle;

public final class LocalNativeProcess
extends AbstractNativeProcess {
    private Process process = null;
    private InputStream processOutput = null;
    private OutputStream processInput = null;
    private InputStream processError = null;

    public LocalNativeProcess(NativeProcessInfo nativeProcessInfo) {
        super(nativeProcessInfo);
    }

    protected void create() throws Throwable {
        boolean bl = this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        try {
            if (bl) {
                this.createWin();
            } else {
                this.createNonWin();
            }
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
            this.processOutput = new ByteArrayInputStream(new byte[0]);
            this.processError = new ByteArrayInputStream(string.getBytes());
            this.processInput = new ByteArrayOutputStream();
            throw throwable;
        }
    }

    private void createNonWin() throws IOException, InterruptedException {
        String string = this.info.getWorkingDirectory(true);
        if (string != null) {
            string = new File(string).getAbsolutePath();
            string = CommandLineHelper.getInstance(this.info.getExecutionEnvironment()).toShellPath(string);
        }
        MacroMap macroMap = this.info.getEnvVariables();
        UnbufferSupport.initUnbuffer(this.info, macroMap);
        String string2 = macroMap.get("PATH");
        macroMap.put("PATH", "/bin:/usr/bin:" + string2);
        ProcessBuilder processBuilder = new ProcessBuilder(this.hostInfo.getShell(), "-s");
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        this.process = processBuilder.start();
        this.processInput = this.process.getOutputStream();
        this.processError = this.process.getErrorStream();
        this.processOutput = this.process.getInputStream();
        this.processInput.write("echo $$\n".getBytes());
        this.processInput.flush();
        EnvWriter envWriter = new EnvWriter(this.processInput);
        envWriter.write(macroMap);
        if (string != null) {
            this.processInput.write(("cd " + string + "\n").getBytes());
        }
        String string3 = "exec " + this.info.getCommandLineForShell() + "\n";
        this.processInput.write(string3.getBytes());
        this.processInput.flush();
        this.readPID(this.processOutput);
    }

    private void createWin() throws IOException, InterruptedException {
        Object object;
        Object object2;
        MacroMap macroMap = this.info.getEnvVariables();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        UnbufferSupport.initUnbuffer(this.info, macroMap);
        processBuilder.command(this.info.getCommand());
        String string = null;
        if (!macroMap.isEmpty()) {
            object2 = macroMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string = macroMap.get((String)object);
                if (string == null) continue;
                processBuilder.environment().put((String)object, string);
            }
        }
        if ((object2 = this.info.getWorkingDirectory(true)) != null && ((File)(object = new File((String)object2))).exists()) {
            processBuilder.directory((File)object);
        }
        this.process = processBuilder.start();
        this.processInput = this.process.getOutputStream();
        this.processError = this.process.getErrorStream();
        this.processOutput = this.process.getInputStream();
        object = new ByteArrayInputStream("12345".getBytes());
        this.readPID((InputStream)object);
    }

    public OutputStream getOutputStream() {
        return this.processInput;
    }

    public InputStream getInputStream() {
        return this.processOutput;
    }

    public InputStream getErrorStream() {
        return this.processError;
    }

    public final int waitResult() throws InterruptedException {
        if (this.process == null) {
            throw new InterruptedException();
        }
        int n = -1;
        while (true) {
            Thread.sleep(200L);
            try {
                n = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
        return n;
    }

    protected final synchronized void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(LocalNativeProcess.class, (String)string, (Object[])stringArray);
    }
}

