/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommandLineHelper;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.CaseInsensitiveMacroMap;
import org.netbeans.modules.nativeexecution.support.MacroMap;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProcessInfo {
    public final MacroExpanderFactory.MacroExpander macroExpander;
    private final ExecutionEnvironment execEnv;
    private final boolean isWindows;
    private final MacroMap envVariables;
    private final List<String> arguments = new ArrayList<String>();
    private String executable;
    private String commandLine;
    private String workingDirectory;
    private boolean unbuffer;
    private boolean redirectError;
    private boolean x11forwarding;
    private Collection<ChangeListener> listeners = null;

    public NativeProcessInfo(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.executable = null;
        this.unbuffer = false;
        this.workingDirectory = null;
        this.macroExpander = MacroExpanderFactory.getExpander(executionEnvironment);
        this.envVariables = executionEnvironment.isLocal() && Utilities.isWindows() ? new CaseInsensitiveMacroMap(this.macroExpander) : new MacroMap(this.macroExpander);
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.isWindows = hostInfo != null && hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        this.redirectError = false;
    }

    public void addNativeProcessListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void redirectError(boolean bl) {
        this.redirectError = bl;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void setUnbuffer(boolean bl) {
        this.unbuffer = bl;
    }

    public boolean isUnbuffer() {
        return this.unbuffer;
    }

    public void setX11Forwarding(boolean bl) {
        this.x11forwarding = bl;
    }

    public boolean getX11Forwarding() {
        return this.x11forwarding;
    }

    public void addEnvironmentVariable(String string, String string2) {
        this.envVariables.put(string, string2);
    }

    public void addEnvironmentVariables(Map<String, String> map) {
        for (String string : map.keySet()) {
            this.addEnvironmentVariable(string, map.get(string));
        }
    }

    public void setArguments(String ... stringArray) {
        if (this.commandLine != null) {
            throw new IllegalStateException("commandLine is already defined. No additional parameters can be set");
        }
        this.arguments.clear();
        this.arguments.addAll(Arrays.asList(stringArray));
    }

    public List<String> getCommand() {
        String string;
        try {
            string = this.macroExpander.expandPredefinedMacros(this.executable);
        }
        catch (ParseException parseException) {
            string = this.executable;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (!this.arguments.isEmpty()) {
            arrayList.addAll(this.arguments);
        }
        return arrayList;
    }

    public String getCommandLineForShell() {
        String string;
        if (this.commandLine != null) {
            return this.commandLine;
        }
        try {
            string = this.macroExpander.expandPredefinedMacros(this.executable);
        }
        catch (ParseException parseException) {
            string = this.executable;
        }
        string = CommandLineHelper.getInstance(this.execEnv).toShellPath(string);
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!this.arguments.isEmpty()) {
            for (String string2 : this.arguments) {
                stringBuilder.append(" '").append(string2).append('\'');
            }
        }
        if (this.redirectError) {
            stringBuilder.append(" 2>&1");
        }
        return stringBuilder.toString().trim();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public Collection<ChangeListener> getListeners() {
        return this.listeners;
    }

    public String getWorkingDirectory(boolean bl) {
        String string;
        if (bl && this.macroExpander != null) {
            try {
                string = this.macroExpander.expandPredefinedMacros(this.workingDirectory);
            }
            catch (ParseException parseException) {
                string = this.workingDirectory;
            }
        }
        string = this.workingDirectory;
        return string;
    }

    public MacroMap getEnvVariables() {
        return this.getEnvVariables(null);
    }

    public MacroMap getEnvVariables(Map<String, String> map) {
        return this.envVariables;
    }
}

