/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.TerminalProfile;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ExternalTerminal {
    private static final ConcurrentHashMap<TermEnvPair, String> execCache = new ConcurrentHashMap();
    private final TerminalProfile profile;
    private String title = null;
    private String prompt = ExternalTerminal.loc("Terminal.DefaultPrompt.text", new String[0]);

    ExternalTerminal(TerminalProfile terminalProfile) throws IllegalArgumentException {
        this.profile = terminalProfile;
    }

    private ExternalTerminal(ExternalTerminal externalTerminal) {
        this.profile = externalTerminal.profile;
        this.title = externalTerminal.title;
        this.prompt = externalTerminal.prompt;
    }

    public boolean isAvailable(ExecutionEnvironment executionEnvironment) {
        return this.getExecutable(executionEnvironment) != null;
    }

    public ExternalTerminal setPrompt(String string) {
        ExternalTerminal externalTerminal = new ExternalTerminal(this);
        externalTerminal.prompt = string;
        return externalTerminal;
    }

    public ExternalTerminal setTitle(String string) {
        ExternalTerminal externalTerminal = new ExternalTerminal(this);
        externalTerminal.title = string;
        return externalTerminal;
    }

    private String getExecutable(ExecutionEnvironment executionEnvironment) {
        String string;
        TermEnvPair termEnvPair = new TermEnvPair(executionEnvironment, this.profile.getCommand());
        String string2 = execCache.get(termEnvPair);
        if (string2 == null && (string2 = executionEnvironment.isLocal() && Utilities.isWindows() ? this.profile.getCommand() : HostInfoUtils.searchFile(executionEnvironment, this.profile.getSearchPaths(), this.profile.getCommand(), true)) != null && (string = execCache.putIfAbsent(termEnvPair, string2)) != null) {
            string2 = string;
        }
        return string2;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(ExternalTerminal.class, (String)string, (Object[])stringArray);
    }

    static {
        ExternalTerminalAccessor.setDefault(new ExternalTerminalAccessorImpl());
    }

    private static class TermEnvPair {
        public final ExecutionEnvironment env;
        public final String termexec;

        public TermEnvPair(ExecutionEnvironment executionEnvironment, String string) {
            this.env = executionEnvironment;
            this.termexec = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TermEnvPair)) {
                throw new IllegalArgumentException();
            }
            TermEnvPair termEnvPair = (TermEnvPair)object;
            return ((Object)this.env).equals(termEnvPair.env) && this.termexec.equals(termEnvPair.termexec);
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this.env != null ? this.env.hashCode() : 0);
            n = 79 * n + (this.termexec != null ? this.termexec.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExternalTerminalAccessorImpl
    extends ExternalTerminalAccessor {
        private ExternalTerminalAccessorImpl() {
        }

        @Override
        public TerminalProfile getTerminalProfile(ExternalTerminal externalTerminal) {
            return externalTerminal.profile;
        }

        @Override
        public List<String> wrapCommand(ExecutionEnvironment executionEnvironment, ExternalTerminal externalTerminal, String ... stringArray) {
            CharSequence charSequence;
            String string = externalTerminal.title;
            if (string == null) {
                charSequence = new StringBuilder();
                for (String object : stringArray) {
                    ((StringBuilder)charSequence).append(object).append(' ');
                }
                string = ((StringBuilder)charSequence).toString().trim();
            }
            if ((charSequence = externalTerminal.getExecutable(executionEnvironment)) == null) {
                return Arrays.asList(stringArray);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(charSequence);
            for (String string2 : externalTerminal.profile.getArguments()) {
                if ("$@".equals(string2)) {
                    arrayList.addAll(Arrays.asList(stringArray));
                    continue;
                }
                if ("$shell".equals(string2)) {
                    try {
                        HostInfo cancellationException = HostInfoUtils.getHostInfo(executionEnvironment);
                        arrayList.add(cancellationException.getShell());
                        continue;
                    }
                    catch (IOException iOException) {
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                }
                if (string2.contains("$title")) {
                    string2 = string2.replace("$title", externalTerminal.title);
                }
                arrayList.add(string2);
            }
            return arrayList;
        }

        @Override
        public String getPrompt(ExternalTerminal externalTerminal) {
            return externalTerminal.prompt;
        }

        @Override
        public String getTitle(ExternalTerminal externalTerminal) {
            return externalTerminal.title;
        }

        @Override
        public String getExecutable(ExternalTerminal externalTerminal, ExecutionEnvironment executionEnvironment) {
            return externalTerminal.getExecutable(executionEnvironment);
        }
    }
}

