/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.security.acl.NotOwnerException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.ObservableAction;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestPrivilegesAction
extends ObservableAction<Boolean> {
    private static final ConcurrentHashMap<Key, RequestPrivilegesAction> cache = new ConcurrentHashMap();
    private final SPSCommonImpl support;
    private final List<String> requestedPrivileges;

    public static RequestPrivilegesAction getInstance(SPSCommonImpl sPSCommonImpl, List<String> list) {
        RequestPrivilegesAction requestPrivilegesAction;
        Key key = new Key(sPSCommonImpl, list);
        RequestPrivilegesAction requestPrivilegesAction2 = cache.get(key);
        if (requestPrivilegesAction2 == null && (requestPrivilegesAction = cache.putIfAbsent(key, requestPrivilegesAction2 = new RequestPrivilegesAction(sPSCommonImpl, list))) != null) {
            requestPrivilegesAction2 = requestPrivilegesAction;
        }
        return requestPrivilegesAction2;
    }

    private RequestPrivilegesAction(SPSCommonImpl sPSCommonImpl, List<String> list) {
        super(RequestPrivilegesAction.loc("TaskPrivilegesSupport_GrantPrivileges_Action", new String[0]));
        this.support = sPSCommonImpl;
        this.requestedPrivileges = list;
    }

    @Override
    public synchronized Boolean performAction() {
        if (this.support.isCanceled()) {
            return Boolean.FALSE;
        }
        try {
            this.support.requestPrivileges(this.requestedPrivileges, true);
        }
        catch (NotOwnerException notOwnerException) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(RequestPrivilegesAction.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        SolarisPrivilegesSupport support;
        List<String> requestedPrivileges;

        public Key(SolarisPrivilegesSupport solarisPrivilegesSupport, List<String> list) {
            this.support = solarisPrivilegesSupport;
            this.requestedPrivileges = list;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                throw new IllegalArgumentException();
            }
            Key key = (Key)object;
            return key.requestedPrivileges.containsAll(this.requestedPrivileges) && this.requestedPrivileges.containsAll(key.requestedPrivileges) && key.support == this.support;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.support != null ? this.support.hashCode() : 0);
            return n;
        }
    }
}

