/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class HostInfoImpl
implements HostInfo {
    private static final File hostinfoScript;
    private static final java.util.logging.Logger log;
    private static final String UNKNOWN = "UNKNOWN";
    private HostInfo.OS os;
    private HostInfo.CpuFamily cpuFamily;
    private String hostname;
    private String shell;
    private String tempDir;
    private int cpuNum;

    private HostInfoImpl() {
    }

    public static HostInfoImpl getHostInfo(ExecutionEnvironment executionEnvironment) throws IOException {
        HostInfoImpl hostInfoImpl = new HostInfoImpl();
        if (hostinfoScript == null) {
            throw new IOException("Unable to find hostinfo.sh script!");
        }
        Properties properties = executionEnvironment.isLocal() ? HostInfoImpl.getLocalHostInfo() : HostInfoImpl.getRemoteHostInfo(executionEnvironment);
        hostInfoImpl.init(properties);
        return hostInfoImpl;
    }

    private static Properties getLocalHostInfo() throws IOException {
        Properties properties = new Properties();
        try {
            int n;
            String string = "sh";
            if (Utilities.isWindows()) {
                string = WindowsSupport.getInstance().getShell();
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string, hostinfoScript.getAbsolutePath());
            String string2 = System.getProperty("java.io.tmpdir");
            if (Utilities.isWindows()) {
                string2 = WindowsSupport.getInstance().convertToShellPath(string2);
            }
            processBuilder.environment().put("TMPBASE", string2);
            processBuilder.environment().put("PATH", "/bin:/usr/bin");
            Process process = processBuilder.start();
            ArrayList<String> arrayList = new ArrayList<String>();
            InputStream inputStream = process.getErrorStream();
            if (inputStream != null) {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string3 = bufferedReader.readLine()) != null) {
                    arrayList.add(string3);
                }
            }
            if ((n = process.waitFor()) != 0) {
                log.log(Level.INFO, "stderr:", arrayList.toArray(new String[0]));
                throw new IOException(hostinfoScript + " rc == " + n);
            }
            properties.load(process.getInputStream());
            if (Utilities.isWindows()) {
                properties.setProperty("SH", string);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IOException("HostInfo receiving for localhost interrupted " + interruptedException);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties getRemoteHostInfo(ExecutionEnvironment executionEnvironment) throws IOException {
        Properties properties;
        block20: {
            InputStream inputStream;
            OutputStream outputStream;
            block18: {
                properties = new Properties();
                outputStream = null;
                inputStream = null;
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                Session session = ConnectionManagerAccessor.getDefault().getConnectionSession(connectionManager, executionEnvironment, true);
                if (session == null) break block18;
                ChannelExec channelExec = null;
                Object object = session;
                synchronized (object) {
                    channelExec = (ChannelExec)session.openChannel("exec");
                    channelExec.setEnv("PATH", "/bin:/usr/bin");
                    channelExec.setCommand("sh -s");
                    channelExec.connect();
                }
                outputStream = channelExec.getOutputStream();
                inputStream = channelExec.getInputStream();
                object = new BufferedReader(new FileReader(hostinfoScript));
                String string = ((BufferedReader)object).readLine();
                while (string != null) {
                    outputStream.write((string + '\n').getBytes());
                    outputStream.flush();
                    string = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
                properties.load(inputStream);
            }
            Object var10_11 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block20;
            }
            catch (IOException iOException) {}
            break block20;
            {
                catch (JSchException jSchException) {
                    throw new IOException("Exception while receiving HostInfo for " + ((Object)executionEnvironment).toString() + ": " + (Object)((Object)jSchException));
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    private void init(Properties properties) {
        OSImpl oSImpl = new OSImpl();
        oSImpl.setBitness(this.getInt(properties, "BITNESS", 32));
        oSImpl.setFamily(properties.getProperty("OSFAMILY", UNKNOWN));
        oSImpl.setName(properties.getProperty("OSNAME", UNKNOWN));
        oSImpl.setVersion(properties.getProperty("OSBUILD", UNKNOWN));
        this.os = oSImpl;
        this.hostname = properties.getProperty("HOSTNAME", UNKNOWN);
        try {
            this.cpuFamily = HostInfo.CpuFamily.valueOf(properties.getProperty("CPUFAMILY", UNKNOWN).toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.cpuFamily = HostInfo.CpuFamily.UNKNOWN;
        }
        this.shell = properties.getProperty("SH", UNKNOWN);
        this.tempDir = properties.getProperty("TMPDIRBASE", UNKNOWN);
        this.cpuNum = this.getInt(properties, "CPUNUM", 1);
    }

    private int getInt(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string, null);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public HostInfo.OS getOS() {
        return this.os;
    }

    public HostInfo.CpuFamily getCpuFamily() {
        return this.cpuFamily;
    }

    public HostInfo.OSFamily getOSFamily() {
        return this.os.getFamily();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getShell() {
        return this.shell;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public int getCpuNum() {
        return this.cpuNum;
    }

    static {
        log = Logger.getInstance();
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        hostinfoScript = installedFileLocator.locate("bin/nativeexecution/hostinfo.sh", null, false);
        if (hostinfoScript == null) {
            log.severe("Unable to find hostinfo.sh script!");
        }
    }

    private static final class OSImpl
    implements HostInfo.OS {
        private HostInfo.OSFamily family = HostInfo.OSFamily.UNKNOWN;
        private String name = "UNKNOWN";
        private String version = "UNKNOWN";
        private HostInfo.Bitness bitness = HostInfo.Bitness._32;

        private OSImpl() {
        }

        public HostInfo.Bitness getBitness() {
            return this.bitness;
        }

        public String getVersion() {
            return this.version;
        }

        public HostInfo.OSFamily getFamily() {
            return this.family;
        }

        public String getName() {
            return this.name;
        }

        private void setVersion(String string) {
            this.version = string;
        }

        private void setBitness(int n) {
            this.bitness = n == 64 ? HostInfo.Bitness._64 : HostInfo.Bitness._32;
        }

        private void setFamily(String string) {
            try {
                this.family = HostInfo.OSFamily.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void setName(String string) {
            this.name = string;
        }
    }
}

