/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TasksCachedProcessor<P, R>
implements Computable<P, R> {
    private final ConcurrentMap<P, Future<R>> cache = new ConcurrentHashMap<P, Future<R>>();
    private final Computable<P, R> computable;
    private final boolean removeOnCompletion;

    public TasksCachedProcessor(Computable<P, R> computable, boolean bl) {
        this.computable = computable;
        this.removeOnCompletion = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R compute(final P p) throws InterruptedException {
        while (true) {
            Object var6_7;
            Object object;
            FutureTask futureTask;
            FutureTask futureTask2;
            if ((futureTask2 = (FutureTask)this.cache.get(p)) == null && (futureTask2 = (Future)this.cache.putIfAbsent(p, futureTask = new FutureTask(object = new Callable<R>(){

                @Override
                public R call() throws InterruptedException {
                    return TasksCachedProcessor.this.computable.compute(p);
                }
            }))) == null) {
                futureTask2 = futureTask;
                futureTask.run();
            }
            try {
                try {
                    object = futureTask2.get();
                    var6_7 = null;
                    if (!this.removeOnCompletion) return (R)object;
                }
                catch (CancellationException cancellationException) {
                    this.cache.remove(p, futureTask2);
                    var6_7 = null;
                    if (!this.removeOnCompletion) continue;
                    this.cache.remove(p, futureTask2);
                    continue;
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CancellationException) {
                        this.cache.remove(p, futureTask2);
                        throw new CancellationException();
                    }
                    Logger.getInstance().fine("!!! " + executionException.getMessage());
                    var6_7 = null;
                    if (!this.removeOnCompletion) continue;
                    this.cache.remove(p, futureTask2);
                    continue;
                }
                this.cache.remove(p, futureTask2);
                return (R)object;
            }
            catch (Throwable throwable) {
                var6_7 = null;
                if (this.removeOnCompletion) {
                    this.cache.remove(p, futureTask2);
                }
                throw throwable;
            }
        }
    }

    public void remove(P p) {
        Future future = (Future)this.cache.get(p);
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        this.cache.remove(p);
    }
}

