/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Formatter;

public class GsfIndentTask
implements IndentTask {
    private Context context;
    private Formatter formatter;

    GsfIndentTask(Context context) {
        this.context = context;
    }

    public void reindent() throws BadLocationException {
        Formatter formatter = null;
        BaseDocument baseDocument = (BaseDocument)this.context.document();
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, this.context.startOffset());
        if (this.context.endOffset() - this.context.startOffset() < 4) {
            for (Language language : list) {
                if (language.getFormatter() == null) continue;
                formatter = language.getFormatter();
                break;
            }
        }
        if (formatter == null) {
            formatter = this.getFormatter();
        }
        if (formatter != null) {
            formatter.reindent(this.context);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    private synchronized Formatter getFormatter() {
        if (this.formatter == null) {
            MimePath mimePath = MimePath.parse((String)this.context.mimePath());
            String string = mimePath.size() > 1 ? mimePath.getMimeType(mimePath.size() - 1) : mimePath.getPath();
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
            this.formatter = language.getFormatter();
        }
        return this.formatter;
    }
}

