/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectionAwareSourceTaskFactory
extends SourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("SelectionAwareSourceTaskFactory worker");
    private int timeout;
    private String[] supportedMimeTypes;
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2SelectionStartPosition = new WeakHashMap<FileObject, Integer>();
    private static Map<FileObject, Integer> file2SelectionEndPosition = new WeakHashMap<FileObject, Integer>();

    public SelectionAwareSourceTaskFactory(Phase phase, Source.Priority priority) {
        this(phase, priority, null);
    }

    public SelectionAwareSourceTaskFactory(Phase phase, Source.Priority priority, String ... stringArray) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
        this.supportedMimeTypes = stringArray != null ? (String[])stringArray.clone() : null;
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> list = OpenedEditors.filterSupportedMIMETypes(OpenedEditors.getDefault().getVisibleEditorsFiles(), this.supportedMimeTypes);
        return list;
    }

    public static synchronized int[] getLastSelection(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer n = file2SelectionStartPosition.get(fileObject);
        Integer n2 = file2SelectionEndPosition.get(fileObject);
        if (n == null || n2 == null) {
            return null;
        }
        return new int[]{n, n2};
    }

    private static synchronized void setLastSelection(FileObject fileObject, int n, int n2) {
        file2SelectionStartPosition.put(fileObject, n);
        file2SelectionEndPosition.put(fileObject, n2);
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.rescheduleTask = WORKER.create(new Runnable(){

                public void run() {
                    FileObject fileObject = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (fileObject != null) {
                        SelectionAwareSourceTaskFactory.this.reschedule(fileObject);
                    }
                }
            });
        }

        public void caretUpdate(CaretEvent caretEvent) {
            FileObject fileObject = OpenedEditors.getFileObject(this.component);
            if (fileObject != null) {
                SelectionAwareSourceTaskFactory.setLastSelection(OpenedEditors.getFileObject(this.component), this.component.getSelectionStart(), this.component.getSelectionEnd());
                this.rescheduleTask.schedule(SelectionAwareSourceTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList arrayList2 = new ArrayList(SelectionAwareSourceTaskFactory.this.component2Listener.keySet());
            arrayList.removeAll(SelectionAwareSourceTaskFactory.this.component2Listener.keySet());
            arrayList2.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent jTextComponent : arrayList2) {
                jTextComponent.removeCaretListener((CaretListener)SelectionAwareSourceTaskFactory.this.component2Listener.remove(jTextComponent));
            }
            for (JTextComponent jTextComponent : arrayList) {
                ComponentListener componentListener = new ComponentListener(jTextComponent);
                jTextComponent.addCaretListener(componentListener);
                SelectionAwareSourceTaskFactory.this.component2Listener.put(jTextComponent, componentListener);
                SelectionAwareSourceTaskFactory.setLastSelection(OpenedEditors.getFileObject(jTextComponent), jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd());
            }
            SelectionAwareSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

