/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlData {
    private static String DBURL_PATTERN = "((?:[^:\\n]+:){2,3})(?://|@|([^ \\t]+)@)([^:;/\\\\ \\t]+)(?:\\\\([^ \\t:/;]+)|)(?::([0-9]+)|)(?:(?:/|:)([^:/;?&]+)|)((?:(?:;|\\?|&|:)(?:[^;&]+)|)+)";
    private static final int DB_PREFIX = 0;
    private static final int DB_ALT_DBNAME = 1;
    private static final int DB_HOST = 2;
    private static final int DB_INSTANCE_NAME = 3;
    private static final int DB_PORT = 4;
    private static final int DB_PRIMARY_DBNAME = 5;
    private static final int DB_PROPERTIES = 6;
    private static final int NUM_PARTS = 7;
    private static Pattern urlPattern = Pattern.compile(DBURL_PATTERN);
    private final String url;
    private final String[] parts = new String[7];
    private final Map<String, String> props = new LinkedHashMap<String, String>();

    public UrlData(String string) {
        this.url = string;
        this.parseUrl();
    }

    public UrlData(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, null, null, UrlData.parseProperties(string5));
    }

    public UrlData(String string, String string2, String string3, String string4, Map<String, String> map) {
        this(string, string2, string3, string4, null, null, map);
    }

    public UrlData(String string, String string2, String string3, String string4, String string5, String string6, Map<String, String> map) {
        this.parts[0] = string;
        this.parts[1] = string5;
        this.parts[2] = string2;
        this.parts[3] = string6;
        this.parts[4] = string3;
        this.parts[5] = string4;
        this.parts[6] = null;
        this.props.putAll(map);
        this.url = this.constructUrl();
    }

    private void parseUrl() {
        Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "Parsing DB Url: " + this.url);
        Matcher matcher = urlPattern.matcher(this.url);
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String string = matcher.group(i);
                Logger.getLogger("glassfish-eecommon").log(Level.FINEST, "    Part " + i + " is " + string);
                this.parts[i - 1] = string;
            }
            this.props.putAll(UrlData.parseProperties(this.parts[6]));
        } else {
            Logger.getLogger("glassfish-eecommon").log(Level.FINE, "Url parsing failed for " + this.url);
        }
    }

    private static Map<String, String> parseProperties(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("[;?&:]");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                int n = stringArray[i].indexOf("=");
                if (n != -1) {
                    linkedHashMap.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
                    continue;
                }
                linkedHashMap.put(stringArray[i], "");
            }
        }
        return linkedHashMap;
    }

    String constructUrl() {
        String string;
        Map.Entry<String, String> entry;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.parts[0]);
        if (UrlData.notEmpty(this.parts[1])) {
            stringBuilder.append(this.parts[1]);
            stringBuilder.append('@');
        } else if ("jdbc:oracle:thin:".equals(this.parts[0])) {
            stringBuilder.append('@');
        } else {
            stringBuilder.append("//");
        }
        stringBuilder.append(this.parts[2]);
        if (UrlData.notEmpty(this.parts[3])) {
            stringBuilder.append('\\');
            stringBuilder.append(this.parts[3]);
        }
        if (UrlData.notEmpty(this.parts[4])) {
            stringBuilder.append(':');
            stringBuilder.append(this.parts[4]);
        }
        if (UrlData.notEmpty(this.parts[5])) {
            if ("jdbc:oracle:thin:".equals(this.parts[0])) {
                stringBuilder.append(':');
            } else {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.parts[5]);
        }
        char c = ';';
        char c2 = ';';
        if ("jdbc:mysql:".equals(this.parts[0])) {
            c = '?';
            c2 = '&';
        } else if ("jdbc:informix-sqli:".equals(this.parts[0])) {
            c = ':';
        }
        Set<Map.Entry<String, String>> set = this.props.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(c);
            entry = iterator.next();
            stringBuilder.append(entry.getKey());
            string = entry.getValue();
            if (UrlData.notEmpty(string)) {
                stringBuilder.append('=');
                stringBuilder.append(string);
            }
        }
        while (iterator.hasNext()) {
            stringBuilder.append(c2);
            entry = iterator.next();
            stringBuilder.append(entry.getKey());
            string = entry.getValue();
            if (!UrlData.notEmpty(string)) continue;
            stringBuilder.append('=');
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getPrefix() {
        return this.parts[0];
    }

    public String getHostName() {
        return this.parts[2];
    }

    public String getPort() {
        return this.parts[4];
    }

    public String getInstanceName() {
        return this.parts[3];
    }

    public String getDatabaseName() {
        String string = this.parts[5];
        if (string == null && (string = this.parts[1]) == null && (string = this.props.get("databaseName")) == null && (string = this.props.get("databasename")) == null && (string = this.props.get("SID")) == null) {
            string = this.props.get("database name");
        }
        return string;
    }

    public String getAlternateDBName() {
        return this.parts[1];
    }

    public String getSid() {
        return this.props.get("SID");
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    private static boolean notEmpty(String string) {
        return string != null && string.length() > 0;
    }
}

