/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.loader.AntProjectDataObject;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.w3c.dom.Element;

final class AntProjectDataEditor
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
ChangeListener {
    private boolean addedChangeListener = false;

    public AntProjectDataEditor(AntProjectDataObject antProjectDataObject) {
        super((DataObject)antProjectDataObject, (CloneableEditorSupport.Env)new AntEnv(antProjectDataObject));
        this.setMIMEType("text/x-ant+xml");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        AntEnv antEnv = (AntEnv)this.env;
        antEnv.getAntProjectDataObject().addSaveCookie(antEnv);
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        AntEnv antEnv = (AntEnv)this.env;
        antEnv.getAntProjectDataObject().removeSaveCookie(antEnv);
    }

    protected String messageName() {
        String string = super.messageName();
        return this.annotateWithProjectName(string);
    }

    protected String messageHtmlName() {
        String string = super.messageHtmlName();
        return string != null ? this.annotateWithProjectName(string) : null;
    }

    private String annotateWithProjectName(String string) {
        DataObject dataObject = this.getDataObject();
        if (dataObject.getPrimaryFile().getNameExt().equals("build.xml")) {
            String string2;
            AntProjectCookie antProjectCookie = (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class);
            Element element = antProjectCookie.getProjectElement();
            if (element != null && !(string2 = element.getAttribute("name")).equals("")) {
                string = NbBundle.getMessage(AntProjectDataEditor.class, (String)"LBL_editor_tab", (Object)string, (Object)string2);
            }
            if (!this.addedChangeListener) {
                antProjectCookie.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)antProjectCookie));
                this.addedChangeListener = true;
            }
        }
        return string;
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        cloneableEditor.setActivatedNodes(new Node[]{new FilterNode(this.getDataObject().getNodeDelegate()){

            public String getDisplayName() {
                return AntProjectDataEditor.this.messageName();
            }
        }});
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTitles();
    }

    private static class AntEnv
    extends DataEditorSupport.Env
    implements SaveCookie {
        private static final long serialVersionUID = 6610627377311504616L;

        public AntEnv(AntProjectDataObject antProjectDataObject) {
            super((DataObject)antProjectDataObject);
        }

        AntProjectDataObject getAntProjectDataObject() {
            return (AntProjectDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((AntProjectDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public void save() throws IOException {
            ((AntProjectDataEditor)this.findCloneableOpenSupport()).saveDocument();
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(EditCookie.class);
        }
    }
}

