/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.client.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.InvalidConfigFileException;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationReader {
    private static final String TYPE = "type";
    private static final String NAME = "name";

    private ConfigurationReader() {
    }

    public static synchronized Configuration read(DataObject dataObject) throws Exception {
        NodeList nodeList;
        Configuration configuration = new Configuration();
        Document document = XMLUtil.parse((InputSource)DataObjectAdapters.inputSource((DataObject)dataObject), (boolean)false, (boolean)false, null, null);
        Element element = document.getDocumentElement();
        String string = element.getAttribute("serviceType");
        if ("class".equals(string)) {
            configuration.setServiceType("class");
        } else if ("wsdlClass".equals(string)) {
            configuration.setServiceType("wsdlClass");
        } else if ("jsr-172".equals(string)) {
            configuration.setServiceType("jsr-172");
        } else {
            throw new InvalidConfigFileException("Invalid service type:" + string);
        }
        String string2 = element.getAttribute("version");
        if (!"1.0".equals(string2)) {
            throw new InvalidConfigFileException("Invalid config file version: " + string2);
        }
        NodeList nodeList2 = element.getElementsByTagName("client");
        if (nodeList2.getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one client section");
        }
        if (nodeList2.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no client section");
        }
        configuration.setClientConfiguration(ConfigurationReader.parseClient((Element)nodeList2.item(0)));
        if (!"jsr-172".equals(configuration.getServiceType())) {
            nodeList = element.getElementsByTagName("server");
            if (nodeList.getLength() > 1) {
                throw new InvalidConfigFileException("Config file has more than one server section");
            }
            if (nodeList.getLength() == 0) {
                throw new InvalidConfigFileException("Config file has no server section");
            }
            configuration.setServerConfiguration(ConfigurationReader.parseServer((Element)nodeList.item(0)));
        }
        if ((nodeList = element.getElementsByTagName("services")).getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one services section");
        }
        if (nodeList.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no services section");
        }
        NodeList nodeList3 = ((Element)nodeList.item(0)).getElementsByTagName("service");
        if (nodeList3.getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one services");
        }
        if (nodeList.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no registered services");
        }
        configuration.setServices(ConfigurationReader.parseServices((Element)nodeList3.item(0), string));
        return configuration;
    }

    private static ClientConfiguration parseClient(Element element) throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        String string = ConfigurationReader.getElementValue(element, "project");
        if ("".equals(string)) {
            throw new InvalidConfigFileException("Client project name is empty string");
        }
        clientConfiguration.setProjectName(string);
        NodeList nodeList = element.getElementsByTagName("class");
        if (nodeList.getLength() > 1) {
            throw new InvalidConfigFileException("Client has more than one class tag");
        }
        if (nodeList.getLength() == 0) {
            throw new InvalidConfigFileException("Client has no class tag");
        }
        Element element2 = (Element)nodeList.item(0);
        String string2 = element2.getAttribute(TYPE);
        if ("".equals(string2)) {
            throw new InvalidConfigFileException("Client class type is empty string");
        }
        String string3 = element2.getAttribute("location");
        ClassDescriptor classDescriptor = new ClassDescriptor(string2, string3);
        clientConfiguration.setClassDescriptor(classDescriptor);
        Properties properties = new Properties();
        NodeList nodeList2 = element.getElementsByTagName("property");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element3 = (Element)nodeList2.item(i);
            String string4 = element3.getAttribute(NAME);
            if ("".equals(string4)) {
                throw new IllegalAccessException("Key name is empty string");
            }
            String string5 = element3.getAttribute("value");
            properties.put(string4, string5);
        }
        clientConfiguration.setProperties(properties);
        return clientConfiguration;
    }

    private static ServerConfiguration parseServer(Element element) throws Exception {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        Element element2 = (Element)element.getElementsByTagName("project").item(0);
        String string = ConfigurationReader.getElementValue(element, "project");
        if ("".equals(string)) {
            throw new InvalidConfigFileException("Server project name is empty string");
        }
        serverConfiguration.setProjectName(string);
        serverConfiguration.setProjectPath(element2.getAttribute("path"));
        NodeList nodeList = element.getElementsByTagName("class");
        if (nodeList.getLength() > 1) {
            throw new InvalidConfigFileException("Server has more than one class tag");
        }
        if (nodeList.getLength() == 0) {
            throw new InvalidConfigFileException("Server has no class tag");
        }
        Element element3 = (Element)nodeList.item(0);
        String string2 = element3.getAttribute(TYPE);
        if ("".equals(string2)) {
            throw new InvalidConfigFileException("Server class type is empty string");
        }
        String string3 = element3.getAttribute("location");
        String string4 = element3.getAttribute("mapping");
        ClassDescriptor classDescriptor = new ClassDescriptor(string2, string3);
        classDescriptor.setMapping(string4);
        serverConfiguration.setClassDescriptor(classDescriptor);
        Properties properties = new Properties();
        NodeList nodeList2 = element.getElementsByTagName("property");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element4 = (Element)nodeList2.item(i);
            String string5 = element4.getAttribute(NAME);
            if ("".equals(string5)) {
                throw new IllegalAccessException("Key name is empty string");
            }
            String string6 = element4.getAttribute("value");
            properties.put(string5, string6);
        }
        serverConfiguration.setProperties(properties);
        return serverConfiguration;
    }

    private static List<AbstractService> parseServices(Element element, String string) {
        ArrayList<AbstractService> arrayList = new ArrayList<AbstractService>();
        if ("class".equals(string)) {
            ClassService classService = new ClassService();
            ArrayList<ClassData> arrayList2 = new ArrayList<ClassData>();
            NodeList nodeList = element.getElementsByTagName("class");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ClassData classData = ConfigurationReader.parseClassService((Element)nodeList.item(i));
                if (classData == null) continue;
                arrayList2.add(classData);
            }
            classService.setData(arrayList2);
            arrayList.add(classService);
        } else if ("wsdlClass".equals(string)) {
            WSDLService wSDLService = new WSDLService();
            String string2 = element.getAttribute("url");
            String string3 = element.getAttribute("file");
            String string4 = element.getAttribute(NAME);
            String string5 = element.getAttribute(TYPE);
            wSDLService.setName(string4);
            wSDLService.setFile(string3);
            wSDLService.setUrl(string2);
            wSDLService.setType(string5);
            ArrayList<ClassData> arrayList3 = new ArrayList<ClassData>();
            NodeList nodeList = element.getElementsByTagName("port");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                PortData portData = ConfigurationReader.parseWsdlService((Element)nodeList.item(i));
                if (portData == null) continue;
                arrayList3.add(portData);
            }
            wSDLService.setData(arrayList3);
            arrayList.add(wSDLService);
        } else if ("jsr-172".equals(string)) {
            WSDLService wSDLService = new WSDLService();
            String string6 = element.getAttribute("url");
            String string7 = element.getAttribute("file");
            wSDLService.setFile(string7);
            wSDLService.setUrl(string6);
            arrayList.add(wSDLService);
        }
        return arrayList;
    }

    private static ClassData parseClassService(Element element) {
        String string = element.getAttribute(TYPE);
        ClassData classData = new ClassData(string);
        NodeList nodeList = element.getElementsByTagName("method");
        ArrayList<OperationData> arrayList = new ArrayList<OperationData>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttribute(NAME);
            String string3 = ((Element)element2.getElementsByTagName("return").item(0)).getAttribute(TYPE);
            NodeList nodeList2 = element2.getElementsByTagName("param");
            ArrayList<TypeData> arrayList2 = new ArrayList<TypeData>();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string4 = element3.getAttribute(TYPE);
                String string5 = element3.getAttribute(NAME);
                TypeData typeData = new TypeData(string5, string4);
                arrayList2.add(typeData);
            }
            OperationData operationData = new OperationData(string2);
            operationData.setReturnType(string3);
            operationData.setParameterTypes(arrayList2);
            arrayList.add(operationData);
        }
        classData.setOperations(arrayList);
        return classData;
    }

    private static PortData parseWsdlService(Element element) {
        String string = element.getAttribute(TYPE);
        String string2 = element.getAttribute(NAME);
        PortData portData = new PortData(string);
        portData.setName(string2);
        NodeList nodeList = element.getElementsByTagName("operation");
        ArrayList<OperationData> arrayList = new ArrayList<OperationData>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute(NAME);
            String string4 = element2.getAttribute("method");
            String string5 = ((Element)element2.getElementsByTagName("return").item(0)).getAttribute(TYPE);
            NodeList nodeList2 = element2.getElementsByTagName("param");
            ArrayList<TypeData> arrayList2 = new ArrayList<TypeData>();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string6 = element3.getAttribute(TYPE);
                String string7 = element3.getAttribute(NAME);
                TypeData typeData = new TypeData(string7, string6);
                arrayList2.add(typeData);
            }
            OperationData operationData = new OperationData(string3);
            operationData.setMethodName(string4);
            operationData.setReturnType(string5);
            operationData.setParameterTypes(arrayList2);
            arrayList.add(operationData);
        }
        portData.setOperations(arrayList);
        return portData;
    }

    private static String getElementValue(Element element, String string) {
        Element element2 = (Element)element.getElementsByTagName(string).item(0);
        return element2.getChildNodes().item(0).getNodeValue();
    }
}

