/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.DebuggerOutput;
import org.netbeans.modules.debugger.jpda.ui.IOManager;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
JPDABreakpointListener,
PropertyChangeListener {
    private static final Pattern dollarEscapePattern = Pattern.compile("\\$");
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final Pattern threadNamePattern = Pattern.compile("\\{threadName\\}");
    private static final Pattern classNamePattern = Pattern.compile("\\{className\\}");
    private static final Pattern methodNamePattern = Pattern.compile("\\{methodName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern exceptionClassNamePattern = Pattern.compile("\\{exceptionClassName\\}");
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private static final String threadStartedCondition = "{? threadStarted}";
    private IOManager ioManager;
    private JPDADebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.ioManager = null;
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (jPDABreakpointEvent.getDebugger() != this.debugger) {
                return;
            }
        }
        if (jPDABreakpointEvent.getConditionResult() == 2) {
            return;
        }
        object = (JPDABreakpoint)jPDABreakpointEvent.getSource();
        if (object.getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint((JPDABreakpoint)object);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.ioManager == null) {
                this.lookupIOManager();
                if (this.ioManager == null) {
                    return;
                }
            }
        }
        object2 = object.getPrintText();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object2 = this.substitute((String)object2, jPDABreakpointEvent);
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.ioManager != null) {
                this.ioManager.println((String)object2, null);
            }
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("validity".equals(propertyChangeEvent.getPropertyName())) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)propertyChangeEvent.getSource();
            if (jPDABreakpoint.isHidden()) {
                return;
            }
            if (Breakpoint.VALIDITY.INVALID.equals(propertyChangeEvent.getNewValue())) {
                String string = jPDABreakpoint.getValidityMessage();
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String string2 = string != null ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpointWithReason", (Object)jPDABreakpoint.toString(), (Object)string) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpoint", (Object)jPDABreakpoint.toString());
                    IOManager.Line line = null;
                    if (jPDABreakpoint instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)jPDABreakpoint).getURL(), ((LineBreakpoint)jPDABreakpoint).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(string2, null, true);
                    if (line != null) {
                        this.ioManager.println(NbBundle.getMessage(BreakpointOutput.class, (String)"Link_InvalidBreakpoint", (Object)jPDABreakpoint.toString()), line, true);
                    }
                }
            }
            if (Breakpoint.VALIDITY.VALID.equals(propertyChangeEvent.getNewValue())) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.ioManager == null) {
                        this.lookupIOManager();
                        if (this.ioManager == null) {
                            return;
                        }
                    }
                    String string = NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpoint", (Object)jPDABreakpoint.toString());
                    IOManager.Line line = null;
                    if (jPDABreakpoint instanceof LineBreakpoint) {
                        line = new IOManager.Line(((LineBreakpoint)jPDABreakpoint).getURL(), ((LineBreakpoint)jPDABreakpoint).getLineNumber(), this.debugger);
                    }
                    this.ioManager.println(string, line, false);
                }
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !"state".equals(propertyChangeEvent.getPropertyName()) || this.debugger.getState() == 3) {
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String substitute(String string, JPDABreakpointEvent jPDABreakpointEvent) {
        Variable variable;
        String string2;
        String string3;
        Object object;
        String string4;
        JPDAThread jPDAThread = jPDABreakpointEvent.getThread();
        if (jPDAThread != null) {
            string4 = backslashEscapePattern.matcher(jPDAThread.getName()).replaceAll("\\\\\\\\");
            string4 = dollarEscapePattern.matcher(string4).replaceAll("\\\\\\$");
            string = threadNamePattern.matcher(string).replaceAll(string4);
        } else {
            string = threadNamePattern.matcher(string).replaceAll("?");
        }
        if (jPDABreakpointEvent.getReferenceType() != null) {
            string4 = dollarEscapePattern.matcher(jPDABreakpointEvent.getReferenceType().name()).replaceAll("\\\\\\$");
            string = classNamePattern.matcher(string).replaceAll(string4);
        } else {
            string = classNamePattern.matcher(string).replaceAll("?");
        }
        string4 = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (sessionArray[i].lookupFirst(null, JPDADebugger.class) != this.debugger) continue;
            string4 = sessionArray[i];
            break;
        }
        String string5 = string4 != null ? string4.getCurrentLanguage() : null;
        String string6 = jPDAThread.getMethodName();
        if ("".equals(string6)) {
            string6 = "?";
        }
        string6 = dollarEscapePattern.matcher(string6).replaceAll("\\\\\\$");
        string = methodNamePattern.matcher(string).replaceAll(string6);
        int n = jPDAThread.getLineNumber(string5);
        string = n < 0 ? lineNumberPattern.matcher(string).replaceAll("?") : lineNumberPattern.matcher(string).replaceAll(String.valueOf(n));
        if (jPDABreakpointEvent.getSource() instanceof ExceptionBreakpoint && (object = jPDABreakpointEvent.getVariable()) != null) {
            string3 = object.getType();
            string = exceptionClassNamePattern.matcher(string).replaceAll(string3);
            string2 = "";
            try {
                variable = ((ObjectVariable)object).invokeMethod("getLocalizedMessage", null, new Variable[0]);
                if (variable != null) {
                    string2 = variable.getValue();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string2 = "<" + noSuchMethodException.getLocalizedMessage() + ">";
            }
            catch (InvalidExpressionException invalidExpressionException) {
                string2 = "<" + invalidExpressionException.getLocalizedMessage() + ">";
            }
            string = string.replace("{exceptionMessage}", string2);
        }
        if (jPDABreakpointEvent.getSource() instanceof ThreadBreakpoint) {
            object = jPDABreakpointEvent.getVariable();
            string = object instanceof ObjectVariable ? BreakpointOutput.selectCondition(string, threadStartedCondition, true) : BreakpointOutput.selectCondition(string, threadStartedCondition, false);
        }
        while (true) {
            CallStackFrame[] callStackFrameArray;
            Object object2;
            if (!((Matcher)(object = expressionPattern.matcher(string))).find()) {
                object = jPDABreakpointEvent.getConditionException();
                if (object == null) return string;
                return string + "\n***\n" + ((Throwable)object).getLocalizedMessage() + "\n***\n";
            }
            string3 = ((Matcher)object).group(1);
            string2 = "";
            try {
                object2 = this.lock;
                // MONITORENTER : object2
                if (this.debugger == null) {
                    // MONITOREXIT : object2
                    return string2;
                }
                variable = this.debugger;
                // MONITOREXIT : object2
                object2 = null;
                try {
                    callStackFrameArray = jPDAThread.getCallStack(0, 1);
                    if (callStackFrameArray.length > 0) {
                        object2 = callStackFrameArray[0];
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                try {
                    string2 = ((Variable)variable.getClass().getMethod("evaluate", String.class, CallStackFrame.class).invoke((Object)variable, string3, object2)).getValue();
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof InvalidExpressionException) {
                        throw (InvalidExpressionException)invocationTargetException.getTargetException();
                    }
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                string2 = backslashEscapePattern.matcher(string2).replaceAll("\\\\\\\\");
                string2 = dollarEscapePattern.matcher(string2).replaceAll("\\\\\\$");
            }
            catch (InvalidExpressionException invalidExpressionException) {
                object2 = invalidExpressionException.getCause() != null ? invalidExpressionException.getCause().getMessage() : invalidExpressionException.getMessage();
                callStackFrameArray = this.lock;
                // MONITORENTER : this.lock
                if (this.ioManager != null) {
                    this.ioManager.println("Cannot evaluate expression '" + string3 + "' : " + (String)object2, null);
                }
                // MONITOREXIT : callStackFrameArray
            }
            string = ((Matcher)object).replaceFirst(string2);
        }
    }

    private static String selectCondition(String string, String string2, boolean bl) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            int n2;
            n += string2.length();
            int n3 = string.length();
            while (n < n3 && string.charAt(n) != '{') {
                ++n;
            }
            if (n < n3 && (n2 = BreakpointOutput.findPair(string, n + 1, '{', '}')) > 0) {
                if (bl) {
                    return string.substring(n + 1, n2).trim();
                }
                for (n = n2 + 1; n < n3 && string.charAt(n) != '{'; ++n) {
                }
                if (n < n3 && (n2 = BreakpointOutput.findPair(string, n + 1, '{', '}')) > 0) {
                    return string.substring(n + 1, n2).trim();
                }
            }
        }
        return string;
    }

    private static int findPair(String string, int n, char c, char c2) {
        int n2 = string.length();
        int n3 = 1;
        while (n < n2) {
            char c3 = string.charAt(n);
            if (c3 == c) {
                ++n3;
            }
            if (c3 == c2) {
                --n3;
            }
            if (n3 == 0) break;
            ++n;
        }
        if (n < n2) {
            return n;
        }
        return -1;
    }

    private void lookupIOManager() {
        List list = this.contextProvider.lookup(null, LazyActionsManagerListener.class);
        for (Object e : list) {
            if (!(e instanceof DebuggerOutput)) continue;
            this.ioManager = ((DebuggerOutput)e).getIOManager();
            break;
        }
    }

    private void hookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.hookBreakpoint(breakpoint);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.unhookBreakpoint(breakpoint);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
            jPDABreakpoint.addPropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.removeJPDABreakpointListener((JPDABreakpointListener)this);
            jPDABreakpoint.removePropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List list = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nodeModel : list) {
                if (!(nodeModel instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nodeModel;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

