/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.ButtonPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.HistoryPanel;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeEvaluator
extends TopComponent
implements HelpCtx.Provider,
DocumentListener,
KeyListener,
PropertyChangeListener {
    private static final String ID = "evaluator";
    private static final String PROP_RESULT_CHANGED = "resultChanged";
    private static CodeEvaluator defaultInstance = null;
    private static PropertyChangeSupport pcs = new PropertyChangeSupport(new Integer(0));
    private JEditorPane codePane;
    private HistoryPanel historyPanel;
    private Reference<JPDADebugger> debuggerRef = new WeakReference<Object>(null);
    private DbgManagerListener dbgManagerListener;
    private TopComponent resultView;
    private Set<String> editItemsSet = new HashSet<String>();
    private ArrayList<String> editItemsList = new ArrayList();
    private JButton dropDownButton;
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private HistoryRecord lastEvaluationRecord = null;
    private Variable result;
    private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Evaluator", 1).create((Runnable)new EvaluateTask());
    private JScrollPane editorScrollPane;
    private JPanel emptyPanel;
    private JButton evaluateButton;
    private JPanel rightPanel;
    private JPanel separatorPanel;

    public CodeEvaluator() {
        this.initComponents();
        this.codePane = new JEditorPane();
        this.codePane.setMinimumSize(new Dimension(0, 0));
        this.historyPanel = new HistoryPanel();
        this.rightPanel.setPreferredSize(new Dimension(this.evaluateButton.getPreferredSize().width + 6, 0));
        this.dropDownButton = this.createDropDownButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.rightPanel.add((Component)this.dropDownButton, gridBagConstraints);
        this.setupContext();
        this.editorScrollPane.setViewportView(this.codePane);
        this.codePane.addKeyListener(this);
        this.dbgManagerListener = new DbgManagerListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.dbgManagerListener);
        this.checkDebuggerState();
        defaultInstance = this;
    }

    public void pasteExpression(String string) {
        this.codePane.setText(string);
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    private JButton createDropDownButton() {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/drop_down_arrow.png", (boolean)false);
        DropDownButton dropDownButton = new DropDownButton();
        dropDownButton.setIcon(imageIcon);
        String string = NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Expressions_Dropdown_tooltip");
        dropDownButton.setToolTipText(string);
        dropDownButton.setEnabled(false);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 3, imageIcon.getIconHeight() + 2);
        dropDownButton.setPreferredSize(dimension);
        dropDownButton.setMargin(new Insets(0, 0, 0, 0));
        dropDownButton.setFocusable(false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if ("pressed".equals(actionEvent.getActionCommand())) {
                    Object object;
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    Point point = new Point(jComponent.getWidth(), jComponent.getHeight());
                    SwingUtilities.convertPointToScreen(point, jComponent);
                    if (!ButtonPopupSwitcher.isShown()) {
                        object = CodeEvaluator.this.createSwitcherItems();
                        ButtonPopupSwitcher.selectItem(jComponent, (SwitcherTableItem[])object, point.x, point.y);
                    }
                    if (jComponent instanceof AbstractButton) {
                        object = (AbstractButton)jComponent;
                        ((AbstractButton)object).getModel().setPressed(false);
                        ((AbstractButton)object).getModel().setRollover(false);
                        ((AbstractButton)object).getModel().setArmed(false);
                        ((Component)object).repaint();
                    }
                }
            }

            public boolean isEnabled() {
                return !CodeEvaluator.this.editItemsList.isEmpty();
            }
        };
        abstractAction.putValue("SmallIcon", imageIcon);
        abstractAction.putValue("ShortDescription", string);
        dropDownButton.setAction(abstractAction);
        return dropDownButton;
    }

    private void setupContext() {
        final String string = this.codePane.getText();
        final Document[] documentArray = new Document[]{null};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CodeEvaluator.this.codePane.getDocument() != documentArray[0]) {
                    CodeEvaluator.this.codePane.getDocument().addDocumentListener(CodeEvaluator.this);
                    if (string != null) {
                        CodeEvaluator.this.codePane.setText(string);
                    }
                }
            }
        };
        WatchPanel.setupContext(this.codePane, actionListener);
        this.codePane.getDocument().addDocumentListener(this);
        if (string != null) {
            this.codePane.setText(string);
        }
        documentArray[0] = this.codePane.getDocument();
    }

    private SwitcherTableItem[] createSwitcherItems() {
        SwitcherTableItem[] switcherTableItemArray = new SwitcherTableItem[this.editItemsList.size()];
        int n = 0;
        for (String string : this.editItemsList) {
            switcherTableItemArray[n++] = new SwitcherTableItem(new MenuItemActivatable(string), string);
        }
        return switcherTableItemArray;
    }

    public void recomputeDropDownItems() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (String string : CodeEvaluator.this.editItemsList) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    String string2 = "";
                    while (string2.trim().length() == 0 && stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                }
                CodeEvaluator.this.dropDownButton.setEnabled(!CodeEvaluator.this.editItemsList.isEmpty());
            }
        });
    }

    public static synchronized CodeEvaluator getInstance() {
        CodeEvaluator codeEvaluator = (CodeEvaluator)WindowManager.getDefault().findTopComponent(ID);
        if (codeEvaluator == null) {
            codeEvaluator = new CodeEvaluator();
        }
        return codeEvaluator;
    }

    public static ArrayList<HistoryPanel.Item> getHistory() {
        return defaultInstance != null ? CodeEvaluator.defaultInstance.historyPanel.getHistoryItems() : new ArrayList<HistoryPanel.Item>();
    }

    public static Variable getResult() {
        return defaultInstance != null ? CodeEvaluator.defaultInstance.result : null;
    }

    public static String getExpressionText() {
        return defaultInstance != null ? defaultInstance.getExpression() : "";
    }

    public static synchronized void addResultListener(PropertyChangeListener propertyChangeListener) {
        pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public static synchronized void removeResultListener(PropertyChangeListener propertyChangeListener) {
        pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private static void fireResultChange() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<CodeEvaluator> clazz = CodeEvaluator.class;
                synchronized (CodeEvaluator.class) {
                    pcs.firePropertyChange(CodeEvaluator.PROP_RESULT_CHANGED, null, null);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private synchronized void checkDebuggerState() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger jPDADebugger;
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                JPDADebugger jPDADebugger2 = null;
                if (debuggerEngine != null) {
                    jPDADebugger2 = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
                }
                if ((jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get()) != null && jPDADebugger2 != jPDADebugger) {
                    jPDADebugger.removePropertyChangeListener("currentThread", (PropertyChangeListener)CodeEvaluator.this);
                    jPDADebugger.removePropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                    CodeEvaluator.this.debuggerRef = new WeakReference<Object>(null);
                    CodeEvaluator.this.displayResult(null);
                }
                if (jPDADebugger2 != null) {
                    CodeEvaluator.this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger2);
                    jPDADebugger2.addPropertyChangeListener("currentThread", (PropertyChangeListener)CodeEvaluator.this);
                    jPDADebugger2.addPropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                } else {
                    CodeEvaluator.this.historyPanel.clearHistory();
                }
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    private void computeEvaluationButtonState() {
        JPDADebugger jPDADebugger = this.debuggerRef.get();
        boolean bl = jPDADebugger != null && jPDADebugger.getCurrentThread() != null && jPDADebugger.getState() == 3 && this.codePane.getDocument().getLength() > 0 && this.editorScrollPane.getViewport().getView() == this.codePane;
        this.evaluateButton.setEnabled(bl);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
    }

    private void initComponents() {
        this.editorScrollPane = new JScrollPane();
        this.separatorPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.evaluateButton = new JButton();
        this.emptyPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.editorScrollPane.setBorder(null);
        this.editorScrollPane.setMinimumSize(new Dimension(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.editorScrollPane, gridBagConstraints);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setMaximumSize(new Dimension(1, Short.MAX_VALUE));
        this.separatorPanel.setMinimumSize(new Dimension(0, 0));
        this.separatorPanel.setPreferredSize(new Dimension(1, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add(this.separatorPanel, gridBagConstraints);
        this.rightPanel.setPreferredSize(new Dimension(48, 0));
        this.rightPanel.setLayout(new GridBagLayout());
        this.evaluateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/evaluate.png")));
        this.evaluateButton.setText(NbBundle.getMessage(CodeEvaluator.class, (String)"CodeEvaluator.evaluateButton.text"));
        this.evaluateButton.setToolTipText(NbBundle.getMessage(CodeEvaluator.class, (String)"HINT_Evaluate_Button"));
        this.evaluateButton.setEnabled(false);
        this.evaluateButton.setPreferredSize(new Dimension(40, 22));
        this.evaluateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeEvaluator.this.evaluateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.rightPanel.add((Component)this.evaluateButton, gridBagConstraints);
        this.emptyPanel.setMinimumSize(new Dimension(0, 0));
        this.emptyPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.rightPanel.add((Component)this.emptyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add(this.rightPanel, gridBagConstraints);
    }

    private void evaluateButtonActionPerformed(ActionEvent actionEvent) {
        this.evaluate();
    }

    public static void openEvaluator() {
        CodeEvaluator codeEvaluator = CodeEvaluator.getInstance();
        codeEvaluator.open();
        codeEvaluator.codePane.selectAll();
        codeEvaluator.requestActive();
    }

    public boolean requestFocusInWindow() {
        this.codePane.requestFocusInWindow();
        return super.requestFocusInWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_name");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_tooltip");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("EvaluateCode");
    }

    public String getExpression() {
        return this.codePane.getText();
    }

    public void evaluate() {
        this.evalTask.schedule(10);
    }

    private void displayResult(Variable variable) {
        this.result = variable;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CodeEvaluator.this.preferences.getBoolean("show_evaluator_result", false)) {
                    TopComponent topComponent = WindowManager.getDefault().findTopComponent("localsView");
                    topComponent.open();
                    topComponent.requestActive();
                } else {
                    if (CodeEvaluator.this.resultView == null) {
                        CodeEvaluator.this.resultView = CodeEvaluator.this.getResultViewInstance();
                    }
                    if (CodeEvaluator.this.result != null) {
                        CodeEvaluator.this.resultView.open();
                        CodeEvaluator.this.resultView.requestActive();
                    }
                }
                CodeEvaluator.getInstance().requestActive();
                CodeEvaluator.fireResultChange();
            }
        });
    }

    private void addResultToHistory(final String string, Variable variable) {
        if (this.lastEvaluationRecord != null) {
            this.historyPanel.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
        }
        String string2 = variable.getType();
        String string3 = variable.getValue();
        String string4 = "";
        if (variable instanceof ObjectVariable) {
            try {
                string4 = ((ObjectVariable)variable).getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {}
        } else {
            string4 = string3;
        }
        this.lastEvaluationRecord = new HistoryRecord(string, string2, string3, string4);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string3 = string.trim();
                if (CodeEvaluator.this.editItemsSet.contains(string3)) {
                    CodeEvaluator.this.editItemsList.remove(string3);
                    CodeEvaluator.this.editItemsList.add(0, string3);
                } else {
                    CodeEvaluator.this.editItemsList.add(0, string3);
                    CodeEvaluator.this.editItemsSet.add(string3);
                    if (CodeEvaluator.this.editItemsList.size() > 20) {
                        String string2 = (String)CodeEvaluator.this.editItemsList.remove(CodeEvaluator.this.editItemsList.size() - 1);
                        CodeEvaluator.this.editItemsSet.remove(string2);
                    }
                }
                CodeEvaluator.this.recomputeDropDownItems();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
            keyEvent.consume();
            if (this.debuggerRef.get() != null) {
                this.evaluate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
    }

    private void updateWatch() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentThread".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    10 var1_1 = this;
                    synchronized (var1_1) {
                        JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (jPDADebugger != null) {
                            CodeEvaluator.this.computeEvaluationButtonState();
                            CodeEvaluator.this.setupContext();
                        }
                    }
                }
            });
        } else if ("state".equals(propertyChangeEvent.getPropertyName())) {
            CodeEvaluator codeEvaluator = this;
            synchronized (codeEvaluator) {
                JPDADebugger jPDADebugger = this.debuggerRef.get();
                if (jPDADebugger != null && jPDADebugger.getState() != 3 && this.result != null) {
                    this.historyPanel.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
                    this.lastEvaluationRecord = null;
                    this.result = null;
                    CodeEvaluator.fireResultChange();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (jPDADebugger != null && jPDADebugger.getState() == 3) {
                            CodeEvaluator.this.setupContext();
                        }
                        CodeEvaluator.this.computeEvaluationButtonState();
                    }
                });
            }
        }
    }

    public static synchronized TopComponent getResultView() {
        return new ResultView();
    }

    private synchronized TopComponent getResultViewInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("resultsView");
        if (topComponent == null) {
            topComponent = new ResultView();
        }
        return topComponent;
    }

    private void initResult(ResultView resultView) {
        JComponent jComponent = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        resultView.add(jComponent, "Center");
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = dimension.width / 2;
        jComponent.setPreferredSize(dimension);
        jComponent.setName(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YName"));
        jComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YDescr"));
        JTextField jTextField = new JTextField();
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jComponent.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jComponent.setFocusTraversalKeys(1, set);
    }

    private static class HistoryRecord {
        String expr;
        String type;
        String value;
        String toString;

        HistoryRecord(String string, String string2, String string3, String string4) {
            this.expr = string;
            this.type = string2;
            this.value = string3;
            this.toString = string4;
        }
    }

    private static class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled() && mouseEvent.getID() == 501) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            }
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }

        void performAction(ActionEvent actionEvent) {
        }
    }

    private class MenuItemActivatable
    implements SwitcherTableItem.Activatable {
        String text;

        MenuItemActivatable(String string) {
            this.text = string;
        }

        public void activate() {
            CodeEvaluator.this.codePane.setText(this.text);
        }
    }

    private static class DbgManagerListener
    extends DebuggerManagerAdapter {
        private Reference<CodeEvaluator> codeEvaluatorRef;

        public DbgManagerListener(CodeEvaluator codeEvaluator) {
            this.codeEvaluatorRef = new WeakReference<CodeEvaluator>(codeEvaluator);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CodeEvaluator codeEvaluator = this.codeEvaluatorRef.get();
            if (codeEvaluator != null) {
                codeEvaluator.checkDebuggerState();
            }
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        public void run() {
            String string = CodeEvaluator.this.getExpression();
            if (string == null || "".equals(string)) {
                return;
            }
            try {
                JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                if (jPDADebugger != null) {
                    Variable variable = jPDADebugger.evaluate(string);
                    CodeEvaluator.this.addResultToHistory(string, variable);
                    CodeEvaluator.this.displayResult(variable);
                }
            }
            catch (InvalidExpressionException invalidExpressionException) {
                String string2 = invalidExpressionException.getLocalizedMessage();
                Throwable throwable = invalidExpressionException.getTargetException();
                if (throwable != null && throwable instanceof ApplicationException) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.close();
                    string2 = string2 + " \n" + stringWriter.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CodeEvaluator.this.codePane.requestFocusInWindow();
                    }
                });
            }
        }
    }

    private static class ResultView
    extends TopComponent
    implements HelpCtx.Provider {
        private static final String ID = "evaluator_result";

        ResultView() {
            this.setLayout(new BorderLayout());
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public int getPersistenceType() {
            return 0;
        }

        public String getName() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_name");
        }

        public String getToolTipText() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_tooltip");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("EvaluationResult");
        }
    }
}

