/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private JPDADebugger debugger;
    private ContextProvider lookupProvider;
    private Action POP_TO_HERE_ACTION;
    private Action MAKE_CURRENT_ACTION;
    private Action COPY_TO_CLBD_ACTION;

    public CallStackActionsProvider(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        RequestProcessor requestProcessor = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
        this.POP_TO_HERE_ACTION = DebuggingActionsProvider.createPOP_TO_HERE_ACTION(requestProcessor);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(requestProcessor);
        this.COPY_TO_CLBD_ACTION = this.createCOPY_TO_CLBD_ACTION(requestProcessor);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void run(Object[] objectArray) {
                CallStackActionsProvider.this.makeCurrent((CallStackFrame)objectArray[0]);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createCOPY_TO_CLBD_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_Copy2CLBD_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            public boolean isEnabled(Object object) {
                JPDAThread jPDAThread = CallStackActionsProvider.this.debugger.getCurrentThread();
                return jPDAThread != null && jPDAThread.isSuspended();
            }

            public void run(Object[] objectArray) {
                CallStackActionsProvider.this.stackToCLBD();
            }
        }, (int)Models.MULTISELECTION_TYPE_ANY);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{this.COPY_TO_CLBD_ACTION};
        }
        if (!(object instanceof CallStackFrame)) {
            throw new UnknownTypeException(object);
        }
        boolean bl = this.debugger.canPopFrames();
        if (bl) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, DebuggingActionsProvider.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[]{this.MAKE_CURRENT_ACTION, DebuggingActionsProvider.GO_TO_SOURCE_ACTION, this.COPY_TO_CLBD_ACTION};
    }

    public void performDefaultAction(final Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof CallStackFrame) {
            ((RequestProcessor)this.lookupProvider.lookupFirst(null, RequestProcessor.class)).post(new Runnable(){

                public void run() {
                    CallStackActionsProvider.this.makeCurrent((CallStackFrame)object);
                }
            });
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private void stackToCLBD() {
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        DebuggingActionsProvider.appendStackInfo(stringBuffer, jPDAThread);
        Clipboard clipboard = DebuggingActionsProvider.getClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private void makeCurrent(final CallStackFrame callStackFrame) {
        if (this.debugger.getCurrentCallStackFrame() != callStackFrame) {
            callStackFrame.makeCurrent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
                    SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
                    sourcePath.showSource(callStackFrame, string);
                }
            });
        }
    }
}

