/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsTableModelFilter
implements TableModelFilter,
Constants,
PropertyChangeListener {
    private Vector listeners = new Vector();
    private boolean addedAsListener;
    private static final Integer SD = new Integer(4);

    private static String loc(String string) {
        return NbBundle.getBundle(SessionsTableModelFilter.class).getString(string);
    }

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof Session && SessionsTableModelFilter.isJPDASession((Session)object)) {
            if ("SessionState".equals(string)) {
                return this.getSessionState((Session)object);
            }
            if ("SessionLanguage".equals(string)) {
                return object;
            }
            if ("SessionHostName".equals(string)) {
                return ((Session)object).getLocationName();
            }
            throw new UnknownTypeException(object);
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof Session && SessionsTableModelFilter.isJPDASession((Session)object)) {
            if ("SessionState".equals(string)) {
                return true;
            }
            if ("SessionLanguage".equals(string)) {
                return false;
            }
            if ("SessionHostName".equals(string)) {
                return true;
            }
            throw new UnknownTypeException(object);
        }
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }

    static boolean isJPDASession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        return jPDADebugger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionState(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return SessionsTableModelFilter.loc("MSG_Session_State_Starting");
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        SessionsTableModelFilter sessionsTableModelFilter = this;
        synchronized (sessionsTableModelFilter) {
            if (!this.addedAsListener) {
                jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
            }
        }
        switch (jPDADebugger.getState()) {
            case 4: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Disconnected");
            }
            case 2: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Running");
            }
            case 1: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Starting");
            }
            case 3: {
                return SessionsTableModelFilter.loc("MSG_Session_State_Stopped");
            }
        }
        return null;
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTreeChanged();
        if (propertyChangeEvent.getNewValue().equals(SD)) {
            ((JPDADebugger)propertyChangeEvent.getSource()).removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

