/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SourcesModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private Listener listener;
    private SourcePath sourcePath;
    private JPDADebugger debugger;
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> additionalSourceRoots = null;
    private final Set<String> sourceRootsSet = new HashSet<String>();
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SourcesModel.this.newSourceFileChooser == null) {
                SourcesModel.this.newSourceFileChooser = new JFileChooser();
                SourcesModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            return false;
                        }
                    }
                });
            }
            if ((n = SourcesModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file = SourcesModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!file.isDirectory() && !FileUtil.isArchiveFile((URL)file.toURI().toURL())) {
                        return;
                    }
                    String string = file.getCanonicalPath();
                    String[] stringArray = SourcesModel.this;
                    synchronized (SourcesModel.this) {
                        SourcesModel.this.additionalSourceRoots.add(string);
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        stringArray = SourcesModel.this.sourcePath.getSourceRoots();
                        int n2 = stringArray.length;
                        String[] stringArray2 = new String[n2 + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                        stringArray2[n2] = string;
                        SourcesModel.this.sourcePath.setSourceRoots(stringArray2);
                        SourcesModel.this.fireTreeChanged();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    SourcesModel.this.fireTreeChanged();
                    return;
                }
                String string = (String)objectArray[n2];
                String[] stringArray = SourcesModel.this;
                // MONITORENTER : SourcesModel.this
                SourcesModel.this.additionalSourceRoots.remove(string);
                // MONITOREXIT : stringArray
                stringArray = SourcesModel.this.sourcePath.getSourceRoots();
                int n3 = stringArray.length;
                String[] stringArray2 = new String[n3 - 1];
                int n4 = -1;
                for (int i = 0; i < n3; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    n4 = i;
                    break;
                }
                if (n4 >= 0) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, n4);
                    System.arraycopy(stringArray, n4 + 1, stringArray2, n4, n3 - (n4 + 1));
                    SourcesModel.this.sourcePath.setSourceRoots(stringArray2);
                }
                ++n2;
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesModel(ContextProvider contextProvider) {
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.updateCachedRoots();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            String[] stringArray = this.sourcePath.getOriginalSourceRoots();
            String[] stringArray2 = this;
            synchronized (this) {
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new LinkedHashSet<String>(Arrays.asList(this.sourcePath.getAdditionalSourceRoots()));
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                stringArray2 = stringArray;
                n2 = Math.min(stringArray2.length, n2);
                n = Math.min(stringArray2.length, n);
                Object[] objectArray = new Object[n2 - n];
                System.arraycopy(stringArray2, n, objectArray, 0, n2 - n);
                if (this.listener == null) {
                    this.listener = new Listener((SourcesModel)this);
                }
                return objectArray;
            }
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public boolean isCheckable(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(NodeModel nodeModel, Object object, Boolean bl) throws UnknownTypeException {
        if (object instanceof String) {
            this.setEnabled((String)object, bl);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getDisplayName(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (this.additionalSourceRoots.contains(object)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        SourcesModel sourcesModel = this;
        synchronized (sourcesModel) {
            return this.sourceRootsSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(this.sourceRootsSet);
        String[] stringArray = this;
        synchronized (this) {
            if (bl) {
                arrayList.add(string);
            } else {
                arrayList.remove(string);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            stringArray = new String[arrayList.size()];
            this.sourcePath.setSourceRoots(arrayList.toArray(stringArray));
            return;
        }
    }

    private synchronized void updateCachedRoots() {
        String[] stringArray = this.sourcePath.getSourceRoots();
        this.sourceRootsSet.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.sourceRootsSet.add(stringArray[i]);
        }
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sorted", bl);
        }

        public void setSortedDescending(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
        }

        public int getCurrentOrderNumber() {
            int n = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (n >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++n;
            }
            return n;
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference<SourcesModel> model;

        private Listener(SourcesModel sourcesModel) {
            this.model = new WeakReference<SourcesModel>(sourcesModel);
            sourcesModel.sourcePath.addPropertyChangeListener(this);
            sourcesModel.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel sourcesModel = (SourcesModel)this.model.get();
            if (sourcesModel == null) {
                sourcesModel.sourcePath.removePropertyChangeListener(this);
                sourcesModel.debugger.getSmartSteppingFilter().removePropertyChangeListener((PropertyChangeListener)this);
            }
            return sourcesModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourcesModel sourcesModel = this.getModel();
            if (sourcesModel == null) {
                return;
            }
            sourcesModel.updateCachedRoots();
            sourcesModel.fireTreeChanged();
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

