/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.debugger.jpda.ui.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelFormatters;
import org.netbeans.modules.debugger.jpda.ui.options.DisablingCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFormatterEditPanel
extends JPanel {
    private JButton addVarButton;
    private ButtonGroup childrenButtonGroup;
    private JEditorPane childrenCodeEditorPane;
    private JRadioButton childrenCodeRadioButton;
    private JScrollPane childrenCodeScrollPane;
    private JCheckBox childrenFormatCheckBox;
    private JRadioButton childrenVariablesRadioButton;
    private JTable childrenVariablesTable;
    private JLabel classTypesLabel;
    private JTextField classTypesTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JButton moveDownVarButton;
    private JButton moveUpVarButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton removeVarButton;
    private JCheckBox subtypesCheckBox;
    private JCheckBox testChildrenCheckBox;
    private JEditorPane testChildrenEditorPane;
    private JScrollPane testChildrenScrollPane;
    private JEditorPane valueEditorPane;
    private JCheckBox valueFormatCheckBox;
    private JScrollPane valueScrollPane;
    private final String[] tableColumnNames = new String[]{NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Name"), NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Value")};
    private Set<String> formatterNames;
    private DialogDescriptor validityDescriptor;
    private NotificationLineSupport validityNotificationSupport;
    private boolean continualValidityChecks = false;

    public VariableFormatterEditPanel() {
        this.initComponents();
        this.initChildrenVariablesTable();
    }

    public void load(VariablesFormatter variablesFormatter) {
        this.nameTextField.setText(variablesFormatter.getName());
        this.classTypesTextField.setText(variablesFormatter.getClassTypesCommaSeparated());
        this.subtypesCheckBox.setSelected(variablesFormatter.isIncludeSubTypes());
        this.valueFormatCheckBox.setSelected(variablesFormatter.getValueFormatCode().trim().length() > 0);
        this.valueEditorPane.setText(variablesFormatter.getValueFormatCode());
        this.childrenFormatCheckBox.setSelected(variablesFormatter.getChildrenFormatCode().trim().length() > 0 || variablesFormatter.getChildrenVariables().size() > 0);
        this.childrenCodeEditorPane.setText(variablesFormatter.getChildrenFormatCode());
        Map<String, String> map = variablesFormatter.getChildrenVariables();
        int n = map.size();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        Object[][] objectArray = new String[n][2];
        for (int i = 0; i < n; ++i) {
            Map.Entry<String, String> entry = iterator.next();
            objectArray[i][0] = entry.getKey();
            objectArray[i][1] = entry.getValue();
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, this.tableColumnNames){

            @Override
            public Class<?> getColumnClass(int n) {
                return String.class;
            }
        };
        this.childrenVariablesTable.setModel(defaultTableModel);
        DisablingCellRenderer.apply(this.childrenVariablesTable);
        this.childrenCodeRadioButton.setSelected(!variablesFormatter.isUseChildrenVariables());
        this.childrenVariablesRadioButton.setSelected(variablesFormatter.isUseChildrenVariables());
        this.testChildrenCheckBox.setSelected(variablesFormatter.getChildrenExpandTestCode().trim().length() > 0);
        this.testChildrenEditorPane.setText(variablesFormatter.getChildrenExpandTestCode());
        this.valueFormatCheckBoxActionPerformed(null);
        this.childrenFormatCheckBoxActionPerformed(null);
        this.nameTextField.requestFocusInWindow();
    }

    public void store(VariablesFormatter variablesFormatter) {
        variablesFormatter.setName(this.nameTextField.getText());
        variablesFormatter.setClassTypes(this.classTypesTextField.getText());
        variablesFormatter.setIncludeSubTypes(this.subtypesCheckBox.isSelected());
        variablesFormatter.setValueFormatCode(this.valueFormatCheckBox.isSelected() ? this.valueEditorPane.getText() : "");
        variablesFormatter.setChildrenFormatCode(this.childrenCodeEditorPane.getText());
        TableModel tableModel = this.childrenVariablesTable.getModel();
        variablesFormatter.getChildrenVariables().clear();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            variablesFormatter.addChildrenVariable((String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1));
        }
        variablesFormatter.setUseChildrenVariables(this.childrenVariablesRadioButton.isSelected());
        variablesFormatter.setChildrenExpandTestCode(this.testChildrenCheckBox.isSelected() ? this.testChildrenEditorPane.getText() : "");
    }

    void setFormatterNames(Set<String> set) {
        this.formatterNames = set;
    }

    void setValidityObjects(DialogDescriptor dialogDescriptor, NotificationLineSupport notificationLineSupport, boolean bl) {
        this.validityDescriptor = dialogDescriptor;
        this.validityNotificationSupport = notificationLineSupport;
        this.continualValidityChecks = bl;
        this.attachValidityChecks();
    }

    private void attachValidityChecks() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                VariableFormatterEditPanel.this.checkValid();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                VariableFormatterEditPanel.this.checkValid();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                VariableFormatterEditPanel.this.checkValid();
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        this.classTypesTextField.getDocument().addDocumentListener(documentListener);
        this.checkValid();
    }

    private boolean checkValidName() {
        String string = this.nameTextField.getText().trim();
        if (string.length() == 0) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_EmptyFormatterName"));
            return false;
        }
        if (this.formatterNames.contains(string)) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_ExistingFormatterName"));
            return false;
        }
        return true;
    }

    private boolean checkValidClasses() {
        String string = this.classTypesTextField.getText().trim();
        if (string.length() == 0) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_EmptyClassName"));
            return false;
        }
        int n = 0;
        char c = string.charAt(n);
        if (Character.isJavaIdentifierStart(c)) {
            boolean bl = true;
            ++n;
            while (n < string.length()) {
                c = string.charAt(n);
                if (c == ',' || Character.isWhitespace(c)) {
                    bl = true;
                } else {
                    if (bl && !Character.isJavaIdentifierStart(c) || !bl && !Character.isJavaIdentifierPart(c) && c != '.') break;
                    bl = false;
                }
                ++n;
            }
        }
        if (n < string.length()) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_InvalidClassNameAtPos", (Object)(n + 1)));
            return false;
        }
        return true;
    }

    private void checkFormatterSelected() {
        boolean bl;
        boolean bl2 = bl = this.valueFormatCheckBox.isSelected() || this.childrenFormatCheckBox.isSelected();
        if (bl) {
            this.validityDescriptor.setValid(true);
            this.validityNotificationSupport.clearMessages();
        } else {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_NoFormatSelected"));
        }
    }

    private void checkValid() {
        if (this.validityNotificationSupport == null || !this.continualValidityChecks) {
            return;
        }
        if (this.checkValidName() && this.checkValidClasses()) {
            this.checkFormatterSelected();
        }
    }

    public boolean checkValidInput() {
        this.continualValidityChecks = true;
        this.checkValid();
        if (!this.validityDescriptor.isValid()) {
            if (!this.checkValidName()) {
                this.nameTextField.requestFocusInWindow();
            } else if (!this.checkValidClasses()) {
                this.classTypesTextField.requestFocusInWindow();
            } else {
                this.valueFormatCheckBox.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    static Color getDisabledFieldBackground() {
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setEnabled(false);
        return jTextField.getBackground();
    }

    private void initComponents() {
        this.childrenButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.classTypesLabel = new JLabel();
        this.classTypesTextField = new JTextField();
        this.subtypesCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.valueFormatCheckBox = new JCheckBox();
        this.valueScrollPane = new JScrollPane();
        this.valueEditorPane = new JEditorPane();
        this.childrenFormatCheckBox = new JCheckBox();
        this.childrenCodeRadioButton = new JRadioButton();
        this.childrenCodeScrollPane = new JScrollPane();
        this.childrenCodeEditorPane = new JEditorPane();
        this.childrenVariablesRadioButton = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.childrenVariablesTable = new JTable();
        this.jPanel3 = new JPanel();
        this.addVarButton = new JButton();
        this.removeVarButton = new JButton();
        this.moveUpVarButton = new JButton();
        this.moveDownVarButton = new JButton();
        this.testChildrenCheckBox = new JCheckBox();
        this.testChildrenScrollPane = new JScrollPane();
        this.testChildrenEditorPane = new JEditorPane();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.nameTextField.text"));
        this.classTypesLabel.setLabelFor(this.classTypesTextField);
        Mnemonics.setLocalizedText((JLabel)this.classTypesLabel, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesLabel.text"));
        this.classTypesTextField.setText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesTextField.text"));
        this.classTypesTextField.setToolTipText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesLabel.tooltip"));
        this.subtypesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.subtypesCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.subtypesCheckBox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.classTypesLabel).add((Component)this.nameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.classTypesTextField, -1, 272, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.subtypesCheckBox)).add((Component)this.nameTextField, -1, 418, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.classTypesLabel).add((Component)this.classTypesTextField, -2, -1, -2).add((Component)this.subtypesCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.valueFormatCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.valueFormatCheckBox.text"));
        this.valueFormatCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.valueFormatCheckBoxActionPerformed(actionEvent);
            }
        });
        this.valueScrollPane.setViewportView(this.valueEditorPane);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenFormatCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenFormatCheckBox.text"));
        this.childrenFormatCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.childrenFormatCheckBoxActionPerformed(actionEvent);
            }
        });
        this.childrenButtonGroup.add(this.childrenCodeRadioButton);
        this.childrenCodeRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenCodeRadioButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenCodeRadioButton.text"));
        this.childrenCodeRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.childrenCodeRadioButtonActionPerformed(actionEvent);
            }
        });
        this.childrenCodeScrollPane.setViewportView(this.childrenCodeEditorPane);
        this.childrenButtonGroup.add(this.childrenVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenVariablesRadioButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesRadioButton.text"));
        this.childrenVariablesRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.childrenVariablesRadioButtonActionPerformed(actionEvent);
            }
        });
        this.childrenVariablesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Name", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }
        });
        this.jScrollPane1.setViewportView(this.childrenVariablesTable);
        this.childrenVariablesTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesTable.a11y.name"));
        this.childrenVariablesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesTable.a11y.description"));
        Mnemonics.setLocalizedText((AbstractButton)this.addVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.addVarButton.text"));
        this.addVarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.addVarButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.removeVarButton.text"));
        this.removeVarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.removeVarButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveUpVarButton.text"));
        this.moveUpVarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.moveUpVarButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveDownVarButton.text"));
        this.moveDownVarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.moveDownVarButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.addVarButton).add((Component)this.removeVarButton).add((Component)this.moveUpVarButton).add((Component)this.moveDownVarButton));
        groupLayout2.linkSize(new Component[]{this.addVarButton, this.moveDownVarButton, this.moveUpVarButton, this.removeVarButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addVarButton).addPreferredGap(0).add((Component)this.removeVarButton).addPreferredGap(1).add((Component)this.moveUpVarButton).addPreferredGap(0).add((Component)this.moveDownVarButton)));
        Mnemonics.setLocalizedText((AbstractButton)this.testChildrenCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.testChildrenCheckBox.text"));
        this.testChildrenCheckBox.setToolTipText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.testChildrenCheckBox.tooltip"));
        this.testChildrenCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableFormatterEditPanel.this.testChildrenCheckBoxActionPerformed(actionEvent);
            }
        });
        this.testChildrenScrollPane.setHorizontalScrollBarPolicy(31);
        this.testChildrenScrollPane.setVerticalScrollBarPolicy(21);
        this.testChildrenScrollPane.setViewportView(this.testChildrenEditorPane);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.valueFormatCheckBox).addContainerGap(235, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(21, 21, 21).add((Component)this.valueScrollPane)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.childrenFormatCheckBox).addContainerGap()).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add(42, 42, 42).add((Component)this.jScrollPane1, -1, 377, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).add(0, 0, 0)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(21, 21, 21).add((Component)this.testChildrenScrollPane, -1, 491, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.testChildrenCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.childrenVariablesRadioButton).addContainerGap()).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(21, 21, 21).add((Component)this.childrenCodeScrollPane)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.childrenCodeRadioButton).addContainerGap()))));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.valueFormatCheckBox).addPreferredGap(0).add((Component)this.valueScrollPane, -1, 49, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.childrenFormatCheckBox).addPreferredGap(0).add((Component)this.childrenCodeRadioButton).addPreferredGap(0).add((Component)this.childrenCodeScrollPane, -1, 49, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.childrenVariablesRadioButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1, false).add((Component)this.jScrollPane1, 0, 0, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.testChildrenCheckBox).addPreferredGap(0).add((Component)this.testChildrenScrollPane, -2, -1, -2).add(0, 0, 0)));
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void addVarButtonActionPerformed(ActionEvent actionEvent) {
        final DefaultTableModel defaultTableModel = (DefaultTableModel)this.childrenVariablesTable.getModel();
        defaultTableModel.addRow(new Object[]{"", ""});
        final int n = defaultTableModel.getRowCount() - 1;
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(n, n);
        this.childrenVariablesTable.editCellAt(n, 0);
        this.childrenVariablesTable.requestFocus();
        this.childrenVariablesTable.getCellEditor(n, 0).shouldSelectCell(new ListSelectionEvent(this.childrenVariablesTable, n, n, true));
        this.addVarButton.setEnabled(false);
        this.removeVarButton.setEnabled(false);
        this.childrenVariablesTable.getCellEditor(n, 0).addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = (String)defaultTableModel.getValueAt(n, 0);
                        if (string.trim().length() == 0) {
                            defaultTableModel.removeRow(n);
                        }
                    }
                });
                VariableFormatterEditPanel.this.childrenVariablesTable.getCellEditor(n, 0).removeCellEditorListener(this);
                VariableFormatterEditPanel.this.addVarButton.setEnabled(true);
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow() >= 0);
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                defaultTableModel.removeRow(n);
                VariableFormatterEditPanel.this.childrenVariablesTable.getCellEditor(n, 0).removeCellEditorListener(this);
                VariableFormatterEditPanel.this.addVarButton.setEnabled(true);
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow() >= 0);
            }
        });
    }

    private void removeVarButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.childrenVariablesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.childrenVariablesTable.getModel();
        defaultTableModel.removeRow(n);
        if (n < this.childrenVariablesTable.getRowCount() || --n >= 0) {
            this.childrenVariablesTable.setRowSelectionInterval(n, n);
        }
    }

    private void moveUpVarButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.childrenVariablesTable.getSelectedRow();
        if (n <= 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.childrenVariablesTable.getModel();
        Object[] objectArray = new Object[]{defaultTableModel.getValueAt(n, 0), defaultTableModel.getValueAt(n, 1)};
        defaultTableModel.removeRow(n);
        defaultTableModel.insertRow(n - 1, objectArray);
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
    }

    private void moveDownVarButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.childrenVariablesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.childrenVariablesTable.getModel();
        if (n >= defaultTableModel.getRowCount() - 1) {
            return;
        }
        Object[] objectArray = new Object[]{defaultTableModel.getValueAt(n, 0), defaultTableModel.getValueAt(n, 1)};
        defaultTableModel.removeRow(n);
        defaultTableModel.insertRow(n + 1, objectArray);
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
    }

    private void valueFormatCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.valueFormatCheckBox.isSelected()) {
            this.valueEditorPane.setEnabled(true);
            this.valueEditorPane.setBackground(this.nameTextField.getBackground());
            this.valueEditorPane.requestFocusInWindow();
        } else {
            this.valueEditorPane.setEnabled(false);
            this.valueEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
        this.checkValid();
    }

    private void childrenFormatCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.childrenFormatCheckBox.isSelected();
        this.childrenCodeRadioButton.setEnabled(bl);
        this.childrenVariablesRadioButton.setEnabled(bl);
        this.testChildrenCheckBox.setEnabled(bl);
        this.childrenCodeRadioButtonActionPerformed(null);
        this.childrenVariablesRadioButtonActionPerformed(null);
        this.testChildrenCheckBoxActionPerformed(null);
        this.checkValid();
    }

    private void childrenCodeRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.childrenCodeRadioButton.isSelected() && this.childrenCodeRadioButton.isEnabled()) {
            this.childrenCodeEditorPane.setEnabled(true);
            this.childrenCodeEditorPane.setBackground(this.nameTextField.getBackground());
            this.childrenCodeEditorPane.requestFocusInWindow();
        }
        if (!this.childrenVariablesRadioButton.isSelected() || !this.childrenVariablesRadioButton.isEnabled()) {
            this.childrenVariablesTable.getSelectionModel().clearSelection();
            this.childrenVariablesTable.setEnabled(false);
            this.addVarButton.setEnabled(false);
            this.removeVarButton.setEnabled(false);
            this.moveUpVarButton.setEnabled(false);
            this.moveDownVarButton.setEnabled(false);
        }
    }

    private void childrenVariablesRadioButtonActionPerformed(ActionEvent actionEvent) {
        if (this.childrenVariablesRadioButton.isSelected() && this.childrenVariablesRadioButton.isEnabled()) {
            this.childrenVariablesTable.setEnabled(true);
            this.childrenVariablesTable.requestFocusInWindow();
            this.addVarButton.setEnabled(true);
            int n = this.childrenVariablesTable.getSelectedRow();
            this.removeVarButton.setEnabled(n >= 0);
            this.moveUpVarButton.setEnabled(n > 0);
            this.moveDownVarButton.setEnabled(n >= 0 && n < this.childrenVariablesTable.getRowCount() - 1);
        }
        if (!this.childrenCodeRadioButton.isSelected() || !this.childrenCodeRadioButton.isEnabled()) {
            this.childrenCodeEditorPane.setEnabled(false);
            this.childrenCodeEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
    }

    private void testChildrenCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.testChildrenCheckBox.isSelected() && this.testChildrenCheckBox.isEnabled()) {
            this.testChildrenEditorPane.setEnabled(true);
            this.testChildrenEditorPane.setBackground(this.nameTextField.getBackground());
            this.testChildrenEditorPane.requestFocusInWindow();
        } else {
            this.testChildrenEditorPane.setEnabled(false);
            this.testChildrenEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
    }

    private void initChildrenVariablesTable() {
        this.removeVarButton.setEnabled(false);
        this.moveUpVarButton.setEnabled(false);
        this.moveDownVarButton.setEnabled(false);
        this.childrenVariablesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow();
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(n >= 0);
                VariableFormatterEditPanel.this.moveUpVarButton.setEnabled(n > 0);
                VariableFormatterEditPanel.this.moveDownVarButton.setEnabled(n >= 0 && n < VariableFormatterEditPanel.this.childrenVariablesTable.getRowCount() - 1);
            }
        });
    }
}

