/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.core.syntax.JSPProcessor;

class IncludedJSPFileProcessor
extends JSPProcessor {
    private StringBuilder importsDeclarations = new StringBuilder();
    private StringBuilder declarations = new StringBuilder();
    private StringBuilder scriptlets = new StringBuilder();

    public IncludedJSPFileProcessor(BaseDocument baseDocument) {
        this.doc = baseDocument;
    }

    protected void renderProcess() throws BadLocationException {
        this.processIncludes();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (!tokenSequence.moveNext()) {
            return;
        }
        do {
            StringBuilder stringBuilder;
            Token token;
            if ((token = tokenSequence.token()).id() != JspTokenId.SCRIPTLET) continue;
            JspTokenId.JavaCodeType javaCodeType = (JspTokenId.JavaCodeType)token.getProperty((Object)"JAVA_CODE_TYPE");
            StringBuilder stringBuilder2 = stringBuilder = javaCodeType == JspTokenId.JavaCodeType.DECLARATION ? this.declarations : this.scriptlets;
            if (javaCodeType == JspTokenId.JavaCodeType.EXPRESSION) continue;
            stringBuilder.append(token.text() + "\n");
        } while (tokenSequence.moveNext());
        this.importsDeclarations.append(this.createImplicitImportStatements(Collections.<String>emptyList()));
    }

    public String getDeclarations() {
        return this.declarations.toString();
    }

    public String getImports() {
        return this.importsDeclarations.toString();
    }

    public String getScriptlets() {
        return this.scriptlets.toString();
    }

    protected void processIncludedFile(IncludedJSPFileProcessor includedJSPFileProcessor) {
        this.declarations.append(includedJSPFileProcessor.getDeclarations());
        includedJSPFileProcessor.getImports();
    }
}

