/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class JspCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        int n = JspSyntaxSupport.get(jTextComponent.getDocument()).checkCompletion(jTextComponent, string, false);
        if (n == 0) {
            return 3;
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if ((n & 1 & 9) != 0) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(jTextComponent.getCaret().getDot()), jTextComponent);
        }
        if (n == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkHideCompletion(BaseDocument baseDocument, int n) {
        int n2 = n == 0 ? 0 : n - 1;
        baseDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = JspSyntaxSupport.tokenSequence(tokenHierarchy, HTMLTokenId.language(), n2);
            if (tokenSequence != null) {
                tokenSequence.move(n2);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return;
                }
                Token token = tokenSequence.token();
                if (tokenSequence.embedded() == null && token.id() == HTMLTokenId.TEXT && !((Object)token.text()).toString().startsWith("<") && !((Object)token.text()).toString().startsWith("&")) {
                    JspCompletionProvider.hideCompletion();
                }
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    public static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            JspCompletionProvider.checkHideCompletion((BaseDocument)document, n);
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (document != null) {
                JspCompletionProvider.checkHideCompletion((BaseDocument)document, n);
            }
            this.doQuery(completionResultSet, document, n);
            completionResultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    private static class DocItem
    implements CompletionDocumentation {
        private JspCompletionItem ri;

        public DocItem(JspCompletionItem jspCompletionItem) {
            this.ri = jspCompletionItem;
        }

        public String getText() {
            return this.ri.getHelp();
        }

        public URL getURL() {
            return this.ri.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String string) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    public static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private JspCompletionItem item;

        public DocQuery(JspCompletionItem jspCompletionItem) {
            this.item = jspCompletionItem;
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            if (this.item != null) {
                if (this.item.hasHelp()) {
                    completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
                }
            } else {
                JspCompletionQuery.CompletionResultSet completionResultSet2 = new JspCompletionQuery.CompletionResultSet();
                JspCompletionQuery.instance().query(completionResultSet2, this.component, n);
                completionResultSet.addAllItems(completionResultSet2.getItems());
                completionResultSet.setAnchorOffset(completionResultSet2.getAnchor());
            }
        }
    }

    public static class Query
    extends AbstractQuery {
        private JTextComponent component;

        Query(int n) {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            JspCompletionQuery.CompletionResultSet completionResultSet2 = new JspCompletionQuery.CompletionResultSet();
            JspCompletionQuery.instance().query(completionResultSet2, this.component, n);
            completionResultSet.addAllItems(completionResultSet2.getItems());
            completionResultSet.setAnchorOffset(completionResultSet2.getAnchor());
        }
    }
}

