/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.formatting;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.AbstractIndenter;
import org.netbeans.modules.css.formatting.api.support.IndentCommand;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.el.lexer.api.ELTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageIndenter
extends AbstractIndenter<ELTokenId> {
    private boolean inExression;
    private int indent = -1;

    public ExpressionLanguageIndenter(Context context) {
        super(ELTokenId.language(), context);
    }

    protected int getFormatStableStart(JoinedTokenSequence<ELTokenId> joinedTokenSequence, int n, int n2, AbstractIndenter.OffsetRanges offsetRanges) throws BadLocationException {
        joinedTokenSequence.move(n, true);
        joinedTokenSequence.moveNext();
        return LexUtilities.getTokenSequenceStartOffset(joinedTokenSequence);
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<ELTokenId> indenterContextData, List<IndentCommand> list) throws BadLocationException {
        IndentCommand indentCommand;
        ArrayList<IndentCommand> arrayList = new ArrayList<IndentCommand>();
        if (indenterContextData.isLanguageBlockStart()) {
            this.inExression = false;
        }
        if (this.inExression) {
            indentCommand = new IndentCommand(IndentCommand.Type.CONTINUE, indenterContextData.getLineStartOffset());
            if (this.indent != -1) {
                indentCommand.setFixedIndentSize(this.indent);
            }
        } else {
            indentCommand = new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getLineStartOffset());
            this.inExression = true;
            indenterContextData.getJoinedTokenSequences().move(indenterContextData.getLineStartOffset());
            int n = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)indenterContextData.getLineStartOffset());
            if (n != -1 && indenterContextData.getLineStartOffset() > n) {
                int n2 = indenterContextData.getLineStartOffset();
                indenterContextData.getJoinedTokenSequences().move(indenterContextData.getLineStartOffset());
                indenterContextData.getJoinedTokenSequences().moveNext();
                Token token = indenterContextData.getJoinedTokenSequences().token();
                if (token != null && token.id() == ELTokenId.STRING_LITERAL && ((Object)token.text()).toString().startsWith("\"")) {
                    ++n2;
                }
                this.indent = n2 - n;
            } else {
                this.indent = -1;
            }
        }
        arrayList.add(indentCommand);
        if (indenterContextData.getNextLineStartOffset() != -1) {
            indentCommand = indenterContextData.isLanguageBlockEnd() ? new IndentCommand(IndentCommand.Type.NO_CHANGE, indenterContextData.getNextLineStartOffset()) : new IndentCommand(IndentCommand.Type.CONTINUE, indenterContextData.getNextLineStartOffset());
            list.add(indentCommand);
        }
        return arrayList;
    }

    protected boolean isWhiteSpaceToken(Token<ELTokenId> token) {
        return token.id() == ELTokenId.WHITESPACE || token.id() == ELTokenId.STRING_LITERAL && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected void reset() {
        this.inExression = false;
        this.indent = -1;
    }
}

