/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.jpa.refactoring.util.PositionBoundsResolver;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceXmlRefactoring
implements JPARefactoring {
    private Collection<? extends FileObject> refactoringSources;

    protected Collection<? extends FileObject> getRefactoringSources() {
        if (this.refactoringSources == null) {
            this.refactoringSources = this.lookupRefactoringSources();
        }
        return this.refactoringSources;
    }

    private Collection<? extends FileObject> lookupRefactoringSources() {
        Collection collection = this.getRefactoring().getRefactoringSource().lookupAll(FileObject.class);
        if (!collection.isEmpty()) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject : collection) {
                if (fileObject.isFolder()) {
                    PersistenceXmlRefactoring.collectChildren(fileObject, arrayList);
                    continue;
                }
                arrayList.add(fileObject);
            }
            return arrayList;
        }
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)this.getRefactoring().getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            return Collections.singleton(nonRecursiveFolder.getFolder());
        }
        TreePathHandle treePathHandle = (TreePathHandle)this.getRefactoring().getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return Collections.singleton(treePathHandle.getFileObject());
        }
        return Collections.emptySet();
    }

    public static void collectChildren(FileObject fileObject, List<FileObject> list) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (RefactoringUtil.isJavaFile(fileObject2)) {
                list.add(fileObject2);
                continue;
            }
            if (!fileObject2.isFolder()) continue;
            PersistenceXmlRefactoring.collectChildren(fileObject2, list);
        }
    }

    protected boolean shouldHandle() {
        for (FileObject fileObject : this.getRefactoringSources()) {
            if (!this.shouldHandle(fileObject)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldHandle(FileObject fileObject) {
        final boolean[] blArray = new boolean[]{false};
        if (RefactoringUtil.isJavaFile(fileObject)) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TreePathHandle treePathHandle = null;
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        if (!compilationUnitTree.getTypeDecls().isEmpty()) {
                            treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                        }
                        if (treePathHandle == null) {
                            blArray[0] = false;
                        } else {
                            Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                            if (element != null) {
                                blArray[0] = element.getKind() == ElementKind.CLASS;
                            }
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return blArray[0];
    }

    @Override
    public final Problem preCheck() {
        if (!this.shouldHandle()) {
            return null;
        }
        Problem problem = null;
        for (FileObject fileObject : this.getRefactoringSources()) {
            for (FileObject fileObject2 : this.getPersistenceXmls(fileObject)) {
                try {
                    ProviderUtil.getPUDataObject((FileObject)fileObject2);
                }
                catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                    Problem problem2 = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)invalidPersistenceXmlException.getPath()));
                    problem = RefactoringUtil.addToEnd(problem2, problem);
                }
            }
        }
        return problem;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (!this.shouldHandle()) {
            return null;
        }
        Problem problem = null;
        for (FileObject fileObject : this.getRefactoringSources()) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null || !this.shouldHandle(fileObject)) continue;
            String string = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
            for (FileObject fileObject2 : this.getPersistenceXmls(fileObject)) {
                Problem problem2;
                try {
                    PUDataObject pUDataObject = ProviderUtil.getPUDataObject((FileObject)fileObject2);
                    problem2 = this.getAffectedPersistenceUnits(pUDataObject, string);
                    for (PersistenceUnit persistenceUnit : problem2) {
                        refactoringElementsBag.add(this.getRefactoring(), this.getRefactoringElement(persistenceUnit, fileObject, pUDataObject, fileObject2));
                    }
                }
                catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                    problem2 = new Problem(false, NbBundle.getMessage(PersistenceXmlRefactoring.class, (String)"TXT_PersistenceXmlInvalidProblem", (Object)invalidPersistenceXmlException.getPath()));
                    problem = RefactoringUtil.addToEnd(problem2, problem);
                }
            }
        }
        return problem;
    }

    protected abstract AbstractRefactoring getRefactoring();

    protected abstract RefactoringElementImplementation getRefactoringElement(PersistenceUnit var1, FileObject var2, PUDataObject var3, FileObject var4);

    protected final List<PersistenceUnit> getAffectedPersistenceUnits(PUDataObject pUDataObject, String string) {
        PersistenceUnit[] persistenceUnitArray;
        ArrayList<PersistenceUnit> arrayList = new ArrayList<PersistenceUnit>();
        for (PersistenceUnit persistenceUnit : persistenceUnitArray = ProviderUtil.getPersistenceUnits((PUDataObject)pUDataObject)) {
            if (!PersistenceXmlRefactoring.hasClass(persistenceUnit, string)) continue;
            arrayList.add(persistenceUnit);
        }
        return arrayList;
    }

    private static boolean hasClass(PersistenceUnit persistenceUnit, String string) {
        for (String string2 : persistenceUnit.getClass2()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected final List<FileObject> getPersistenceXmls(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        PersistenceScope[] persistenceScopeArray = PersistenceUtils.getPersistenceScopes((Project)project);
        for (int i = 0; i < persistenceScopeArray.length; ++i) {
            FileObject fileObject2 = persistenceScopeArray[i].getPersistenceXml();
            if (fileObject2 == null) continue;
            arrayList.add(fileObject2);
        }
        return arrayList;
    }

    protected static abstract class PersistenceXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final PersistenceUnit persistenceUnit;
        protected final PUDataObject puDataObject;
        protected final String clazz;
        protected final FileObject parentFile;

        protected PersistenceXmlRefactoringElement(PersistenceUnit persistenceUnit, String string, PUDataObject pUDataObject, FileObject fileObject) {
            this.clazz = string;
            this.persistenceUnit = persistenceUnit;
            this.puDataObject = pUDataObject;
            this.parentFile = fileObject;
        }

        public final String getText() {
            return this.getDisplayText();
        }

        public final Lookup getLookup() {
            return Lookups.singleton((Object)this.parentFile);
        }

        public final FileObject getParentFile() {
            return this.parentFile;
        }

        public final PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.parentFile), this.clazz).getPositionBounds();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return null;
            }
        }
    }
}

