/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public abstract class RefactoringUtil {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static String renameClass(String string, String string2) {
        Parameters.notEmpty((CharSequence)"originalFullyQualifiedName", (CharSequence)string);
        Parameters.notEmpty((CharSequence)"newName", (CharSequence)string2);
        int n = string.lastIndexOf(46);
        return n <= 0 ? string2 : string.substring(0, n + 1) + string2;
    }

    public static Problem addToEnd(Problem problem, Problem problem2) {
        if (problem2 == null) {
            return problem;
        }
        if (problem == null) {
            return problem2;
        }
        Problem problem3 = problem2;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem);
        return problem3;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(project)) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (fileObject == sourceGroupArray[i].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static CompilationInfo getCompilationInfo(TreePathHandle treePathHandle, final AbstractRefactoring abstractRefactoring) {
        CompilationInfo compilationInfo = (CompilationInfo)abstractRefactoring.getRefactoringSource().lookup(CompilationInfo.class);
        if (compilationInfo != null) {
            return compilationInfo;
        }
        ClasspathInfo classpathInfo = (ClasspathInfo)abstractRefactoring.getContext().lookup(ClasspathInfo.class);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{treePathHandle.getFileObject()});
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    abstractRefactoring.getContext().add((Object)compilationController);
                }

                public void cancel() {
                }
            }, false);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return (CompilationInfo)abstractRefactoring.getContext().lookup(CompilationInfo.class);
    }

    public static String getPropertyName(String string) {
        Parameters.notEmpty((CharSequence)"accessor", (CharSequence)string);
        int n = RefactoringUtil.getPrefixLength(string);
        String string2 = string.substring(n);
        char c = string2.charAt(0);
        if (!Character.isUpperCase(c)) {
            return string;
        }
        return Character.toLowerCase(c) + string2.substring(1);
    }

    private static int getPrefixLength(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"get", "set", "is"}) {
            if (!string.startsWith(string2)) continue;
            return string2.length();
        }
        return 0;
    }

    public static TreePathHandle resolveTreePathHandle(AbstractRefactoring abstractRefactoring) throws IOException {
        Parameters.notNull((CharSequence)"refactoring", (Object)abstractRefactoring);
        TreePathHandle treePathHandle = (TreePathHandle)abstractRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return treePathHandle;
        }
        final TreePathHandle[] treePathHandleArray = new TreePathHandle[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)((FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class)));
        javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                treePathHandleArray[0] = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
            }
        }, true);
        return treePathHandleArray[0];
    }

    public static TreePathHandle getTreePathHandle(final String string, final String string2, FileObject fileObject) throws IOException {
        final TreePathHandle[] treePathHandleArray = new TreePathHandle[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string2);
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!element.getSimpleName().contentEquals(string)) continue;
                    TreePath treePath = compilationController.getTrees().getPath(element);
                    treePathHandleArray[0] = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationController);
                }
            }
        }, true);
        return treePathHandleArray[0];
    }

    public static String getPackageName(URL uRL) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + uRL);
        }
        String string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return RefactoringUtil.getPackageName(fileObject);
                }
                String string2 = RefactoringUtil.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + string;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    private static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }
}

