/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.web.client.tools.common.dbgp.BaseMessageChildElement;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.UnsufficientValueException;
import org.w3c.dom.Node;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
extends BaseMessageChildElement {
    static final String PROPERTY = "property";
    private static final String NUMCHILDREN = "numchildren";
    static final String ENCODING = "encoding";
    private static final String KEY = "key";
    private static final String ADDRESS = "address";
    private static final String PAGESIZE = "pagesize";
    private static final String PAGE = "page";
    private static final String NAME = "name";
    private static final String FULL_NAME = "fullname";
    private static final String TYPE = "type";
    private static final String CLASS_NAME = "classname";
    private static final String CONSTANT = "constant";
    private static final String CHILDREN = "children";
    private static final String FACET = "facet";
    static final String SIZE = "size";

    Property(Node node) {
        super(node);
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public void setName(String string) {
        Node node = this.getNode().getAttributes().getNamedItem(NAME);
        if (node == null) {
            node = this.getNode().getOwnerDocument().createAttribute(NAME);
            this.getNode().appendChild(node);
        }
        node.setNodeValue(string);
    }

    public String getFullName() {
        return this.getAttribute(FULL_NAME);
    }

    public String getType() {
        return this.getAttribute(TYPE);
    }

    public String getClassName() {
        return this.getAttribute(CLASS_NAME);
    }

    public boolean isConstant() {
        return this.getInt(CONSTANT) > 0;
    }

    public boolean hasChildren() {
        return this.getInt(CHILDREN) > 0;
    }

    public int getSize() {
        return this.getInt(SIZE);
    }

    public int getPage() {
        return this.getInt(PAGE);
    }

    public int getPageSize() {
        return this.getInt(PAGESIZE);
    }

    public int getAddress() {
        return this.getInt(ADDRESS);
    }

    public String getKey() {
        return this.getAttribute(KEY);
    }

    public String getFacet() {
        return this.getAttribute(FACET);
    }

    public Message.Encoding getEncoding() {
        String string = this.getAttribute(ENCODING);
        return Message.Encoding.valueOf(string.toUpperCase());
    }

    public int getChildrenSize() {
        return this.getInt(NUMCHILDREN);
    }

    public List<Property> getChildren() {
        List<Node> list = this.getChildren(PROPERTY);
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        for (Node node : list) {
            arrayList.add(new Property(node));
        }
        return arrayList;
    }

    public byte[] getValue() throws UnsufficientValueException {
        byte[] byArray = Message.getDecodedBytes(this.getEncoding(), Message.getNodeValue(this.getNode()));
        Message.checkValue(byArray, this.getSize());
        return byArray;
    }

    public String getStringValue() throws UnsufficientValueException {
        try {
            return new String(this.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.getValue());
        }
    }

    public static boolean equals(Property property, Property property2) {
        byte[] byArray;
        byte[] byArray2;
        if (property == null) {
            return property2 == null;
        }
        try {
            byArray2 = property.getValue();
        }
        catch (UnsufficientValueException unsufficientValueException) {
            return false;
        }
        if (property2 == null) {
            return false;
        }
        try {
            byArray = property2.getValue();
        }
        catch (UnsufficientValueException unsufficientValueException) {
            return false;
        }
        return Arrays.equals(byArray2, byArray);
    }

    public static class PropertyValueResponse
    extends ResponseMessage {
        PropertyValueResponse(Node node) {
            super(node);
        }

        public Property getProperty() {
            Node node = PropertyValueResponse.getChild(this.getNode(), Property.PROPERTY);
            if (node != null) {
                return new Property(node);
            }
            return null;
        }
    }

    public static class PropertyValueCommand
    extends PropertyGetCommand {
        private int propAddress = -1;

        public PropertyValueCommand(int n, String string, int n2) {
            super(CommandMap.PROPERTY_VALUE.getCommand(), n, string, n2);
        }

        public void setAddress(int n) {
            this.propAddress = n;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder(super.getArguments());
            if (this.propAddress != -1) {
                stringBuilder.append(" ");
                stringBuilder.append("-a ");
                stringBuilder.append(this.propAddress);
            }
            return stringBuilder.toString();
        }
    }

    public static class PropertySetResponse
    extends ResponseMessage {
        PropertySetResponse(Node node) {
            super(node);
        }

        public boolean isSet() {
            return PropertySetResponse.getBoolean(this.getNode(), "success");
        }
    }

    public static class PropertySetCommand
    extends PropertyCommand {
        private static final String TYPE_ARG = "-t ";
        static final String ADDRESS_ARG = "-a ";
        private static final String LENGTH_ARG = "-l ";
        private static final String VALUE_ARG = "-- ";
        private String dataType;
        private int propAddress = -1;
        private String data;
        private String value;

        public PropertySetCommand(int n, String string, int n2) {
            super(CommandMap.PROPERTY_SET.getCommand(), n, string, n2);
        }

        public PropertySetCommand(int n, String string, String string2, int n2) {
            super(CommandMap.PROPERTY_SET.getCommand(), n, string, n2);
            this.value = string2;
        }

        public boolean wantAcknowledgment() {
            return true;
        }

        public void setDataType(String string) {
            this.dataType = string;
        }

        public void setAddress(int n) {
            this.propAddress = n;
        }

        public void setData(String string) {
            this.data = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getName() {
            return super.getName();
        }

        protected String getData() {
            return this.data;
        }

        protected String getValue() {
            return this.value;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder(super.getArguments());
            if (this.dataType != null) {
                stringBuilder.append(" ");
                stringBuilder.append(TYPE_ARG);
                stringBuilder.append(this.dataType);
            }
            if (this.propAddress != -1) {
                stringBuilder.append(" ");
                stringBuilder.append(ADDRESS_ARG);
                stringBuilder.append(this.propAddress);
            }
            if (this.getData() != null && this.getData().length() > 0) {
                try {
                    BASE64Encoder bASE64Encoder = new BASE64Encoder();
                    int n = bASE64Encoder.encode(this.getData().getBytes("ISO-8859-1")).length();
                    stringBuilder.append(" ");
                    stringBuilder.append(LENGTH_ARG);
                    stringBuilder.append(n);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    assert (false);
                }
            } else {
                stringBuilder.append(" ");
                stringBuilder.append(VALUE_ARG);
                stringBuilder.append(this.value);
            }
            return stringBuilder.toString();
        }
    }

    public static class PropertyGetResponse
    extends ResponseMessage {
        PropertyGetResponse(Node node) {
            super(node);
        }

        public Property getProperty() {
            Node node = PropertyGetResponse.getChild(this.getNode(), Property.PROPERTY);
            if (node != null) {
                return new Property(node);
            }
            return null;
        }
    }

    public static class PropertyGetCommand
    extends PropertyCommand {
        private static final String KEY_ARG = "-k ";
        private String key;

        public PropertyGetCommand(int n, String string, int n2) {
            this(CommandMap.PROPERTY_GET.getCommand(), n, string, n2);
        }

        protected PropertyGetCommand(String string, int n, String string2, int n2) {
            super(string, n, string2, n2);
        }

        public boolean wantAcknowledgment() {
            return true;
        }

        public void setKey(String string) {
            this.key = string;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder(super.getArguments());
            if (this.key != null) {
                stringBuilder.append(" ");
                stringBuilder.append(KEY_ARG);
                stringBuilder.append(this.key);
            }
            return stringBuilder.toString();
        }
    }

    public static abstract class PropertyCommand
    extends Command {
        private static final String NAME_ARG = "-n ";
        private static final String MAX_SIZE_ARG = "-m ";
        private static final String CONTEXT_ARG = "-c ";
        private static final String DEPTH_ARG = "-d ";
        private static final String PAGE_ARG = "-p ";
        private int page = -1;
        private int context = -1;
        private int stackDepth;
        private String name;
        private int size = -1;

        PropertyCommand(String string, int n, String string2, int n2) {
            super(string, n);
            this.stackDepth = n2;
            this.name = string2;
        }

        public void setStackDepth(int n) {
            this.stackDepth = n;
        }

        public void setContext(int n) {
            this.context = n;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setMaxDataSize(int n) {
            this.size = n;
        }

        public void setDataPage(int n) {
            this.page = n;
        }

        protected String getName() {
            return this.name;
        }

        protected int getContext() {
            return this.context;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder(NAME_ARG);
            stringBuilder.append(this.name);
            this.setDepth(stringBuilder);
            this.setContext(stringBuilder);
            this.setMaxSize(stringBuilder);
            this.setPage(stringBuilder);
            return stringBuilder.toString();
        }

        private void setPage(StringBuilder stringBuilder) {
            if (this.page == -1) {
                return;
            }
            stringBuilder.append(" ");
            stringBuilder.append(PAGE_ARG);
            stringBuilder.append(this.page);
        }

        private void setMaxSize(StringBuilder stringBuilder) {
            if (this.size == -1) {
                return;
            }
            stringBuilder.append(" ");
            stringBuilder.append(MAX_SIZE_ARG);
            stringBuilder.append(this.size);
        }

        private void setContext(StringBuilder stringBuilder) {
            if (this.context == -1) {
                return;
            }
            stringBuilder.append(" ");
            stringBuilder.append(CONTEXT_ARG);
            stringBuilder.append(this.context);
        }

        private void setDepth(StringBuilder stringBuilder) {
            if (this.stackDepth == -1) {
                return;
            }
            stringBuilder.append(" ");
            stringBuilder.append(DEPTH_ARG);
            stringBuilder.append(this.stackDepth);
        }
    }
}

