/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.UnsufficientValueException;
import org.w3c.dom.Node;

public class StreamMessage
extends Message {
    private static final String TYPE = "type";

    StreamMessage(Node node, StreamType streamType) {
        super(node);
    }

    public String getType() {
        return StreamMessage.getAttribute(this.getNode(), TYPE);
    }

    public int getSize() {
        return StreamMessage.getInt(this.getNode(), "size");
    }

    public Message.Encoding getEncoding() {
        String string = StreamMessage.getAttribute(this.getNode(), "encoding");
        return string != null ? Message.Encoding.valueOf(string.toUpperCase()) : null;
    }

    public byte[] getValue() throws UnsufficientValueException {
        byte[] byArray = StreamMessage.getDecodedBytes(this.getEncoding(), Message.getNodeValue(this.getNode()));
        StreamMessage.checkValue(byArray, this.getSize());
        return byArray;
    }

    public String getStringValue() throws UnsufficientValueException {
        return new String(this.getValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StreamType {
        STDOUT(CommandMap.STDOUT.getCommand()),
        STDERR(CommandMap.STDERR.getCommand());

        String cmd;

        private StreamType(String string2) {
            this.cmd = string2;
        }

        String getCommand() {
            return this.cmd;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

