/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class Launcher {
    private static final Logger LOG = Logger.getLogger(Launcher.class.getPackage().getName());

    public static Process launch(LaunchDescriptor launchDescriptor) throws IOException {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(Arrays.asList(launchDescriptor.getLaunchCommand()));
        String string = launchDescriptor.getArguments();
        if (string != null && string.trim().length() > 0) {
            for (String string2 : string.split("\\s")) {
                if (string2.length() <= 0) continue;
                linkedList.add(string2);
            }
        }
        for (String string3 : launchDescriptor.getURIs()) {
            linkedList.add(string3);
        }
        if (LOG.isLoggable(Level.FINE)) {
            object = "";
            for (String string4 : linkedList) {
                object = (String)object + " " + string4;
            }
            LOG.fine("Launching:" + (String)object);
        }
        object = new ProcessBuilder(linkedList);
        Process process = ((ProcessBuilder)object).start();
        ProcessWaiter processWaiter = new ProcessWaiter(((Object)linkedList).toString(), process);
        processWaiter.start();
        return process;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LaunchDescriptor {
        private static final String[] MACOS_FIREFOX_LAUNCH_COMMAND = new String[]{"/usr/bin/open", "-b", "org.mozilla.firefox"};
        private String executablePath;
        private String[] computedExecutablePath;
        private String arguments;
        private List<String> uriList;

        public LaunchDescriptor(String string) {
            this.executablePath = string;
            this.computedExecutablePath = Utilities.isMac() ? MACOS_FIREFOX_LAUNCH_COMMAND : new String[]{string};
        }

        public String[] getLaunchCommand() {
            return this.computedExecutablePath;
        }

        public String getURI() {
            if (this.uriList != null && this.uriList.size() > 0) {
                return this.uriList.get(0);
            }
            return null;
        }

        public void setURI(String string) {
            this.uriList = new ArrayList<String>();
            this.uriList.add(string);
        }

        public void setURI(List<String> list) {
            this.uriList = list;
        }

        public String getArguments() {
            return this.arguments;
        }

        public void setArguments(String string) {
            this.arguments = string;
        }

        public List<String> getURIs() {
            return this.uriList;
        }
    }

    private static class ProcessWaiter
    extends Thread {
        private Process process;
        private String command;

        ProcessWaiter(String string, Process process) {
            this.command = string;
            this.process = process;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block16: {
                try {
                    int n = this.process.waitFor();
                    if (n == 0) break block16;
                    BufferedReader bufferedReader = null;
                    for (InputStream inputStream : new InputStream[]{this.process.getErrorStream(), this.process.getInputStream()}) {
                        try {
                            if (inputStream == null) continue;
                            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            while (bufferedReader.ready()) {
                                String string = bufferedReader.readLine();
                                LOG.info(string);
                            }
                        }
                        catch (Exception exception) {
                            LOG.log(Level.INFO, "Unexpected exception reading output", exception);
                        }
                        finally {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            bufferedReader = null;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

