/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspLoader;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.core.palette.JspPaletteFactory;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;

class BaseJspEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie.Observable,
OpenCookie,
LineCookie,
CloseCookie,
PrintCookie,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(BaseJspEditorSupport.class.getName());
    private static final int AUTO_PARSING_DELAY = 2000;
    private Timer timer;
    private String encoding;
    private static String defaulEncoding = "UTF-8";
    private static final Set<String> UTF_16_CHARSETS = new HashSet<String>();
    private static final Set<String> UTF_32_CHARSETS = new HashSet<String>();

    public BaseJspEditorSupport(JspDataObject jspDataObject) {
        super((DataObject)jspDataObject, (CloneableEditorSupport.Env)new BaseJspEnv(jspDataObject));
        DataObject dataObject = this.getDataObject();
        if (dataObject != null && dataObject instanceof JspDataObject) {
            this.setMIMEType(JspLoader.getMimeType((JspDataObject)dataObject));
        }
        this.initialize();
    }

    public boolean close() {
        TagLibParseSupport tagLibParseSupport = (TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class);
        if (tagLibParseSupport != null) {
            tagLibParseSupport.cancelParsingTask();
        }
        return super.close();
    }

    private void initialize() {
        FileObject fileObject;
        ClassPath classPath;
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final TagLibParseSupport tagLibParseSupport = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (tagLibParseSupport != null && WebModule.getWebModule((FileObject)BaseJspEditorSupport.this.getDataObject().getPrimaryFile()) != null) {
                    tagLibParseSupport.autoParse().addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            BaseJspEditorSupport.this.notifyParsingDone(tagLibParseSupport);
                        }
                    });
                }
            }
        });
        this.timer.setInitialDelay(2000);
        this.timer.setRepeats(false);
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            private void change(DocumentEvent documentEvent) {
                BaseJspEditorSupport.this.restartTimer(false);
                TagLibParseSupport tagLibParseSupport = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (tagLibParseSupport != null) {
                    tagLibParseSupport.setDocumentDirty(true);
                }
            }
        };
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (BaseJspEditorSupport.this.isDocumentLoaded() && BaseJspEditorSupport.this.getDocument() != null) {
                    BaseJspEditorSupport.this.getDocument().addDocumentListener(documentListener);
                }
            }
        });
        this.encoding = null;
        WebModule webModule = this.getWebModule(this.getDataObject().getPrimaryFile());
        if (webModule != null && (classPath = ClassPath.getClassPath((FileObject)(fileObject = webModule.getDocumentBase()), (String)"classpath/execute")) != null) {
            classPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)classPath));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.restartTimer(false);
    }

    private WebModule getWebModule(FileObject fileObject) {
        FileObject fileObject2;
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null && (fileObject2 = webModule.getDocumentBase()) != null && (fileObject == fileObject2 || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return webModule;
        }
        return null;
    }

    private void restartTimer(boolean bl) {
        if (bl && !this.timer.isRunning()) {
            return;
        }
        int n = 2000;
        if (n > 0) {
            this.timer.setInitialDelay(n);
            this.timer.restart();
        }
    }

    private boolean isSupportedEncoding(String string) {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            bl = false;
        }
        return bl;
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        ((JspDataObject)this.getDataObject()).updateFileEncoding(false);
        super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
    }

    public void open() {
        ((JspDataObject)this.getDataObject()).updateFileEncoding(false);
        this.encoding = ((JspDataObject)this.getDataObject()).getFileEncoding();
        if (!this.isSupportedEncoding(this.encoding)) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaulEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
        this.restartTimer(false);
    }

    protected void notifyClose() {
    }

    protected void notifyParsingDone(TagLibParseSupport tagLibParseSupport) {
        if (tagLibParseSupport.isDocumentDirty()) {
            this.restartTimer(false);
        }
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        JspDataObject jspDataObject = (JspDataObject)this.getDataObject();
        if (jspDataObject.getCookie(SaveCookie.class) == null) {
            jspDataObject.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        BaseJspEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JspDataObject jspDataObject = (JspDataObject)this.getDataObject();
        jspDataObject.removeSaveCookie();
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true, true);
    }

    protected void saveDocumentIfNecessary(boolean bl) throws IOException {
        this.saveDocument(bl, false);
    }

    private void saveDocument(boolean bl, boolean bl2) throws IOException {
        if (bl2 || this.isModified()) {
            Object object;
            ((JspDataObject)this.getDataObject()).updateFileEncoding(true);
            this.encoding = ((JspDataObject)this.getDataObject()).getFileEncoding();
            if (!this.isSupportedEncoding(this.encoding)) {
                object = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaulEncoding}), 0, 2);
                object.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                if (object.getValue() != NotifyDescriptor.YES_OPTION) {
                    throw new UserCancelException();
                }
            } else {
                try {
                    object = Charset.forName(this.encoding).newEncoder();
                    if (!((CharsetEncoder)object).canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding}), 0, 2);
                        confirmation.setValue(NotifyDescriptor.NO_OPTION);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                        if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                            throw new UserCancelException();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger("global").log(Level.INFO, null, badLocationException);
                }
            }
            super.saveDocument();
            if (bl && (object = (TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class)) != null) {
                ((TagLibParseSupport)object).prepare();
            }
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new BaseJspEditor(this);
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        Parameters.notNull((CharSequence)"doc", (Object)styledDocument);
        Parameters.notNull((CharSequence)"kit", (Object)editorKit);
        Charset charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        this.writeByteOrderMark(charset, outputStream);
        super.saveFromKitToStream(styledDocument, editorKit, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteOrderMark(Charset charset, OutputStream outputStream) throws IOException {
        if (!UTF_16_CHARSETS.contains(charset.name()) && !UTF_32_CHARSETS.contains(charset.name())) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);
        try {
            ((Writer)outputStreamWriter).write(65533);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return;
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (UTF_16_CHARSETS.contains(charset.name()) && byArray.length > 2 || UTF_32_CHARSETS.contains(charset.name()) && byArray.length > 4) {
            return;
        }
        if (UTF_16_CHARSETS.contains(charset.name())) {
            if (byArray.length < 2) {
                return;
            }
            if (byArray[0] == -1 && byArray[1] == -3) {
                outputStream.write(254);
                outputStream.write(255);
            } else if (byArray[0] == -3 && byArray[1] == -1) {
                outputStream.write(255);
                outputStream.write(254);
            }
        } else if (UTF_32_CHARSETS.contains(charset.name())) {
            if (byArray.length < 4) {
                return;
            }
            if (byArray[0] == -1 && byArray[1] == -3 && byArray[2] == 0 && byArray[3] == 0) {
                outputStream.write(0);
                outputStream.write(0);
                outputStream.write(254);
                outputStream.write(255);
            } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -3 && byArray[3] == -1) {
                outputStream.write(255);
                outputStream.write(254);
                outputStream.write(0);
                outputStream.write(0);
            }
        }
    }

    static {
        Collections.addAll(UTF_16_CHARSETS, "UTF-16", "UTF-16LE", "UTF-16BE");
        Collections.addAll(UTF_32_CHARSETS, "UTF-32", "UTF-32LE", "UTF-32BE");
    }

    public static class BaseJspEditor
    extends CloneableEditor {
        public static final String JSP_MIME_TYPE = "text/x-jsp";
        public static final String TAG_MIME_TYPE = "text/x-tag";
        private TagLibParseSupport taglibParseSupport;
        private InstanceContent instanceContent;
        CaretListener caretListener;

        public BaseJspEditor() {
        }

        public boolean isXmlSyntax(DataObject dataObject) {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
            if (fileObject == null) {
                return false;
            }
            return this.taglibParseSupport.getCachedOpenInfo(false, false).isXmlSyntax();
        }

        void associatePalette(BaseJspEditorSupport baseJspEditorSupport) {
            DataObject dataObject = baseJspEditorSupport.getDataObject();
            String string = dataObject.getPrimaryFile().getMIMEType();
            this.instanceContent.add((Object)this.getActionMap());
            if (dataObject instanceof JspDataObject && (string.equals(JSP_MIME_TYPE) || string.equals(TAG_MIME_TYPE))) {
                try {
                    PaletteController paletteController = JspPaletteFactory.getPalette();
                    this.instanceContent.add((Object)paletteController);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public BaseJspEditor(BaseJspEditorSupport baseJspEditorSupport) {
            super((CloneableEditorSupport)baseJspEditorSupport);
            this.initialize();
        }

        protected void notifyParsingDone() {
        }

        private void initialize() {
            Node[] nodeArray = new Node[]{((DataEditorSupport)this.cloneableEditorSupport()).getDataObject().getNodeDelegate()};
            this.instanceContent = new InstanceContent();
            this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.instanceContent), nodeArray[0].getLookup()}));
            this.setActivatedNodes(nodeArray);
            this.caretListener = new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    ((BaseJspEditorSupport)BaseJspEditor.this.cloneableEditorSupport()).restartTimer(true);
                }
            };
            this.taglibParseSupport = (TagLibParseSupport)((BaseJspEditorSupport)this.cloneableEditorSupport()).getDataObject().getCookie(TagLibParseSupport.class);
        }

        protected void componentActivated() {
            if (this.getEditorPane() != null) {
                this.getEditorPane().addCaretListener(this.caretListener);
                super.componentActivated();
            }
            ((BaseJspEditorSupport)this.cloneableEditorSupport()).restartTimer(false);
            this.taglibParseSupport.setEditorOpened(true);
            this.associatePalette((BaseJspEditorSupport)this.cloneableEditorSupport());
        }

        protected void componentDeactivated() {
            if (this.getEditorPane() != null) {
                this.getEditorPane().removeCaretListener(this.caretListener);
                super.componentDeactivated();
            }
            this.taglibParseSupport.setEditorOpened(false);
        }

        protected boolean closeLast() {
            if (!super.closeLast()) {
                return false;
            }
            ((BaseJspEditorSupport)this.cloneableEditorSupport()).notifyClose();
            return true;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
            this.associatePalette((BaseJspEditorSupport)this.cloneableEditorSupport());
        }
    }

    public static class BaseJspEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public BaseJspEnv(JspDataObject jspDataObject) {
            super((DataObject)jspDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (BaseJspEditorSupport)this.getDataObject().getCookie(BaseJspEditorSupport.class);
        }
    }
}

