/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPropertyOrderingController
implements InspectorOrderingController {
    private String propertyName;
    private Integer order;
    private TypeID supportedTypeID;

    public ArrayPropertyOrderingController(String string, Integer n, TypeID typeID) {
        this.propertyName = string;
        this.order = n;
        this.supportedTypeID = typeID;
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent designComponent, Collection<InspectorFolder> collection) {
        ArrayList<InspectorFolder> arrayList = new ArrayList<InspectorFolder>(collection.size());
        if (designComponent == null) {
            return new ArrayList<InspectorFolder>(collection);
        }
        List list = designComponent.readProperty(this.propertyName).getArray();
        if (list == null) {
            return new ArrayList<InspectorFolder>(collection);
        }
        block0: for (PropertyValue propertyValue : list) {
            DesignComponent designComponent2 = propertyValue.getComponent();
            for (InspectorFolder inspectorFolder : collection) {
                if (!inspectorFolder.getComponentID().equals(designComponent2.getComponentID())) continue;
                arrayList.add(inspectorFolder);
                continue block0;
            }
        }
        return arrayList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument designDocument, TypeID typeID) {
        return designDocument.getDescriptorRegistry().isInHierarchy(this.supportedTypeID, typeID);
    }
}

