/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.common.PropertiesSupport;
import org.netbeans.modules.vmd.inspector.InspectorChildren;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.PasteType;

final class InspectorFolderNode
extends AbstractNode {
    private static final Action[] EMPTY_ACTION_ARRAY = new Action[0];
    private static DataFlavor INSPECTOR_NODE_DATA_FLAVOR = new DataFlavor(NodeTransferable.class, "Nodetransferable");
    private Long componentID;
    private WeakReference<DesignComponent> component;
    private InspectorFolder folder;
    private Transferable transferable;

    InspectorFolderNode(DataObjectContext dataObjectContext) {
        super((Children)new InspectorChildren(), dataObjectContext.getDataObject().getLookup());
    }

    InspectorFolderNode() {
        super((Children)new InspectorChildren());
    }

    Long getComponentID() {
        return this.componentID;
    }

    public String getHtmlDisplayName() {
        if (this.component == null) {
            return "";
        }
        final String[] stringArray = new String[1];
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                InfoPresenter infoPresenter = (InfoPresenter)InspectorFolderNode.this.getComponent().getPresenter(InfoPresenter.class);
                stringArray[0] = infoPresenter.getDisplayName(InfoPresenter.NameType.SECONDARY);
            }
        });
        String string = this.getName();
        if (this.getName() != null && this.getName().contains("<")) {
            string = this.getName().replace("<", "&lt;").replace(">", "&gt;");
        }
        return stringArray[0] != null ? string + " <font color=\"#808080\">[" + stringArray[0] + "]" : string;
    }

    public Image getIcon(int n) {
        if (this.folder == null) {
            throw new IllegalStateException("Not resolved Folder- Broken tree structure. Check InspectorPosisitonPresenters and InspectorFolderPresenters");
        }
        return this.folder.getIcon();
    }

    public Image getOpenedIcon(int n) {
        return this.folder.getIcon();
    }

    public Action[] getActions(boolean bl) {
        if (this.folder.getActions() == null) {
            return EMPTY_ACTION_ARRAY;
        }
        return this.folder.getActions();
    }

    public boolean canRename() {
        return false;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        return this.folder.createSuggestion(transferable);
    }

    public void setName(final String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name cant be null");
        }
        if (this.component == null || this.component.get() == null) {
            return;
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                InfoPresenter infoPresenter = (InfoPresenter)((DesignComponent)InspectorFolderNode.this.component.get()).getPresenter(InfoPresenter.class);
                if (infoPresenter != null) {
                    infoPresenter.setEditableName(string);
                }
            }
        });
    }

    void resolveNode(final InspectorFolderWrapper inspectorFolderWrapper, final DesignDocument designDocument) {
        this.folder = inspectorFolderWrapper.getFolder();
        super.setDisplayName(this.folder.getDisplayName());
        this.componentID = this.folder.getComponentID();
        if (this.folder.getName() == null) {
            super.setName(this.folder.getDisplayName());
        } else {
            super.setName(this.folder.getName());
        }
        if (this.componentID != null) {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    InspectorFolderNode.this.component = new WeakReference<DesignComponent>(designDocument.getComponentByUID(InspectorFolderNode.this.componentID.longValue()));
                    InspectorFolderNode.this.transferable = new NodeTransferable((DesignComponent)InspectorFolderNode.this.component.get());
                }
            });
        }
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                ((InspectorChildren)InspectorFolderNode.this.getChildren()).setKeys(inspectorFolderWrapper.getChildrenNodes());
            }
        });
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        super.createPasteTypes(transferable, list);
        if (!transferable.isDataFlavorSupported(INSPECTOR_NODE_DATA_FLAVOR)) {
            return;
        }
        PasteType pasteType = this.getDropType(transferable, 3, -1);
        if (pasteType != null) {
            list.add(pasteType);
        }
    }

    public PasteType getDropType(final Transferable transferable, int n, int n2) {
        final PasteType[] pasteTypeArray = new PasteType[1];
        if (!transferable.isDataFlavorSupported(INSPECTOR_NODE_DATA_FLAVOR)) {
            return null;
        }
        if (this.component == null || this.component.get() == null) {
            return null;
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                final AcceptSuggestion acceptSuggestion = InspectorFolderNode.this.createSuggestion(transferable);
                if (InspectorFolderNode.this.component.get() != null && AcceptSupport.isAcceptable((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)transferable, (AcceptSuggestion)acceptSuggestion)) {
                    pasteTypeArray[0] = new PasteType(){

                        public Transferable paste() throws IOException {
                            ((DesignComponent)InspectorFolderNode.this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                                public void run() {
                                    if (InspectorFolderNode.this.component.get() != null && AcceptSupport.isAcceptable((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)transferable, (AcceptSuggestion)acceptSuggestion)) {
                                        AcceptSupport.accept((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)transferable, null);
                                    }
                                }
                            });
                            return transferable;
                        }
                    };
                }
            }
        });
        return pasteTypeArray[0];
    }

    public Transferable drag() throws IOException {
        return this.transferable;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        return this.transferable;
    }

    public Transferable clipboardCut() throws IOException {
        return this.transferable;
    }

    public boolean canDestroy() {
        return true;
    }

    DesignComponent getComponent() {
        return (DesignComponent)this.component.get();
    }

    void terminate() {
        this.componentID = null;
        this.component = null;
        this.folder = null;
    }

    public Sheet createSheet() {
        DataEditorView dataEditorView;
        if (this.component.get() == null) {
            super.createSheet();
        }
        if ((dataEditorView = ActiveViewSupport.getDefault().getActiveView()) != null && dataEditorView.getKind() == DataEditorView.Kind.MODEL) {
            return PropertiesSupport.getSheet((DataEditorView)dataEditorView, (DesignComponent)((DesignComponent)this.component.get()));
        }
        return super.createSheet();
    }

    private class NodeTransferable
    implements Transferable {
        private WeakReference<DesignComponent> component;

        public NodeTransferable(DesignComponent designComponent) {
            assert (designComponent != null);
            this.component = new WeakReference<DesignComponent>(designComponent);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR, INSPECTOR_NODE_DATA_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return true;
            }
            return dataFlavor == INSPECTOR_NODE_DATA_FLAVOR;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.component.get();
        }
    }
}

