/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> result = Lookup.getDefault().lookupResult(FileSystem.class);
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookup;

    ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, boolean bl2) throws IOException {
        this(fileSystem, bl, fileSystemArray, LayerCacheManager.manager(bl2));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager) throws IOException {
        this(fileSystem, bl, fileSystemArray, layerCacheManager, layerCacheManager.loadCache());
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager, FileSystem fileSystem2) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(fileSystem, bl, fileSystemArray, fileSystem2 == null ? layerCacheManager.createEmptyFileSystem() : fileSystem2, bl));
        this.manager = layerCacheManager;
        this.writableLayer = fileSystem;
        this.otherLayers = fileSystemArray;
        this.cacheLayer = fileSystem2;
        this.addLookup = bl;
        this.setPropagateMasks(true);
        this.urls = null;
        if (bl) {
            result.addLookupListener((LookupListener)this);
            result.allItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem[] appendLayers(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, FileSystem fileSystem2, boolean bl2) {
        ArrayList<URL> arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(fileSystemArray.length + 2);
        arrayList2.add(fileSystem);
        if (bl) {
            arrayList = result.allInstances();
            arrayList2.addAll(arrayList);
        }
        arrayList2.addAll(Arrays.asList(fileSystemArray));
        arrayList2.add(fileSystem2);
        if (bl2) {
            arrayList = new ArrayList<URL>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
                    InputStream inputStream = uRL.openStream();
                    try {
                        Manifest manifest = new Manifest(inputStream);
                        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (string == null) continue;
                        URL uRL2 = classLoader.getResource(string);
                        if (uRL2 != null) {
                            arrayList.add(uRL2);
                            continue;
                        }
                        err.warning("No such layer: " + string);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                for (URL uRL : NbCollections.iterable(classLoader.getResources("META-INF/generated-layer.xml"))) {
                    arrayList.add(uRL);
                }
                XMLFileSystem xMLFileSystem = new XMLFileSystem();
                xMLFileSystem.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                arrayList2.add(xMLFileSystem);
                err.log(Level.FINE, "Loading classpath layers: {0}", arrayList);
            }
            catch (Exception exception) {
                err.log(Level.WARNING, "Setting layer URLs: " + arrayList, exception);
            }
        }
        return arrayList2.toArray(new FileSystem[arrayList2.size()]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem systemFileSystem = null;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem = null;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(List<URL> list) throws Exception {
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("setURLs: " + list);
        }
        if (this.urls != null && ((Object)list).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        if (this.urls != null || this.cacheLayer == null) {
            if (this.cacheLayer == null) {
                this.cacheLayer = this.manager.createEmptyFileSystem();
            }
            this.cacheLayer = this.manager.store(this.cacheLayer, list);
            err.log(Level.FINEST, "changing delegates");
            this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookup, this.otherLayers, this.cacheLayer, false));
            err.log(Level.FINEST, "delegates changed");
        }
        this.urls = list;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(collection);
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        arrayList.removeAll(collection);
        this.setURLs(arrayList);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookup, this.otherLayers, this.cacheLayer, false));
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }
}

