/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.FixedFileSystem;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemFileSystem
extends MultiFileSystem
implements FileSystem.Status,
FileChangeListener {
    static final long serialVersionUID = -7761052280240991668L;
    private static final String SYSTEM_NAME = "SystemFileSystem";
    private static final String ATTR_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String ATTR_ICON_16 = "SystemFileSystem.icon";
    private static final String ATTR_ICON_32 = "SystemFileSystem.icon32";
    private static final Logger LOG = Logger.getLogger(SystemFileSystem.class.getName());
    private ModuleLayeredFileSystem user;
    private ModuleLayeredFileSystem home;

    private SystemFileSystem(FileSystem[] fileSystemArray) throws PropertyVetoException {
        super(fileSystemArray);
        this.user = (ModuleLayeredFileSystem)fileSystemArray[0];
        this.home = fileSystemArray.length > 2 ? (ModuleLayeredFileSystem)fileSystemArray[1] : null;
        this.setSystemName(SYSTEM_NAME);
        this.setHidden(true);
        this.addFileChangeListener(this);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SystemFileSystem.class, (String)"CTL_SystemFileSystem");
    }

    public ModuleLayeredFileSystem getInstallationLayer() {
        return this.home;
    }

    public ModuleLayeredFileSystem getUserLayer() {
        return this.user;
    }

    public final void setLayers(FileSystem[] fileSystemArray) throws IllegalArgumentException {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (hashSet.contains(fileSystemArray[i])) {
                throw new IllegalArgumentException("Overlap in filesystem layers");
            }
            hashSet.add(fileSystemArray[i]);
        }
        this.setDelegates((FileSystem[])fileSystemArray.clone());
        this.firePropertyChange("layers", null, null);
    }

    public FileSystem[] getLayers() {
        return (FileSystem[])this.getDelegates().clone();
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i].isReadOnly()) continue;
            return fileSystemArray[i];
        }
        throw new IOException("No writable filesystems in our delegates");
    }

    protected Set<? extends FileSystem> createLocksOn(String string) throws IOException {
        LocalFileSystemEx.potentialLock(string);
        return super.createLocksOn(string);
    }

    @Deprecated
    public boolean isPersistent() {
        return true;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    static final String annotateName(FileObject fileObject) {
        String string = (String)fileObject.getAttribute(ATTR_BUNDLE);
        if (string != null) {
            try {
                string = Utilities.translate((String)string);
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                try {
                    return resourceBundle.getString(fileObject.getPath());
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            catch (MissingResourceException missingResourceException) {
                ModuleLayeredFileSystem.err.log(Level.WARNING, "Computing display name for " + fileObject, missingResourceException);
            }
        }
        return (String)fileObject.getAttribute("displayName");
    }

    public String annotateName(String string, Set set) {
        for (FileObject fileObject : set) {
            String string2 = SystemFileSystem.annotateName(fileObject);
            if (string2 != null) {
                return string2;
            }
            String string3 = FixedFileSystem.deflt.annotateName(fileObject.getPath());
            if (string3 == null) continue;
            return string3;
        }
        return string;
    }

    static Image annotateIcon(FileObject fileObject, int n) {
        Object object;
        String string = null;
        if (n == 1) {
            string = ATTR_ICON_16;
        } else if (n == 2) {
            string = ATTR_ICON_32;
        }
        if (string != null && (object = fileObject.getAttribute(string)) != null) {
            if (object instanceof URL) {
                return Toolkit.getDefaultToolkit().getImage((URL)object);
            }
            if (object instanceof Image) {
                return (Image)object;
            }
            ModuleLayeredFileSystem.err.warning("Attribute " + string + " on " + fileObject + " expected to be a URL or Image; was: " + object);
        }
        if ((object = (String)fileObject.getAttribute("iconBase")) != null) {
            if (n == 1) {
                return ImageUtilities.loadImage((String)object, (boolean)true);
            }
            if (n == 2) {
                return ImageUtilities.loadImage((String)SystemFileSystem.insertBeforeSuffix((String)object, "_32"), (boolean)true);
            }
        }
        return null;
    }

    static String insertBeforeSuffix(String string, String string2) {
        String string3 = string;
        String string4 = "";
        if (string.lastIndexOf(46) >= 0) {
            string3 = string.substring(0, string.lastIndexOf(46));
            string4 = string.substring(string.lastIndexOf(46), string.length());
        }
        return string3 + string2 + string4;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        for (FileObject fileObject : set) {
            Image image2 = SystemFileSystem.annotateIcon(fileObject, n);
            if (image2 != null) {
                return image2;
            }
            Image image3 = FixedFileSystem.deflt.annotateIcon(fileObject.getPath());
            if (image3 == null) continue;
            return image3;
        }
        return image;
    }

    static SystemFileSystem create(File file, File file2, File[] fileArray) throws PropertyVetoException, IOException {
        LocalFileSystemEx localFileSystemEx;
        Object object;
        Object object2;
        if (file != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            object2 = new LocalFileSystemEx(true);
            object2.setRootDirectory(file);
            object = object2;
        } else {
            object2 = System.getProperty("org.netbeans.core.systemfilesystem.custom");
            if (object2 != null) {
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    Object obj = clazz.newInstance();
                    object = (FileSystem)obj;
                }
                catch (Exception exception) {
                    ModuleLayeredFileSystem.err.log(Level.WARNING, "Custom system file system writable layer init failed ", exception);
                    object = FileUtil.createMemoryFileSystem();
                }
            } else {
                object = FileUtil.createMemoryFileSystem();
            }
        }
        if (file2 == null || !file2.isDirectory()) {
            localFileSystemEx = null;
        } else {
            localFileSystemEx = new LocalFileSystemEx();
            localFileSystemEx.setRootDirectory(file2);
            localFileSystemEx.setReadOnly(true);
        }
        object2 = new LocalFileSystem[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            object2[i] = new LocalFileSystemEx();
            object2[i].setRootDirectory(fileArray[i]);
            object2[i].setReadOnly(true);
        }
        FileSystem[] fileSystemArray = new FileSystem[localFileSystemEx == null ? 2 : 3];
        fileSystemArray[0] = new ModuleLayeredFileSystem((FileSystem)object, true, new FileSystem[0], false);
        if (localFileSystemEx != null) {
            fileSystemArray[1] = new ModuleLayeredFileSystem((FileSystem)localFileSystemEx, false, (FileSystem[])object2, true);
        }
        FixedFileSystem.deflt = new FixedFileSystem("org.netbeans.core.projects.FixedFileSystem", "Automatic Manifest Installation");
        fileSystemArray[localFileSystemEx == null ? 1 : 2] = FixedFileSystem.deflt;
        return new SystemFileSystem(fileSystemArray);
    }

    protected void notifyMigration(FileObject fileObject) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fileObject, false, true));
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        SystemFileSystem.log("fileFolderCreated", fileEvent);
    }

    public void fileDataCreated(FileEvent fileEvent) {
        SystemFileSystem.log("fileDataCreated", fileEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        SystemFileSystem.log("fileChanged", fileEvent);
    }

    public void fileDeleted(FileEvent fileEvent) {
        SystemFileSystem.log("fileDeleted", fileEvent);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        SystemFileSystem.log("fileDeleted", (FileEvent)fileRenameEvent);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        SystemFileSystem.log("fileAttributeChanged", (FileEvent)fileAttributeEvent);
    }

    private static void log(String string, FileEvent fileEvent) {
        if (LOG.isLoggable(Level.FINER)) {
            LogRecord logRecord = new LogRecord(Level.FINER, "LOG_FILE_EVENT");
            logRecord.setLoggerName(LOG.getName());
            logRecord.setParameters(new Object[]{string, fileEvent.getFile().getPath(), fileEvent.getFile(), fileEvent});
            logRecord.setResourceBundle(NbBundle.getBundle(SystemFileSystem.class));
            LOG.log(logRecord);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        new NotSerializableException("WARNING - SystemFileSystem is not designed to be serialized").printStackTrace();
        return new SingletonSerializer();
    }

    private static final class SingletonSerializer
    implements Serializable {
        private static final long serialVersionUID = 6436781994611L;

        SingletonSerializer() {
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return FileUtil.getConfigRoot().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                return null;
            }
        }
    }
}

