/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.HtmlDataNode;
import org.netbeans.modules.html.HtmlEditorSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;

public class HtmlDataObject
extends MultiDataObject
implements CookieSet.Factory {
    public static final String PROP_ENCODING = "Content-Encoding";
    public static final String DEFAULT_ENCODING = new InputStreamReader(System.in).getEncoding();
    static final long serialVersionUID = 8354927561693097159L;
    private static final String CHARSET_DECL = "CHARSET=";
    private static final String HEAD_END_TAG_NAME = "</HEAD>";
    private HtmlEditorSupport htmlEditorSupport;

    public HtmlDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(HtmlEditorSupport.class, (CookieSet.Factory)this);
        cookieSet.add(ViewSupport.class, (CookieSet.Factory)this);
        cookieSet.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                HtmlEditorSupport htmlEditorSupport = (HtmlEditorSupport)HtmlDataObject.this.getCookie(HtmlEditorSupport.class);
                try {
                    htmlEditorSupport.updateEncoding();
                    htmlEditorSupport.saveAs(fileObject, string);
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
            }
        }});
        FileEncodingQueryImplementation fileEncodingQueryImplementation = new FileEncodingQueryImplementation(){

            public Charset getEncoding(FileObject fileObject) {
                assert (fileObject != null);
                assert (fileObject.equals(HtmlDataObject.this.getPrimaryFile()));
                String string = HtmlDataObject.this.getFileEncoding();
                if (string == null) {
                    return null;
                }
                try {
                    return Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Boolean bl = (Boolean)fileObject.getAttribute("template");
                    if (bl == null || !bl.booleanValue()) {
                        Logger.getLogger("global").log(Level.INFO, null, illegalCharsetNameException);
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Logger.getLogger("global").log(Level.INFO, null, unsupportedCharsetException);
                }
                return null;
            }
        };
        cookieSet.assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{fileEncodingQueryImplementation});
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected Node createNodeDelegate() {
        HtmlDataNode htmlDataNode = new HtmlDataNode((DataObject)this, Children.LEAF);
        htmlDataNode.setIconBaseWithExtension("org/netbeans/modules/html/htmlObject.png");
        return htmlDataNode;
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(HtmlEditorSupport.class)) {
            return this.getHtmlEditorSupport();
        }
        if (clazz.isAssignableFrom(ViewSupport.class)) {
            return new ViewSupport(this.getPrimaryEntry());
        }
        return null;
    }

    private synchronized HtmlEditorSupport getHtmlEditorSupport() {
        if (this.htmlEditorSupport == null) {
            this.htmlEditorSupport = new HtmlEditorSupport(this);
        }
        return this.htmlEditorSupport;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileEncoding() {
        String string = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getPrimaryFile().getInputStream();
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            int n2 = n = n >= 0 ? n : 0;
            if (n > 1) {
                int n3 = (byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF);
                if (n3 == 65279) {
                    string = "UTF-16";
                } else if (n3 == 65534) {
                    string = "UTF-16LE";
                }
            }
            String[] stringArray = new String[]{string != null ? string : DEFAULT_ENCODING, "UTF-16LE", "UTF-16BE"};
            int n4 = 0;
            while ((string = HtmlDataObject.findEncoding(this.makeString(byArray, 0, n, stringArray[n4++]))) == null && n4 < stringArray.length) {
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.WARNING, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private String makeString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        return new String(byArray, 0, n2, string).toUpperCase();
    }

    static String findEncoding(String string) {
        int[] nArray = HtmlDataObject.findEncodingOffsets(string);
        if (nArray.length == 3) {
            String string2 = string.substring(nArray[0] + nArray[1], nArray[0] + nArray[2]);
            return string2;
        }
        return null;
    }

    private static int[] findEncodingOffsets(String string) {
        Token token;
        int[] nArray = new int[]{};
        int n = string.indexOf(HEAD_END_TAG_NAME);
        int n2 = n = n == -1 ? string.indexOf(HEAD_END_TAG_NAME.toLowerCase()) : n;
        if (n == -1) {
            return nArray;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)HTMLTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        while (tokenSequence.moveNext() && (token = tokenSequence.token()).offset(tokenHierarchy) < n) {
            if (token.id() != HTMLTokenId.VALUE) continue;
            String string2 = ((Object)token.text()).toString();
            int n3 = string2.indexOf(CHARSET_DECL);
            n3 = n3 == -1 ? string2.indexOf(CHARSET_DECL.toLowerCase()) : n3;
            int n4 = n3 + CHARSET_DECL.length();
            if (n3 == -1) continue;
            int n5 = string2.indexOf(34, n4);
            if (n5 == -1) {
                n5 = string2.indexOf(39, n4);
            }
            if (n5 == -1) {
                n5 = string2.indexOf(59, n4);
            }
            if (n5 == -1) {
                return nArray;
            }
            nArray = new int[]{token.offset(tokenHierarchy), n4, n5};
        }
        return nArray;
    }

    static final class ViewSupport
    implements ViewCookie {
        private MultiDataObject.Entry primary;

        public ViewSupport(MultiDataObject.Entry entry) {
            this.primary = entry;
        }

        public void view() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(this.primary.getFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
    }
}

