/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.netbeans.modules.html.palette.items.ACustomizer;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.NbBundle;

public class A
implements ActiveEditorDrop {
    public static final String[] protocols = new String[]{"file", "http", "https", "ftp", "mailto"};
    public static final int PROTOCOL_DEFAULT = 0;
    public static final String[] targets = new String[]{NbBundle.getMessage(A.class, (String)"LBL_SameFrame"), NbBundle.getMessage(A.class, (String)"LBL_NewWindow"), NbBundle.getMessage(A.class, (String)"LBL_ParentFrame"), NbBundle.getMessage(A.class, (String)"LBL_FullWindow")};
    public static final int TARGET_DEFAULT = 0;
    private int protocolIndex = 0;
    private String url = "";
    private String text = "";
    private int targetIndex = 0;
    private String target = "";

    public boolean handleTransfer(JTextComponent jTextComponent) {
        ACustomizer aCustomizer = new ACustomizer(this, jTextComponent);
        boolean bl = aCustomizer.showDialog();
        if (bl) {
            String string = this.createBody();
            try {
                HtmlPaletteUtilities.insert(string, jTextComponent);
            }
            catch (BadLocationException badLocationException) {
                bl = false;
            }
        }
        return bl;
    }

    private String createBody() {
        String string = " href=\"";
        if (this.getProtocolIndex() != 0) {
            try {
                switch (this.getProtocolIndex()) {
                    case 1: {
                        string = string + "http://";
                        break;
                    }
                    case 2: {
                        string = string + "https://";
                        break;
                    }
                    case 3: {
                        string = string + "ftp://";
                        break;
                    }
                    case 4: {
                        string = string + "mailto:";
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string2 = "\"";
        if (this.getUrl().length() > 0) {
            string2 = this.getUrl() + "\"";
        }
        string = string + string2;
        String string3 = "";
        if (this.targetIndex != -1 && this.targetIndex != 0) {
            try {
                switch (this.getTargetIndex()) {
                    case 1: {
                        this.setTarget("_blank");
                        break;
                    }
                    case 2: {
                        this.setTarget("_parent");
                        break;
                    }
                    case 3: {
                        this.setTarget("_top");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.getTarget().length() > 0) {
            string3 = " target=\"" + this.getTarget() + "\"";
        }
        String string4 = "<a" + string + string3 + ">" + this.getText() + "</a>";
        return string4;
    }

    public int getProtocolIndex() {
        return this.protocolIndex;
    }

    public void setProtocolIndex(int n) {
        this.protocolIndex = n;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int n) {
        this.targetIndex = n;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }
}

