/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;

public class StepIntoNextMethod
implements Executor,
PropertyChangeListener {
    private static final Logger smartLogger = Logger.getLogger("org.netbeans.modules.debugger.jpda.smartstepping");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private volatile StepRequest stepIntoRequest;
    private String position;
    private int depth;
    private JPDADebuggerImpl debugger;
    private ContextProvider contextProvider;
    private boolean smartSteppingStepOut;
    private Properties p;
    private StepActionProvider stepActionProvider;
    private SmartSteppingFilter smartSteppingFilter;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoNextMethod(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.contextProvider = contextProvider;
        this.getSmartSteppingFilterImpl().addPropertyChangeListener((PropertyChangeListener)this);
        SourcePath sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        sourcePath.addPropertyChangeListener(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey("SS_ACTION_STEPOUT");
        }
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    private final JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    public void runAction() {
        this.runAction(true);
    }

    public void runAction(boolean bl) {
        this.runAction(null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runAction(Object object, boolean bl) {
        Lock lock;
        block11: {
            block10: {
                smartLogger.finer("STEP INTO NEXT METHOD.");
                JPDAThread jPDAThread = this.getDebuggerImpl().getCurrentThread();
                if (jPDAThread == null) {
                    smartLogger.finer("Can not step into next method! No current thread!");
                    return;
                }
                lock = this.getDebuggerImpl().getSuspend() == 1 ? ((JPDAThreadImpl)jPDAThread).accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
                lock.lock();
                try {
                    if (!jPDAThread.isSuspended()) {
                        if (smartLogger.isLoggable(Level.FINER)) {
                            smartLogger.finer("Can not step into next method! Thread " + jPDAThread + " not suspended!");
                        }
                        Object var9_5 = null;
                        lock.unlock();
                        return;
                    }
                    JPDAThreadImpl[] jPDAThreadImplArray = new JPDAThreadImpl[]{null};
                    int n = ActionsManager.ACTION_STEP_OUT.equals(object) ? 3 : 1;
                    StepRequest stepRequest = this.setStepRequest(n, jPDAThreadImplArray);
                    this.position = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null);
                    if (n == 1) {
                        this.stepIntoRequest = stepRequest;
                    }
                    this.depth = jPDAThread.getStackDepth();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JDI Request (action step into next method): " + stepRequest);
                    }
                    if (stepRequest == null) {
                        break block10;
                    }
                    ((JPDAThreadImpl)jPDAThread).setInStep(true, stepRequest);
                    if (!bl) break block11;
                    if (jPDAThreadImplArray[0] == null) {
                        this.getDebuggerImpl().resume();
                        break block11;
                    } else {
                        this.getDebuggerImpl().resumeCurrentThread();
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            Object var9_6 = null;
            lock.unlock();
            return;
        }
        Object var9_7 = null;
        lock.unlock();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "exclusionPatterns") {
            if (propertyChangeEvent.getOldValue() != null) {
                smartLogger.finer("Exclusion patterns removed. Removing step requests.");
                JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
                if (jPDAThreadImpl != null) {
                    ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                    this.removeStepRequests(threadReference);
                }
            } else {
                if (smartLogger.isLoggable(Level.FINER)) {
                    if (this.stepIntoRequest == null) {
                        smartLogger.finer("Exclusion patterns has been added");
                    } else {
                        smartLogger.finer("Add exclusion patterns: " + propertyChangeEvent.getNewValue());
                    }
                }
                try {
                    this.addPatternsToRequest(((Set)propertyChangeEvent.getNewValue()).toArray(new String[((Set)propertyChangeEvent.getNewValue()).size()]), this.stepIntoRequest);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
            }
        } else if (propertyChangeEvent.getPropertyName() == "sourceRoots") {
            smartLogger.finer("Source roots changed");
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (jPDAThreadImpl != null) {
                ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                this.removeStepRequests(threadReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exec(Event event) {
        boolean bl;
        JPDAThreadImpl jPDAThreadImpl;
        block35: {
            boolean bl2;
            block34: {
                boolean bl3;
                block33: {
                    boolean bl4;
                    block32: {
                        boolean bl5;
                        block30: {
                            ThreadReference threadReference;
                            StepRequest stepRequest;
                            try {
                                stepRequest = (StepRequest)EventWrapper.request(event);
                                threadReference = StepRequestWrapper.thread(stepRequest);
                                jPDAThreadImpl = this.getDebuggerImpl().getThread(threadReference);
                                jPDAThreadImpl.setInStep(false, null);
                            }
                            catch (InternalExceptionWrapper internalExceptionWrapper) {
                                return false;
                            }
                            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                                return false;
                            }
                            jPDAThreadImpl.accessLock.readLock().lock();
                            try {
                                boolean bl6;
                                boolean bl7;
                                block31: {
                                    Method method;
                                    boolean bl8;
                                    try {
                                        EventRequestWrapper.disable(stepRequest);
                                    }
                                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                                        boolean bl9 = false;
                                        Object var14_13 = null;
                                        jPDAThreadImpl.accessLock.readLock().unlock();
                                        return bl9;
                                    }
                                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                                        boolean bl10 = false;
                                        Object var14_14 = null;
                                        jPDAThreadImpl.accessLock.readLock().unlock();
                                        return bl10;
                                    }
                                    boolean bl11 = this.p.getBoolean("UseStepFilters", true);
                                    boolean bl12 = bl7 = bl11 && this.p.getBoolean("StepThroughFilters", false) && !this.smartSteppingStepOut;
                                    if (!bl7 && this.isFilteredClassOnStack(threadReference, this.depth)) {
                                        smartLogger.finer(" stoped with a filtered class on stack and step through is false.");
                                        StepRequest stepRequest2 = this.setStepRequest(3);
                                        boolean bl13 = stepRequest2 != null;
                                        Object var14_15 = null;
                                        jPDAThreadImpl.accessLock.readLock().unlock();
                                        return bl13;
                                    }
                                    try {
                                        boolean bl14 = bl11 && this.p.getBoolean("FilterSyntheticMethods", true);
                                        bl6 = bl11 && this.p.getBoolean("FilterStaticInitializers", false);
                                        bl8 = bl11 && this.p.getBoolean("FilterConstructors", false);
                                        method = LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
                                        if (bl14 && TypeComponentWrapper.isSynthetic(method)) {
                                            smartLogger.finer(" stoped in a synthetic method.");
                                            StepRequest stepRequest3 = this.setStepRequest(1);
                                            bl5 = stepRequest3 != null;
                                            break block30;
                                        }
                                    }
                                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                        break block31;
                                    }
                                    catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                                        break block31;
                                    }
                                    catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                                        break block31;
                                    }
                                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                                        break block31;
                                    }
                                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                                        break block31;
                                    }
                                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                                        bl6 = true;
                                        Object var14_18 = null;
                                        jPDAThreadImpl.accessLock.readLock().unlock();
                                        return bl6;
                                    }
                                    {
                                        if ((!bl6 || !MethodWrapper.isStaticInitializer(method)) && (!bl8 || !MethodWrapper.isConstructor(method))) break block31;
                                        smartLogger.finer(" stoped in a static initializer or constructor.");
                                        StepRequest stepRequest4 = this.setStepRequest(3);
                                        bl4 = stepRequest4 != null;
                                    }
                                    break block32;
                                }
                                JPDAThreadImpl jPDAThreadImpl2 = this.getDebuggerImpl().getThread(threadReference);
                                bl6 = this.getCompoundSmartSteppingListener().stopHere(this.contextProvider, jPDAThreadImpl2, this.getSmartSteppingFilterImpl());
                                if (bl6) {
                                    String string = jPDAThreadImpl2.getClassName() + '.' + jPDAThreadImpl2.getMethodName() + ':' + jPDAThreadImpl2.getLineNumber(null);
                                    int n = jPDAThreadImpl2.getStackDepth();
                                    if (smartLogger.isLoggable(Level.FINER)) {
                                        smartLogger.finer(" stop position = " + string + ", original position = " + this.position + ", stop depth = " + n + ", original depth = " + this.depth + " => will stop: " + (!this.position.equals(string) || this.depth != n));
                                    }
                                    if (this.position.equals(string) && this.depth == n) {
                                        bl6 = false;
                                        StepRequest stepRequest5 = this.setStepRequest(1);
                                        bl3 = stepRequest5 != null;
                                        break block33;
                                    }
                                }
                                if (bl6) {
                                    this.removeStepRequests(threadReference);
                                } else {
                                    smartLogger.finer(" => do next step.");
                                    StepRequest stepRequest6 = !bl7 ? this.setStepRequest(3) : this.setStepRequest(1);
                                    if (stepRequest6 == null) {
                                        bl2 = false;
                                        break block34;
                                    }
                                }
                                if (bl6) {
                                    if (smartLogger.isLoggable(Level.FINER)) {
                                        smartLogger.finer("FINISH IN CLASS " + jPDAThreadImpl2.getClassName() + " ********");
                                    }
                                    try {
                                        StepActionProvider.setLastOperation(threadReference, this.debugger, null);
                                    }
                                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                                        boolean bl15 = true;
                                        Object var14_21 = null;
                                        jPDAThreadImpl.accessLock.readLock().unlock();
                                        return bl15;
                                    }
                                }
                                bl = !bl6;
                                break block35;
                            }
                            catch (Throwable throwable) {
                                Object var14_23 = null;
                                jPDAThreadImpl.accessLock.readLock().unlock();
                                throw throwable;
                            }
                        }
                        Object var14_16 = null;
                        jPDAThreadImpl.accessLock.readLock().unlock();
                        return bl5;
                    }
                    Object var14_17 = null;
                    jPDAThreadImpl.accessLock.readLock().unlock();
                    return bl4;
                }
                Object var14_19 = null;
                jPDAThreadImpl.accessLock.readLock().unlock();
                return bl3;
            }
            Object var14_20 = null;
            jPDAThreadImpl.accessLock.readLock().unlock();
            return bl2;
        }
        Object var14_22 = null;
        jPDAThreadImpl.accessLock.readLock().unlock();
        return bl;
    }

    public void removed(EventRequest eventRequest) {
        StepRequest stepRequest = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl jPDAThreadImpl = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(stepRequest));
            jPDAThreadImpl.setInStep(false, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List list = this.contextProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)list.get(i);
            }
        }
        return this.stepActionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStepRequests(ThreadReference threadReference) {
        StepIntoNextMethod stepIntoNextMethod = this;
        synchronized (stepIntoNextMethod) {
            this.stepIntoRequest = null;
        }
        JPDADebuggerActionProvider.removeStepRequests(this.getDebuggerImpl(), threadReference);
        smartLogger.finer("removing all patterns, all step requests.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepRequest setStepRequest(int n) {
        StepRequest stepRequest = null;
        if (n == 1) {
            StepIntoNextMethod stepIntoNextMethod = this;
            synchronized (stepIntoNextMethod) {
                if (this.stepIntoRequest != null) {
                    try {
                        EventRequestWrapper.enable(this.stepIntoRequest);
                        stepRequest = this.stepIntoRequest;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                            return null;
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return null;
                        }
                        this.stepIntoRequest = null;
                        return null;
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                }
            }
        }
        if (stepRequest != null) {
            return stepRequest;
        }
        return this.setStepRequest(n, null);
    }

    private StepRequest setStepRequest(int n, JPDAThreadImpl[] jPDAThreadImplArray) {
        int n2;
        StepRequest stepRequest;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        this.removeStepRequests(threadReference);
        VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        try {
            stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), threadReference, -2, n);
            this.getDebuggerImpl().getOperator().register(stepRequest, this);
            n2 = this.getDebuggerImpl().getSuspend();
            EventRequestWrapper.setSuspendPolicy(stepRequest, n2);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (smartLogger.isLoggable(Level.FINER)) {
            smartLogger.finer("Set step request(" + n + ") and patterns: ");
        }
        try {
            this.addPatternsToRequest(this.getSmartSteppingFilterImpl().getExclusionPatterns(), stepRequest);
            EventRequestWrapper.enable(stepRequest);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            try {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return null;
            }
            stepRequest = null;
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (jPDAThreadImplArray != null) {
            jPDAThreadImplArray[0] = n2 == 1 ? jPDAThreadImpl : null;
        }
        return stepRequest;
    }

    private SmartSteppingFilter getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.contextProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] stringArray, StepRequest stepRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (stepRequest == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            StepRequestWrapper.addClassExclusionFilter(stepRequest, stringArray[i]);
            smartLogger.finer("   add pattern: " + stringArray[i]);
        }
    }

    private boolean isFilteredClassOnStack(ThreadReference threadReference, int n) {
        String[] stringArray = this.getSmartSteppingFilterImpl().getExclusionPatterns();
        if (stringArray.length == 0) {
            return false;
        }
        try {
            int n2 = ThreadReferenceWrapper.frameCount(threadReference);
            if (n2 <= n) {
                return false;
            }
            List<StackFrame> list = ThreadReferenceWrapper.frames(threadReference, 0, n2 - n);
            for (StackFrame stackFrame : list) {
                String string = ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(stackFrame)));
                for (String string2 : stringArray) {
                    if (!string.contentEquals(string2)) continue;
                    smartLogger.finer(" class '" + string + "' on stack.");
                    return true;
                }
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            // empty catch block
        }
        return false;
    }
}

