/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;

public class BreakpointsReader
implements Properties.Reader,
PropertyChangeListener {
    private Map<JPDABreakpoint, String> cachedClassNames = new WeakHashMap<JPDABreakpoint, String>();
    private Map<JPDABreakpoint, String> cachedSourceRoots = new WeakHashMap<JPDABreakpoint, String>();

    public String[] getSupportedClassNames() {
        return new String[]{JPDABreakpoint.class.getName()};
    }

    synchronized String findCachedClassName(JPDABreakpoint jPDABreakpoint) {
        return this.cachedClassNames.get(jPDABreakpoint);
    }

    synchronized String findCachedSourceRoot(JPDABreakpoint jPDABreakpoint) {
        return this.cachedSourceRoots.get(jPDABreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedClassName(JPDABreakpoint jPDABreakpoint, String string) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            if (jPDABreakpoint instanceof LineBreakpoint && !this.cachedClassNames.containsKey(jPDABreakpoint)) {
                jPDABreakpoint.addPropertyChangeListener("url", (PropertyChangeListener)this);
            }
            this.cachedClassNames.put(jPDABreakpoint, string);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedSourceRoot(JPDABreakpoint jPDABreakpoint, String string) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            this.cachedSourceRoots.put(jPDABreakpoint, string);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String string, Properties properties) {
        Object object;
        LineBreakpoint lineBreakpoint;
        LineBreakpoint lineBreakpoint2 = null;
        if (string.equals(LineBreakpoint.class.getName()) || string.equals(LineBreakpoint.class.getName() + "$LineBreakpointImpl")) {
            lineBreakpoint = LineBreakpoint.create((String)properties.getString("url", null), (int)properties.getInt("lineNumber", 1));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            lineBreakpoint.setPreferredClassName(properties.getString("classNamePreferred", null));
            object = this;
            synchronized (object) {
                this.cachedClassNames.put((JPDABreakpoint)lineBreakpoint, properties.getString("className", null));
                lineBreakpoint.addPropertyChangeListener("url", (PropertyChangeListener)this);
                this.cachedSourceRoots.put((JPDABreakpoint)lineBreakpoint, properties.getString("sourceRoot", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(MethodBreakpoint.class.getName()) || string.equals(MethodBreakpoint.class.getName() + "$MethodBreakpointImpl")) {
            lineBreakpoint = MethodBreakpoint.create();
            lineBreakpoint.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            lineBreakpoint.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            lineBreakpoint.setMethodName(properties.getString("methodName", ""));
            lineBreakpoint.setMethodSignature(properties.getString("signature", null));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            lineBreakpoint.setBreakpointType(properties.getInt("breakpointtType", 1));
            object = this;
            synchronized (object) {
                this.cachedSourceRoots.put((JPDABreakpoint)lineBreakpoint, properties.getString("sourceRoot", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ClassLoadUnloadBreakpoint.class.getName())) {
            lineBreakpoint = ClassLoadUnloadBreakpoint.create((int)properties.getInt("breakpointType", 1));
            lineBreakpoint.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            lineBreakpoint.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            object = this;
            synchronized (object) {
                this.cachedSourceRoots.put((JPDABreakpoint)lineBreakpoint, properties.getString("sourceRoot", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ExceptionBreakpoint.class.getName())) {
            String[] stringArray;
            lineBreakpoint = ExceptionBreakpoint.create((String)properties.getString("exceptionClassName", null), (int)properties.getInt("catchType", 3));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            object = (String[])properties.getArray("classFilters", null);
            if (object != null) {
                lineBreakpoint.setClassFilters((String[])object);
            }
            if ((stringArray = (String[])properties.getArray("classExclusionFilters", null)) != null) {
                lineBreakpoint.setClassExclusionFilters(stringArray);
            }
            Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = this;
            synchronized (hIT_COUNT_FILTERING_STYLE) {
                this.cachedSourceRoots.put((JPDABreakpoint)lineBreakpoint, properties.getString("sourceRoot", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(FieldBreakpoint.class.getName()) || string.equals(FieldBreakpoint.class.getName() + "$FieldBreakpointImpl")) {
            lineBreakpoint = FieldBreakpoint.create((String)properties.getString("className", null), (String)properties.getString("fieldName", null), (int)properties.getInt("breakpointType", 1));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            object = this;
            synchronized (object) {
                this.cachedSourceRoots.put((JPDABreakpoint)lineBreakpoint, properties.getString("sourceRoot", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ThreadBreakpoint.class.getName())) {
            lineBreakpoint = ThreadBreakpoint.create();
            lineBreakpoint.setBreakpointType(properties.getInt("breakpointtType", 3));
            lineBreakpoint2 = lineBreakpoint;
        }
        assert (lineBreakpoint2 != null) : "Unknown breakpoint type: \"" + string + "\"";
        lineBreakpoint2.setPrintText(properties.getString("printText", ""));
        lineBreakpoint2.setGroupName(properties.getString("groupName", ""));
        lineBreakpoint2.setSuspend(properties.getInt("suspend", 2));
        int n = properties.getInt("hitCountFilter", 0);
        object = n > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        lineBreakpoint2.setHitCountFilter(n, object);
        if (properties.getBoolean("enabled", true)) {
            lineBreakpoint2.enable();
        } else {
            lineBreakpoint2.disable();
        }
        return lineBreakpoint2;
    }

    public void write(Object object, Properties properties) {
        JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)object;
        properties.setString("printText", jPDABreakpoint.getPrintText());
        properties.setString("groupName", jPDABreakpoint.getGroupName());
        properties.setInt("suspend", jPDABreakpoint.getSuspend());
        properties.setBoolean("enabled", jPDABreakpoint.isEnabled());
        properties.setInt("hitCountFilter", jPDABreakpoint.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = jPDABreakpoint.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", hIT_COUNT_FILTERING_STYLE != null ? hIT_COUNT_FILTERING_STYLE.ordinal() : 0);
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            properties.setString("url", lineBreakpoint.getURL());
            properties.setInt("lineNumber", lineBreakpoint.getLineNumber());
            properties.setString("condition", lineBreakpoint.getCondition());
            properties.setString("classNamePreferred", lineBreakpoint.getPreferredClassName());
            properties.setString("className", this.findCachedClassName((JPDABreakpoint)lineBreakpoint));
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)lineBreakpoint));
            return;
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            properties.setArray("classFilters", (Object[])methodBreakpoint.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])methodBreakpoint.getClassExclusionFilters());
            properties.setString("methodName", methodBreakpoint.getMethodName());
            properties.setString("signature", methodBreakpoint.getMethodSignature());
            properties.setString("condition", methodBreakpoint.getCondition());
            properties.setInt("breakpointtType", methodBreakpoint.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)methodBreakpoint));
            return;
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            properties.setArray("classFilters", (Object[])classLoadUnloadBreakpoint.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])classLoadUnloadBreakpoint.getClassExclusionFilters());
            properties.setInt("breakpointType", classLoadUnloadBreakpoint.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)classLoadUnloadBreakpoint));
            return;
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            properties.setString("exceptionClassName", exceptionBreakpoint.getExceptionClassName());
            properties.setInt("catchType", exceptionBreakpoint.getCatchType());
            properties.setArray("classFilters", (Object[])exceptionBreakpoint.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])exceptionBreakpoint.getClassExclusionFilters());
            properties.setString("condition", exceptionBreakpoint.getCondition());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)exceptionBreakpoint));
            return;
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            properties.setString("className", fieldBreakpoint.getClassName());
            properties.setString("fieldName", fieldBreakpoint.getFieldName());
            properties.setString("condition", fieldBreakpoint.getCondition());
            properties.setInt("breakpointType", fieldBreakpoint.getBreakpointType());
            properties.setString("sourceRoot", this.findCachedSourceRoot((JPDABreakpoint)fieldBreakpoint));
            return;
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            properties.setInt("breakpointtType", threadBreakpoint.getBreakpointType());
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("url".equals(propertyChangeEvent.getPropertyName())) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)propertyChangeEvent.getSource();
            this.storeCachedClassName((JPDABreakpoint)lineBreakpoint, null);
        }
    }
}

