/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.PrimitiveValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

class AbstractVariable
implements JDIVariable,
Customizer,
Cloneable {
    private Value value;
    private JPDADebuggerImpl debugger;
    private String id;
    private Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private int cloneNumber = 1;

    AbstractVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string) {
        this.debugger = jPDADebuggerImpl;
        this.value = value;
        this.id = string;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        Value value = this.getInnerValue();
        return AbstractVariable.getValue(value);
    }

    static String getValue(Value value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof VoidValue) {
            return "void";
        }
        if (value instanceof CharValue) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof PrimitiveValue) {
            return value.toString();
        }
        try {
            if (value instanceof StringReference) {
                return "\"" + StringReferenceWrapper.value((StringReference)value) + "\"";
            }
            if (value instanceof ClassObjectReference) {
                return "class " + ReferenceTypeWrapper.name(ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)value));
            }
            if (value instanceof ArrayReference) {
                return "#" + ObjectReferenceWrapper.uniqueID((ArrayReference)value) + "(length=" + ArrayReferenceWrapper.length((ArrayReference)value) + ")";
            }
            return "#" + ObjectReferenceWrapper.uniqueID((ObjectReference)value);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "";
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String string) throws InvalidExpressionException {
        void var3_9;
        String string2 = this.getValue();
        if (string.equals(string2)) {
            return;
        }
        Value value = this.getInnerValue();
        try {
            if (value instanceof CharValue && string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                CharValue charValue = VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(value), string.charAt(1));
            } else if ((value instanceof StringReference || value == null) && string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                StringReference stringReference = VirtualMachineWrapper.mirrorOf(this.debugger.getVirtualMachine(), string.substring(1, string.length() - 1));
            } else if (value instanceof ObjectReference && ObjectReferenceWrapper.referenceType((ObjectReference)value) instanceof ClassType && ClassTypeWrapper.isEnum((ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)value))) {
                ClassType classType = (ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)value);
                Field field = ReferenceTypeWrapper.fieldByName(classType, string);
                if (field == null) throw new InvalidExpressionException(string);
                Value value2 = ReferenceTypeWrapper.getValue(classType, field);
            } else if ("null".equals(string)) {
                Object var3_7 = null;
            } else {
                Type type;
                Value value3 = this.debugger.evaluateIn(string);
                if (value != null && value3 != null && !(type = ValueWrapper.type(value)).equals(ValueWrapper.type(value3))) {
                    value3 = this.convertValue(value3, type);
                }
                Value value4 = value3;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)unsupportedOperationExceptionWrapper);
        }
        this.setValue((Value)var3_9);
        this.setInnerValue((Value)var3_9);
    }

    private Value convertValue(Value value, Type type) {
        Object object;
        if (type instanceof PrimitiveType) {
            if (value instanceof ObjectReference) {
                boolean bl;
                object = this.getDebugger().getCurrentThread();
                if (object != null) {
                    try {
                        value = EvaluatorVisitor.unbox((ObjectReference)value, (PrimitiveType)type, ((JPDAThreadImpl)object).getThreadReference(), null);
                    }
                    catch (InvalidTypeException invalidTypeException) {
                    }
                    catch (ClassNotLoadedException classNotLoadedException) {
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    }
                    catch (InvocationException invocationException) {
                        // empty catch block
                    }
                }
                try {
                    bl = ValueWrapper.type(value).equals(type);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    bl = true;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    bl = true;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    bl = true;
                }
                if (bl) {
                    return value;
                }
            }
            if (value instanceof PrimitiveValue) {
                object = (PrimitiveValue)value;
                try {
                    VirtualMachine virtualMachine = MirrorWrapper.virtualMachine((Mirror)object);
                    if (type instanceof BooleanType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.booleanValue((PrimitiveValue)object));
                    }
                    if (type instanceof ByteType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.byteValue((PrimitiveValue)object));
                    }
                    if (type instanceof CharType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.charValue((PrimitiveValue)object));
                    }
                    if (type instanceof ShortType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.shortValue((PrimitiveValue)object));
                    }
                    if (type instanceof IntegerType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.intValue((PrimitiveValue)object));
                    }
                    if (type instanceof LongType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.longValue((PrimitiveValue)object));
                    }
                    if (type instanceof FloatType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.floatValue((PrimitiveValue)object));
                    }
                    if (type instanceof DoubleType) {
                        return VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.doubleValue((PrimitiveValue)object));
                    }
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
            }
        }
        if (type instanceof ClassType && value instanceof PrimitiveValue && (object = this.getDebugger().getCurrentThread()) != null) {
            PrimitiveValue primitiveValue = (PrimitiveValue)value;
            try {
                String string = TypeWrapper.name(type);
                VirtualMachine virtualMachine = MirrorWrapper.virtualMachine(primitiveValue);
                if (string.equals("java.lang.Byte") && !(primitiveValue instanceof ByteValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.byteValue(primitiveValue));
                }
                if (string.equals("java.lang.Character") && !(primitiveValue instanceof CharValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.charValue(primitiveValue));
                }
                if (string.equals("java.lang.Short") && !(primitiveValue instanceof ShortValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.shortValue(primitiveValue));
                }
                if (string.equals("java.lang.Integer") && !(primitiveValue instanceof IntegerValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.intValue(primitiveValue));
                }
                if (string.equals("java.lang.Long") && !(primitiveValue instanceof LongValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.longValue(primitiveValue));
                }
                if (string.equals("java.lang.Float") && !(primitiveValue instanceof FloatValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.floatValue(primitiveValue));
                }
                if (string.equals("java.lang.Double") && !(primitiveValue instanceof DoubleValue)) {
                    primitiveValue = VirtualMachineWrapper.mirrorOf(virtualMachine, PrimitiveValueWrapper.doubleValue(primitiveValue));
                }
                value = EvaluatorVisitor.box(primitiveValue, (ReferenceType)type, ((JPDAThreadImpl)object).getThreadReference(), null);
            }
            catch (InvalidTypeException invalidTypeException) {
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvocationException invocationException) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
        return value;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        throw new InternalError();
    }

    public void setObject(Object object) {
        try {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("" + object);
            }
            this.setValue((String)object);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invalidExpressionException.getLocalizedMessage());
            illegalArgumentException.initCause(invalidExpressionException);
            throw illegalArgumentException;
        }
    }

    public String getType() {
        if (this.getInnerValue() == null) {
            return "";
        }
        try {
            return TypeWrapper.name(ValueWrapper.type(this.getInnerValue()));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    public JPDAClassType getClassType() {
        Type type;
        Value value = this.getInnerValue();
        if (value == null) {
            return null;
        }
        try {
            type = ValueWrapper.type(value);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        if (type instanceof ReferenceType) {
            return new JPDAClassTypeImpl(this.debugger, (ReferenceType)type);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractVariable && this.id.equals(((AbstractVariable)object).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected Value getInnerValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInnerValue(Value value) {
        Object[] objectArray;
        this.value = value;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", null, value);
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            objectArray = this.listeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((PropertyChangeListener)objectArray[i]).propertyChange(propertyChangeEvent);
        }
        this.debugger.varChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    public Value getJDIValue() {
        return this.value;
    }

    protected final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected final String getID() {
        return this.id;
    }

    public Variable clone() {
        AbstractVariable abstractVariable = new AbstractVariable(this.debugger, this.value, this.id + "_clone" + this.cloneNumber++);
        return abstractVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    public String toString() {
        return "Variable ";
    }
}

