/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class ArrayFieldVariable
extends AbstractVariable
implements Field {
    private final ArrayReference array;
    private int index;
    private int maxIndexLog;
    private String declaredType;
    private static final String ZEROS = "            ";

    ArrayFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, PrimitiveValue primitiveValue, String string, ArrayReference arrayReference, int n, int n2, String string2) {
        super(jPDADebuggerImpl, primitiveValue, string2 + '.' + n + (primitiveValue instanceof ObjectReference ? "^" : ""));
        this.index = n;
        this.maxIndexLog = ArrayFieldVariable.log10(n2);
        this.declaredType = string;
        this.array = arrayReference;
    }

    public String getName() {
        return ArrayFieldVariable.getName(this.maxIndexLog, this.index);
    }

    static String getName(int n, int n2) {
        int n3 = n - ArrayFieldVariable.log10(n2);
        if (n3 > 0) {
            return "[" + ArrayFieldVariable.zeros(n3) + n2 + "]";
        }
        return "[" + n2 + "]";
    }

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getClassName() {
        return this.getType();
    }

    public JPDAClassType getDeclaringClass() {
        try {
            return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)ValueWrapper.type(this.array));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw internalExceptionWrapper.getCause();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw objectCollectedExceptionWrapper.getCause();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw vMDisconnectedExceptionWrapper.getCause();
        }
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            ArrayReferenceWrapper.setValue(this.array, this.index, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
    }

    public ArrayFieldVariable clone() {
        ArrayFieldVariable arrayFieldVariable = new ArrayFieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.declaredType, this.array, this.index, 0, this.getID().substring(0, this.getID().length() - (46 + this.index + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()));
        arrayFieldVariable.maxIndexLog = this.maxIndexLog;
        return arrayFieldVariable;
    }

    public String toString() {
        return "FieldVariable " + this.getName();
    }
}

