/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.MonitorInfo;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SingleThreadWatcher;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MonitorInfoWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MonitorContendedEnteredRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.MonitorInfoImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPDAThreadImpl
implements JPDAThread,
Customizer {
    private static final String PROP_LOCKER_THREADS = "lockerThreads";
    private static final String PROP_STEP_SUSPENDED_BY_BREAKPOINT = "stepSuspendedByBreakpoint";
    private static Logger logger = Logger.getLogger(JPDAThreadImpl.class.getName());
    private ThreadReference threadReference;
    private JPDADebuggerImpl debugger;
    private boolean suspended;
    private int suspendCount;
    private EditorContext.Operation currentOperation;
    private List<EditorContext.Operation> lastOperations;
    private boolean doKeepLastOperations;
    private ReturnVariableImpl returnVariable;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private CallStackFrame[] cachedFrames;
    private int cachedFramesFrom = -1;
    private int cachedFramesTo = -1;
    private final Object cachedFramesLock = new Object();
    private JPDABreakpoint currentBreakpoint;
    private String threadName;
    private final Object lockerThreadsLock = new Object();
    private ObjectReference lockerThreadsMonitor;
    private List<JPDAThread> lockerThreadsList;
    private List<ThreadReference> resumedBlockingThreads;
    private final Object stepBreakpointLock = new Object();
    private JPDABreakpoint stepSuspendedByBreakpoint;
    private VirtualMachine vm;
    public final ReadWriteLock accessLock = new ThreadReentrantReadWriteLock();
    private SingleThreadWatcher watcher = null;
    private boolean methodInvoking;
    private boolean methodInvokingDisabledUntilResumed;
    private boolean resumedToFinishMethodInvocation;
    private boolean unsuspendedStateWhenInvoking;
    private List<StepRequest> stepsDeletedDuringMethodInvoke;
    private boolean inStep = false;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.threadReference = threadReference;
        this.debugger = jPDADebuggerImpl;
        boolean bl = false;
        this.threadName = "";
        try {
            this.vm = MirrorWrapper.virtualMachine(threadReference);
            this.threadName = ThreadReferenceWrapper.name(threadReference);
            this.suspended = ThreadReferenceWrapper.isSuspended(threadReference);
            this.suspendCount = ThreadReferenceWrapper.suspendCount(threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            bl = true;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            bl = true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            bl = true;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            bl = true;
        }
        if (bl) {
            this.suspended = false;
            this.suspendCount = 0;
        }
    }

    public Lock getReadAccessLock() {
        return this.accessLock.readLock();
    }

    public String getName() {
        return this.threadName;
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference threadGroupReference = ThreadReferenceWrapper.threadGroup(this.threadReference);
            if (threadGroupReference == null) {
                return null;
            }
            return this.debugger.getThreadGroup(threadGroupReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
    }

    public int getLineNumber(String string) {
        try {
            if (ThreadReferenceWrapper.frameCount0(this.threadReference) < 1) {
                return -1;
            }
            return LocationWrapper.lineNumber(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), string);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        return -1;
    }

    public synchronized EditorContext.Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized List<EditorContext.Operation> getLastOperations() {
        return this.lastOperations;
    }

    public synchronized void addLastOperation(EditorContext.Operation operation) {
        if (this.lastOperations == null) {
            this.lastOperations = new ArrayList<EditorContext.Operation>();
        }
        this.lastOperations.add(operation);
    }

    public synchronized void clearLastOperations() {
        if (this.lastOperations != null) {
            for (EditorContext.Operation operation : this.lastOperations) {
                operation.setReturnValue(null);
            }
        }
        this.lastOperations = null;
    }

    public synchronized void holdLastOperations(boolean bl) {
        this.doKeepLastOperations = bl;
    }

    public synchronized JPDABreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentBreakpoint(JPDABreakpoint jPDABreakpoint) {
        JPDABreakpoint jPDABreakpoint2;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            jPDABreakpoint2 = this.currentBreakpoint;
            this.currentBreakpoint = jPDABreakpoint;
        }
        this.pch.firePropertyChange("currentBreakpoint", jPDABreakpoint2, jPDABreakpoint);
    }

    public int getState() {
        try {
            return ThreadReferenceWrapper.status(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        return -1;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isThreadSuspended() {
        try {
            return ThreadReferenceWrapper.isSuspended(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return false;
    }

    public String getClassName() {
        try {
            if (ThreadReferenceWrapper.frameCount(this.threadReference) < 1) {
                return "";
            }
            return ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0))));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return "";
    }

    public String getMethodName() {
        try {
            if (ThreadReferenceWrapper.frameCount(this.threadReference) < 1) {
                return "";
            }
            return TypeComponentWrapper.name(LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0))));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return "";
    }

    public String getSourceName(String string) throws AbsentInformationException {
        try {
            if (ThreadReferenceWrapper.frameCount(this.threadReference) < 1) {
                return "";
            }
            return LocationWrapper.sourceName(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), string);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        return "";
    }

    public String getSourcePath(String string) throws AbsentInformationException {
        try {
            if (ThreadReferenceWrapper.frameCount(this.threadReference) < 1) {
                return "";
            }
            return LocationWrapper.sourcePath(StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0)), string);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        this.accessLock.readLock().lock();
        try {
            CallStackFrame[] callStackFrameArray = this.getCallStack(0, this.getStackDepth());
            return callStackFrameArray;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public CallStackFrame[] getCallStack(int var1_1, int var2_2) throws AbsentInformationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CallStackFrame[] copyOfRange(CallStackFrame[] callStackFrameArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        CallStackFrame[] callStackFrameArray2 = new CallStackFrame[n3];
        System.arraycopy(callStackFrameArray, n, callStackFrameArray2, 0, Math.min(callStackFrameArray.length - n, n3));
        return callStackFrameArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCachedFrames() {
        Object object = this.cachedFramesLock;
        synchronized (object) {
            this.cachedFrames = null;
            this.cachedFramesFrom = -1;
            this.cachedFramesTo = -1;
        }
    }

    public int getStackDepth() {
        try {
            return ThreadReferenceWrapper.frameCount0(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(StackFrame stackFrame) throws IncompatibleThreadStateException {
        try {
            this.notifyToBeResumed();
            this.accessLock.writeLock().lock();
            try {
                ThreadReferenceWrapper.popFrames(this.threadReference, stackFrame);
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
            this.cleanCachedFrames();
            this.setReturnVariable(null);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            throw new IncompatibleThreadStateException("Thread exited.");
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new IncompatibleThreadStateException("Thread died.");
        }
        catch (NativeMethodExceptionWrapper nativeMethodExceptionWrapper) {
            this.cleanCachedFrames();
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)nativeMethodExceptionWrapper, NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            this.cleanCachedFrames();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        finally {
            this.notifySuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Boolean bl = null;
        this.accessLock.writeLock().lock();
        try {
            if (!this.isSuspended()) {
                logger.fine("Suspending thread " + this.threadName);
                ThreadReferenceWrapper.suspend(this.threadReference);
                bl = Boolean.TRUE;
                ++this.suspendCount;
                this.threadName = ThreadReferenceWrapper.name(this.threadReference);
            }
            this.suspended = true;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (bl != null) {
            this.pch.firePropertyChange("suspended", (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl;
        if (this == this.debugger.getCurrentThread() && !(bl = this.debugger.currentThreadToBeResumed())) {
            return;
        }
        Boolean bl2 = null;
        this.accessLock.writeLock().lock();
        try {
            this.waitUntilMethodInvokeDone();
            this.setReturnVariable(null);
            this.setCurrentOperation(null);
            this.currentBreakpoint = null;
            if (!this.doKeepLastOperations) {
                this.clearLastOperations();
            }
            try {
                if (this.isSuspended()) {
                    logger.fine("Resuming thread " + this.threadName);
                    for (int i = ThreadReferenceWrapper.suspendCount(this.threadReference); i > 0; --i) {
                        ThreadReferenceWrapper.resume(this.threadReference);
                    }
                    bl2 = Boolean.FALSE;
                }
                this.suspendCount = 0;
                this.suspended = false;
                this.methodInvokingDisabledUntilResumed = false;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                // empty catch block
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        JPDABreakpoint jPDABreakpoint = null;
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            if (this.stepSuspendedByBreakpoint != null) {
                jPDABreakpoint = this.stepSuspendedByBreakpoint;
            }
        }
        if (jPDABreakpoint != null) {
            this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, jPDABreakpoint, null);
        }
        this.cleanCachedFrames();
        if (bl2 != null) {
            this.pch.firePropertyChange("suspended", (Object)(bl2 == false ? 1 : 0), bl2);
        }
    }

    public void notifyToBeResumed() {
        List<PropertyChangeEvent> list = this.notifyToBeRunning(true, true);
        for (PropertyChangeEvent propertyChangeEvent : list) {
            this.pch.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyChangeEvent> notifyToBeRunning(boolean bl, boolean bl2) {
        Boolean bl3 = null;
        this.accessLock.writeLock().lock();
        try {
            if (bl2) {
                this.waitUntilMethodInvokeDone();
            }
            if (bl2 && --this.suspendCount > 0) {
                List<PropertyChangeEvent> list = Collections.emptyList();
                return list;
            }
            this.suspendCount = 0;
            if (bl) {
                this.setCurrentOperation(null);
                this.setReturnVariable(null);
                this.currentBreakpoint = null;
                if (!this.doKeepLastOperations) {
                    this.clearLastOperations();
                }
            }
            if (this.suspended) {
                this.suspended = false;
                bl3 = Boolean.FALSE;
                this.methodInvokingDisabledUntilResumed = false;
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        this.cleanCachedFrames();
        PropertyChangeEvent propertyChangeEvent = null;
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            if (this.stepSuspendedByBreakpoint != null) {
                propertyChangeEvent = new PropertyChangeEvent(this, PROP_STEP_SUSPENDED_BY_BREAKPOINT, this.stepSuspendedByBreakpoint, null);
                this.stepSuspendedByBreakpoint = null;
            }
        }
        if (bl3 != null) {
            object = new PropertyChangeEvent(this, "suspended", bl3 == false, bl3);
            if (propertyChangeEvent != null) {
                return Arrays.asList(propertyChangeEvent, object);
            }
            return Collections.singletonList(object);
        }
        if (propertyChangeEvent != null) {
            return Collections.singletonList(propertyChangeEvent);
        }
        return Collections.emptyList();
    }

    public void notifySuspended() {
        this.notifySuspended(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuspended(boolean bl) {
        Boolean bl2 = null;
        this.accessLock.writeLock().lock();
        try {
            try {
                this.suspendCount = ThreadReferenceWrapper.suspendCount(this.threadReference);
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                return;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                return;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                return;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                return;
            }
            if (!this.suspended && this.isThreadSuspended()) {
                this.suspended = true;
                bl2 = Boolean.TRUE;
                try {
                    this.threadName = ThreadReferenceWrapper.name(this.threadReference);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    // empty catch block
                }
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (bl2 != null && bl) {
            this.pch.firePropertyChange("suspended", (Object)(bl2 == false ? 1 : 0), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking() throws PropertyVetoException {
        List<Object> list;
        SingleThreadWatcher singleThreadWatcher = null;
        this.accessLock.writeLock().lock();
        try {
            logger.fine("Invoking a method in thread " + this.threadName);
            if (this.methodInvokingDisabledUntilResumed) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_DisabledUntilResumed"), null);
            }
            if (this.methodInvoking) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_AlreadyInvoking"), null);
            }
            if (!this.isThreadSuspended()) {
                throw new PropertyVetoException(NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NoCurrentContext"), null);
            }
            if (this.vm != null) {
                try {
                    EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(this.vm);
                    Object object = EventRequestManagerWrapper.stepRequests0(eventRequestManager);
                    ArrayList<StepRequest> arrayList = null;
                    Iterator<StepRequest> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        StepRequest stepRequest = iterator.next();
                        ThreadReference threadReference = StepRequestWrapper.thread(stepRequest);
                        if (!this.threadReference.equals(threadReference)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<StepRequest>();
                        }
                        arrayList.add(stepRequest);
                    }
                    if (arrayList != null) {
                        for (StepRequest stepRequest : arrayList) {
                            EventRequestWrapper.disable(stepRequest);
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("DISABLED Step Request: " + stepRequest);
                        }
                    }
                    this.stepsDeletedDuringMethodInvoke = arrayList;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
            }
            this.methodInvoking = true;
            this.unsuspendedStateWhenInvoking = !this.isSuspended();
            list = this.unsuspendedStateWhenInvoking ? Collections.emptyList() : this.notifyToBeRunning(false, false);
            singleThreadWatcher = this.watcher;
            this.watcher = new SingleThreadWatcher(this);
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (singleThreadWatcher != null) {
            singleThreadWatcher.destroy();
        }
        for (Object object : list) {
            this.pch.firePropertyChange((PropertyChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone() {
        boolean bl;
        SingleThreadWatcher singleThreadWatcher = null;
        this.accessLock.writeLock().lock();
        try {
            logger.fine("Method invoke done in thread " + this.threadName);
            if (this.resumedToFinishMethodInvocation) {
                try {
                    ThreadReferenceWrapper.suspend(this.threadReference);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    // empty catch block
                }
                this.resumedToFinishMethodInvocation = false;
            }
            if (this.stepsDeletedDuringMethodInvoke != null) {
                try {
                    for (StepRequest stepRequest : this.stepsDeletedDuringMethodInvoke) {
                        EventRequestWrapper.enable(stepRequest);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("ENABLED Step Request: " + stepRequest);
                    }
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
                this.stepsDeletedDuringMethodInvoke = null;
            }
            this.methodInvoking = false;
            bl = this.unsuspendedStateWhenInvoking;
            this.unsuspendedStateWhenInvoking = false;
            JPDAThreadImpl jPDAThreadImpl = this;
            synchronized (jPDAThreadImpl) {
                this.notifyAll();
            }
            singleThreadWatcher = this.watcher;
            this.watcher = null;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        if (singleThreadWatcher != null) {
            singleThreadWatcher.destroy();
        }
        if (!bl) {
            this.notifySuspended();
        }
    }

    public boolean isMethodInvoking() {
        return this.methodInvoking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilMethodInvokeDone() {
        this.accessLock.readLock().lock();
        try {
            while (this.methodInvoking) {
                JPDAThreadImpl jPDAThreadImpl = this;
                synchronized (jPDAThreadImpl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilMethodInvokeDone(long l) throws InterruptedException {
        if (!this.accessLock.readLock().tryLock(l, TimeUnit.MILLISECONDS)) {
            return;
        }
        try {
            while (this.methodInvoking) {
                JPDAThreadImpl jPDAThreadImpl = this;
                synchronized (jPDAThreadImpl) {
                    this.wait(l);
                }
            }
            return;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public void disableMethodInvokeUntilResumed() {
        this.accessLock.writeLock().lock();
        this.methodInvokingDisabledUntilResumed = true;
        this.accessLock.writeLock().unlock();
    }

    public void setInStep(boolean bl, EventRequest eventRequest) {
        SingleThreadWatcher singleThreadWatcher = null;
        this.inStep = bl;
        singleThreadWatcher = this.watcher;
        if (bl) {
            boolean bl2;
            try {
                bl2 = EventRequestWrapper.suspendPolicy(eventRequest) == 1;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                bl2 = false;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                bl2 = false;
            }
            if (bl2) {
                this.watcher = new SingleThreadWatcher(this);
            }
        } else {
            this.watcher = null;
        }
        if (singleThreadWatcher != null) {
            singleThreadWatcher.destroy();
        }
    }

    public boolean isInStep() {
        return this.inStep;
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            ThreadReferenceWrapper.interrupt(this.threadReference);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.debugger.getRequestProcessor().post(new Runnable(){

                public void run() {
                    JPDAThreadImpl.this.doMakeCurrent();
                }
            });
        } else {
            this.doMakeCurrent();
        }
    }

    private void doMakeCurrent() {
        this.debugger.setCurrentThread(this);
        Session session = this.debugger.getSession();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        if (session != debuggerManager.getCurrentSession()) {
            debuggerManager.setCurrentSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectVariable getContendedMonitor() {
        if (!VirtualMachineWrapper.canGetCurrentContendedMonitor0(this.vm)) {
            return null;
        }
        try {
            ObjectReference objectReference;
            this.accessLock.readLock().lock();
            try {
                if (!this.isSuspended()) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                if ("DestroyJavaVM".equals(this.threadName)) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                try {
                    objectReference = ThreadReferenceWrapper.currentContendedMonitor(this.threadReference);
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), incompatibleThreadStateException);
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
                catch (InternalException internalException) {
                    Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), internalException);
                    ObjectVariable objectVariable = null;
                    return objectVariable;
                }
            }
            finally {
                this.accessLock.readLock().unlock();
            }
            if (objectReference != null) return new ThisVariable(this.debugger, objectReference, "" + ObjectReferenceWrapper.uniqueID(objectReference));
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
    }

    public MonitorInfo getContendedMonitorAndOwner() {
        ObjectVariable objectVariable = this.getContendedMonitor();
        if (objectVariable == null) {
            return null;
        }
        MonitorInfo monitorInfo = null;
        JPDAThread jPDAThread = null;
        List<JPDAThread> list = this.debugger.getThreadsCollector().getAllThreads();
        for (JPDAThread jPDAThread2 : list) {
            ObjectVariable[] objectVariableArray;
            if (this == jPDAThread2) continue;
            block1: for (ObjectVariable objectVariable2 : objectVariableArray = jPDAThread2.getOwnedMonitors()) {
                if (!objectVariable.equals(objectVariable2)) continue;
                jPDAThread = jPDAThread2;
                List list2 = jPDAThread2.getOwnedMonitorsAndFrames();
                for (MonitorInfo monitorInfo2 : list2) {
                    if (!objectVariable.equals(monitorInfo2.getMonitor())) continue;
                    monitorInfo = monitorInfo2;
                    break block1;
                }
                break;
            }
            if (jPDAThread == null) continue;
            break;
        }
        if (monitorInfo != null) {
            return monitorInfo;
        }
        return new MonitorInfoImpl(jPDAThread, null, objectVariable);
    }

    /*
     * Exception decompiling
     */
    public ObjectVariable[] getOwnedMonitors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public synchronized ReturnVariableImpl getReturnVariable() {
        return this.returnVariable;
    }

    public synchronized void setReturnVariable(ReturnVariableImpl returnVariableImpl) {
        this.returnVariable = returnVariableImpl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSuspended(boolean bl) {
        this.pch.firePropertyChange("suspended", (Object)(!bl ? 1 : 0), (Object)bl);
    }

    @Override
    public void setObject(Object object) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing Customizer interface just because of add/remove PropertyChangeListener.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorInfo> getOwnedMonitorsAndFrames() {
        if (JPDAUtils.IS_JDK_16 && VirtualMachineWrapper.canGetMonitorFrameInfo0(this.vm)) {
            this.accessLock.readLock().lock();
            try {
                if (!this.isSuspended() || this.getState() == 0) {
                    List<MonitorInfo> list = Collections.emptyList();
                    return list;
                }
                List<Object> list = ThreadReferenceWrapper.ownedMonitorsAndFrames0(this.threadReference);
                if (list != null && list.size() > 0) {
                    ArrayList<MonitorInfo> arrayList = new ArrayList<MonitorInfo>(list.size());
                    for (Object object : list) {
                        arrayList.add(this.createMonitorInfo(object));
                    }
                    List list2 = Collections.unmodifiableList(arrayList);
                    return list2;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.INFO, this.getThreadStateLog(), incompatibleThreadStateException);
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            }
            finally {
                this.accessLock.readLock().unlock();
            }
        }
        return Collections.emptyList();
    }

    private MonitorInfo createMonitorInfo(Object object) {
        try {
            CallStackFrame[] callStackFrameArray;
            int n = MonitorInfoWrapper.stackDepth(object);
            CallStackFrame callStackFrame = null;
            if (n >= 0) {
                try {
                    callStackFrameArray = this.getCallStack(n, n + 1);
                    if (callStackFrameArray.length > 0) {
                        callStackFrame = callStackFrameArray[0];
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    Exceptions.printStackTrace((Throwable)absentInformationException);
                }
            }
            callStackFrameArray = MonitorInfoWrapper.monitor(object);
            ThisVariable thisVariable = new ThisVariable(this.debugger, (Value)callStackFrameArray, "" + ObjectReferenceWrapper.uniqueID((ObjectReference)callStackFrameArray));
            return new MonitorInfoImpl(this, callStackFrame, thisVariable);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public boolean checkForBlockingThreads() {
        try {
            block28: {
                if (!VirtualMachineWrapper.canGetCurrentContendedMonitor0(this.vm) || !VirtualMachineWrapper.canGetMonitorInfo0(this.vm)) {
                    return false;
                }
                var1_1 = null;
                JPDAThreadImpl.logger.fine("checkForBlockingThreads(" + this.threadName + "): suspend all...");
                this.debugger.accessLock.writeLock().lock();
                try {
                    VirtualMachineWrapper.suspend(this.vm);
                    var4_6 = ThreadReferenceWrapper.currentContendedMonitor(this.threadReference);
                    if (var4_6 == null) ** GOTO lbl29
                    var5_8 = this.lockerThreadsLock;
                    synchronized (var5_8) {
                        if (!var4_6.equals(this.lockerThreadsMonitor)) ** break block27
                        var6_10 = true;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 10] lbl17 : MonitorExitStatement: MONITOREXIT : var5_8
                        JPDAThreadImpl.logger.fine("checkForBlockingThreads(" + this.threadName + "): resume all.");
                    }
                    VirtualMachineWrapper.resume(this.vm);
                    return var6_10;
                    {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var5_8
                        {
                            catch (Throwable var7_11) {
                                throw var7_11;
                            }
                        }
                        var1_1 = JPDAThreadImpl.findLockPath(this.vm, this.threadReference, var4_6);
lbl29:
                        // 2 sources

                        var5_8 = this.lockerThreadsLock;
                        synchronized (var5_8) {
                            var2_12 = this.lockerThreadsList;
                            if (var1_1 != null) {
                                this.lockerThreadsMonitor = var4_6;
                                if (!this.submitMonitorEnteredFor(var4_6)) {
                                    this.submitCheckForMonitorEntered(var4_6);
                                }
                                this.lockerThreadsList = new ThreadListDelegate(this.debugger, new ArrayList<ThreadReference>(var1_1.keySet()));
                            } else {
                                this.lockerThreadsMonitor = null;
                                this.lockerThreadsList = null;
                            }
                            var3_13 = this.lockerThreadsList;
                        }
                        JPDAThreadImpl.logger.fine("checkForBlockingThreads(" + this.threadName + "): resume all.");
                    }
                    VirtualMachineWrapper.resume(this.vm);
                    break block28;
                    {
                        catch (IncompatibleThreadStateException var4_7) {
                            try {
                                var5_9 = false;
                                JPDAThreadImpl.logger.fine("checkForBlockingThreads(" + this.threadName + "): resume all.");
                            }
                            catch (Throwable var9_15) {
                                JPDAThreadImpl.logger.fine("checkForBlockingThreads(" + this.threadName + "): resume all.");
                                VirtualMachineWrapper.resume(this.vm);
                                throw var9_15;
                            }
                            VirtualMachineWrapper.resume(this.vm);
                            this.debugger.accessLock.writeLock().unlock();
                            return var5_9;
                        }
                    }
                }
                finally {
                    this.debugger.accessLock.writeLock().unlock();
                }
            }
            if (var2_12 != var3_13) {
                this.pch.firePropertyChange("lockerThreads", var2_12, var3_13);
            }
            return var1_1 != null;
        }
        catch (VMDisconnectedExceptionWrapper var1_2) {
        }
        catch (InternalExceptionWrapper var1_3) {
        }
        catch (ObjectCollectedExceptionWrapper var1_4) {
        }
        catch (IllegalThreadStateExceptionWrapper var1_5) {
            // empty catch block
        }
        return false;
    }

    private static Map<ThreadReference, ObjectReference> findLockPath(VirtualMachine virtualMachine, ThreadReference threadReference, ObjectReference objectReference) throws IncompatibleThreadStateException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        LinkedHashMap<ThreadReference, ObjectReference> linkedHashMap = new LinkedHashMap<ThreadReference, ObjectReference>();
        HashMap<ObjectReference, ThreadReference> hashMap = new HashMap<ObjectReference, ThreadReference>();
        for (ThreadReference threadReference2 : VirtualMachineWrapper.allThreads(virtualMachine)) {
            List<ObjectReference> list = ThreadReferenceWrapper.ownedMonitors(threadReference2);
            if (list == null) continue;
            for (ObjectReference objectReference2 : list) {
                hashMap.put(objectReference2, threadReference2);
            }
        }
        while (threadReference != null && objectReference != null) {
            threadReference = (ThreadReference)hashMap.get(objectReference);
            if (threadReference == null) continue;
            if (ThreadReferenceWrapper.suspendCount(threadReference) > 1) {
                linkedHashMap.put(threadReference, objectReference);
            }
            objectReference = ThreadReferenceWrapper.currentContendedMonitor(threadReference);
        }
        if (linkedHashMap.size() > 0) {
            return linkedHashMap;
        }
        return null;
    }

    public synchronized List<JPDAThread> getLockerThreads() {
        return this.lockerThreadsList;
    }

    public JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeBlockingThreads() {
        ArrayList<JPDAThread> arrayList;
        ArrayList<ThreadReference> arrayList2 = this.lockerThreadsLock;
        synchronized (arrayList2) {
            if (this.lockerThreadsList == null) {
                return false;
            }
            arrayList = new ArrayList<JPDAThread>(this.lockerThreadsList);
        }
        arrayList2 = new ArrayList<ThreadReference>(arrayList.size());
        for (JPDAThread jPDAThread : arrayList) {
            if (!jPDAThread.isSuspended()) continue;
            jPDAThread.resume();
            arrayList2.add(((JPDAThreadImpl)jPDAThread).getThreadReference());
        }
        Object object = this.lockerThreadsLock;
        synchronized (object) {
            this.resumedBlockingThreads = arrayList2;
        }
        return true;
    }

    private void submitMonitorEnteredRequest(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        EventRequestWrapper.setSuspendPolicy(eventRequest, 2);
        EventRequestWrapper.putProperty(eventRequest, "silent", Boolean.TRUE);
        this.debugger.getOperator().register(eventRequest, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean exec(Event event) {
                List list;
                List list2;
                try {
                    EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(JPDAThreadImpl.this.vm), EventWrapper.request(event));
                    JPDAThreadImpl.this.debugger.getOperator().unregister(EventWrapper.request(event));
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return true;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return true;
                }
                Iterator iterator = JPDAThreadImpl.this.lockerThreadsLock;
                synchronized (iterator) {
                    list2 = JPDAThreadImpl.this.lockerThreadsList;
                    JPDAThreadImpl.this.lockerThreadsMonitor = null;
                    JPDAThreadImpl.this.lockerThreadsList = null;
                    list = JPDAThreadImpl.this.resumedBlockingThreads;
                }
                JPDAThreadImpl.this.pch.firePropertyChange(JPDAThreadImpl.PROP_LOCKER_THREADS, list2, null);
                if (list != null) {
                    for (ThreadReference threadReference : list) {
                        JPDAThreadImpl jPDAThreadImpl;
                        try {
                            ThreadReferenceWrapper.suspend(threadReference);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if ((jPDAThreadImpl = JPDAThreadImpl.this.debugger.getExistingThread(threadReference)) == null) continue;
                        jPDAThreadImpl.notifySuspended();
                    }
                }
                if (JPDAThreadImpl.this.isMethodInvoking()) {
                    JPDAThreadImpl.this.debugger.getRequestProcessor().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            JPDAThreadImpl.this.accessLock.writeLock().lock();
                            try {
                                logger.fine("Resuming thread " + JPDAThreadImpl.this.threadName + " to finish method invoke...");
                                JPDAThreadImpl.this.resumedToFinishMethodInvocation = true;
                                ThreadReferenceWrapper.resume(JPDAThreadImpl.this.threadReference);
                            }
                            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            }
                            catch (Exception exception) {
                                Exceptions.printStackTrace((Throwable)exception);
                            }
                            finally {
                                JPDAThreadImpl.this.accessLock.writeLock().unlock();
                            }
                        }
                    }, 200);
                }
                return true;
            }

            public void removed(EventRequest eventRequest) {
            }
        });
        try {
            EventRequestWrapper.enable(eventRequest);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private boolean submitMonitorEnteredFor(ObjectReference objectReference) {
        if (!JPDAUtils.IS_JDK_16 || !VirtualMachineWrapper.canRequestMonitorEvents0(this.vm)) {
            return false;
        }
        try {
            EventRequest eventRequest = (EventRequest)EventRequestManagerWrapper.createMonitorContendedEnteredRequest(VirtualMachineWrapper.eventRequestManager(this.vm));
            MonitorContendedEnteredRequestWrapper.addThreadFilter(eventRequest, this.threadReference);
            this.submitMonitorEnteredRequest(eventRequest);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCheckForMonitorEntered(ObjectReference objectReference) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, IllegalThreadStateExceptionWrapper {
        try {
            ThreadReferenceWrapper.suspend(this.threadReference);
            logger.fine("submitCheckForMonitorEntered(): suspending " + this.threadName);
            ObjectReference objectReference2 = ThreadReferenceWrapper.currentContendedMonitor(this.threadReference);
            if (objectReference2 == null) {
                return;
            }
            Location location = StackFrameWrapper.location(ThreadReferenceWrapper.frame(this.threadReference, 0));
            if ((location = MethodWrapper.locationOfCodeIndex(LocationWrapper.method(location), LocationWrapper.codeIndex(location) + 1L)) == null) {
                return;
            }
            BreakpointRequest breakpointRequest = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(this.threadReference)), location);
            BreakpointRequestWrapper.addThreadFilter(breakpointRequest, this.threadReference);
            this.submitMonitorEnteredRequest(breakpointRequest);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Exceptions.printStackTrace((Throwable)incompatibleThreadStateException);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)invalidStackFrameExceptionWrapper);
        }
        finally {
            logger.fine("submitCheckForMonitorEntered(): resuming " + this.threadName);
            ThreadReferenceWrapper.resume(this.threadReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepSuspendedBy(JPDABreakpoint jPDABreakpoint) {
        Object object = this.stepBreakpointLock;
        synchronized (object) {
            this.stepSuspendedByBreakpoint = jPDABreakpoint;
        }
        this.pch.firePropertyChange(PROP_STEP_SUSPENDED_BY_BREAKPOINT, null, jPDABreakpoint);
    }

    private String getThreadStateLog() {
        return JPDAThreadImpl.getThreadStateLog(this.threadReference) + ", internal suspend status = " + this.suspended;
    }

    public static String getThreadStateLog(ThreadReference threadReference) {
        String string;
        try {
            string = "Thread '" + ThreadReferenceWrapper.name(threadReference) + "': status = " + ThreadReferenceWrapper.status(threadReference) + ", is suspended = " + ThreadReferenceWrapper.isSuspended(threadReference) + ", suspend count = " + ThreadReferenceWrapper.suspendCount(threadReference) + ", is at breakpoint = " + ThreadReferenceWrapper.isAtBreakpoint(threadReference);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            string = internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            string = vMDisconnectedExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            string = objectCollectedExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            string = illegalThreadStateExceptionWrapper.getCause().getLocalizedMessage();
        }
        return string;
    }

    public String toString() {
        return "'" + this.getName() + "' (" + Integer.toHexString(System.identityHashCode(this)) + ") from DBG(" + Integer.toHexString(((Object)((Object)this.debugger)).hashCode()) + ")";
    }

    private class ThreadReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private final ReentrantReadWriteLock.ReadLock readerLock;
        private final ReentrantReadWriteLock.WriteLock writerLock;

        private ThreadReentrantReadWriteLock() {
            super(false);
            this.readerLock = new ThreadReadLock();
            this.writerLock = new ThreadWriteLock();
        }

        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readerLock;
        }

        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writerLock;
        }

        private class ThreadWriteLock
        extends ReentrantReadWriteLock.WriteLock {
            private ThreadWriteLock() {
                super(ThreadReentrantReadWriteLock.this);
            }

            public void lock() {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lock();
                super.lock();
            }

            public void lockInterruptibly() throws InterruptedException {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lockInterruptibly();
                try {
                    super.lockInterruptibly();
                }
                catch (InterruptedException interruptedException) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                    throw interruptedException;
                }
            }

            public boolean tryLock() {
                boolean bl = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock();
                if (bl && !(bl = super.tryLock())) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return bl;
            }

            public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
                boolean bl = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock(l, timeUnit);
                if (bl && !(bl = super.tryLock(l, timeUnit))) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return bl;
            }

            public void unlock() {
                super.unlock();
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
            }
        }

        private class ThreadReadLock
        extends ReentrantReadWriteLock.ReadLock {
            private ThreadReadLock() {
                super(ThreadReentrantReadWriteLock.this);
            }

            public void lock() {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lock();
                super.lock();
            }

            public void lockInterruptibly() throws InterruptedException {
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().lockInterruptibly();
                try {
                    super.lockInterruptibly();
                }
                catch (InterruptedException interruptedException) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                    throw interruptedException;
                }
            }

            public boolean tryLock() {
                boolean bl = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock();
                if (bl && !(bl = super.tryLock())) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return bl;
            }

            public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
                boolean bl = ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().tryLock(l, timeUnit);
                if (bl && !(bl = super.tryLock(l, timeUnit))) {
                    ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
                }
                return bl;
            }

            public void unlock() {
                super.unlock();
                ((JPDAThreadImpl)JPDAThreadImpl.this).debugger.accessLock.readLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadListDelegate
    extends AbstractList<JPDAThread> {
        private List<ThreadReference> threads;
        private JPDADebuggerImpl debugger;

        public ThreadListDelegate(JPDADebuggerImpl jPDADebuggerImpl, List<ThreadReference> list) {
            this.debugger = jPDADebuggerImpl;
            this.threads = list;
        }

        @Override
        public JPDAThread get(int n) {
            return this.debugger.getThread(this.threads.get(n));
        }

        @Override
        public int size() {
            return this.threads.size();
        }
    }
}

