/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.facesmodel;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.web.jsf.api.facesmodel.Application;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.DisplayName;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.Icon;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponentFactory;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigVisitor;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.api.facesmodel.LocaleConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.api.facesmodel.ResourceBundle;
import org.netbeans.modules.web.jsf.api.facesmodel.ViewHandler;
import org.netbeans.modules.web.jsf.impl.facesmodel.ApplicationImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.ConverterImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.DefaultLocaleImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.DescriptionImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.DisplayNameImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.FacesConfigImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.IconImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigModelImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigQNames;
import org.netbeans.modules.web.jsf.impl.facesmodel.LocaleConfigImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.ManagedBeanImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.NavigationCaseImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.NavigationRuleImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.ResourceBundleImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.SupportedLocaleImpl;
import org.netbeans.modules.web.jsf.impl.facesmodel.ViewHandlerImpl;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSFConfigComponentFactoryImpl
implements JSFConfigComponentFactory {
    private static final Logger LOGGER = Logger.getLogger(JSFConfigComponentFactoryImpl.class.getName());
    private final JSFConfigModelImpl model;

    public JSFConfigComponentFactoryImpl(JSFConfigModelImpl jSFConfigModelImpl) {
        this.model = jSFConfigModelImpl;
    }

    public JSFConfigComponent create(Element element, JSFConfigComponent jSFConfigComponent) {
        LOGGER.fine("Element: " + element.getLocalName() + ", JSFConfigComponent: " + jSFConfigComponent);
        JSFConfigComponent jSFConfigComponent2 = null;
        if (jSFConfigComponent == null) {
            if (JSFConfigComponentFactoryImpl.areSameQName(JSFConfigQNames.FACES_CONFIG, element)) {
                jSFConfigComponent2 = new FacesConfigImpl(this.model, element);
            }
        } else {
            jSFConfigComponent2 = new CreateVisitor().create(element, jSFConfigComponent);
        }
        return jSFConfigComponent2;
    }

    public FacesConfig createFacesConfig() {
        return new FacesConfigImpl(this.model);
    }

    public ManagedBean createManagedBean() {
        return new ManagedBeanImpl(this.model);
    }

    public NavigationRule createNavigationRule() {
        return new NavigationRuleImpl(this.model);
    }

    public NavigationCase createNavigationCase() {
        return new NavigationCaseImpl(this.model);
    }

    public Converter createConverter() {
        return new ConverterImpl(this.model);
    }

    public Description createDescription() {
        return new DescriptionImpl(this.model);
    }

    public DisplayName createDisplayName() {
        return new DisplayNameImpl(this.model);
    }

    public Icon createIcon() {
        return new IconImpl(this.model);
    }

    public Application createApplication() {
        return new ApplicationImpl(this.model);
    }

    public ViewHandler createViewHandler() {
        return new ViewHandlerImpl(this.model);
    }

    public LocaleConfig createLocaleConfig() {
        return new LocaleConfigImpl(this.model);
    }

    public DefaultLocaleImpl createDefatultLocale() {
        return new DefaultLocaleImpl(this.model);
    }

    public SupportedLocaleImpl createSupportedLocale() {
        return new SupportedLocaleImpl(this.model);
    }

    public ResourceBundleImpl createResourceBundle() {
        return new ResourceBundleImpl(this.model);
    }

    public static boolean areSameQName(JSFConfigQNames jSFConfigQNames, Element element) {
        QName qName = AbstractDocumentComponent.getQName((Node)element);
        if ("http://java.sun.com/xml/ns/javaee".equals(element.getNamespaceURI())) {
            return jSFConfigQNames.getQName(JSFVersion.JSF_1_2).equals(qName);
        }
        return jSFConfigQNames.getLocalName().equals(qName.getLocalPart());
    }

    public static class CreateVisitor
    extends JSFConfigVisitor.Default {
        Element element;
        JSFConfigComponent created;

        JSFConfigComponent create(Element element, JSFConfigComponent jSFConfigComponent) {
            this.element = element;
            jSFConfigComponent.accept(this);
            return this.created;
        }

        private boolean isElementQName(JSFConfigQNames jSFConfigQNames) {
            return JSFConfigComponentFactoryImpl.areSameQName(jSFConfigQNames, this.element);
        }

        public void visit(FacesConfig facesConfig) {
            if (this.isElementQName(JSFConfigQNames.MANAGED_BEAN)) {
                this.created = new ManagedBeanImpl((JSFConfigModelImpl)facesConfig.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.NAVIGATION_RULE)) {
                this.created = new NavigationRuleImpl((JSFConfigModelImpl)facesConfig.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.CONVERTER)) {
                this.created = new ConverterImpl((JSFConfigModelImpl)facesConfig.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.APPLICATION)) {
                this.created = new ApplicationImpl((JSFConfigModelImpl)facesConfig.getModel(), this.element);
            }
        }

        public void visit(ManagedBean managedBean) {
            if (this.isElementQName(JSFConfigQNames.MANAGED_BEAN)) {
                this.created = new ManagedBeanImpl((JSFConfigModelImpl)managedBean.getModel(), this.element);
            } else {
                this.checkDescriptionGroup(managedBean);
            }
        }

        public void visit(NavigationRule navigationRule) {
            if (this.isElementQName(JSFConfigQNames.NAVIGATION_CASE)) {
                this.created = new NavigationCaseImpl((JSFConfigModelImpl)navigationRule.getModel(), this.element);
            } else {
                this.checkDescriptionGroup(navigationRule);
            }
        }

        public void visit(Converter converter) {
            if (this.isElementQName(JSFConfigQNames.NAVIGATION_CASE)) {
                this.created = new ConverterImpl((JSFConfigModelImpl)converter.getModel(), this.element);
            } else {
                this.checkDescriptionGroup(converter);
            }
        }

        public void visit(Application application) {
            if (this.isElementQName(JSFConfigQNames.VIEW_HANDLER)) {
                this.created = new ViewHandlerImpl((JSFConfigModelImpl)application.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.LOCALE_CONFIG)) {
                this.created = new LocaleConfigImpl((JSFConfigModelImpl)application.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.RESOURCE_BUNDLE)) {
                this.created = new ResourceBundleImpl((JSFConfigModelImpl)application.getModel(), this.element);
            }
        }

        public void visit(LocaleConfig localeConfig) {
            if (this.isElementQName(JSFConfigQNames.DEFAULT_LOCALE)) {
                this.created = new DefaultLocaleImpl((JSFConfigModelImpl)localeConfig.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.SUPPORTED_LOCALE)) {
                this.created = new SupportedLocaleImpl((JSFConfigModelImpl)localeConfig.getModel(), this.element);
            }
        }

        public void checkDescriptionGroup(JSFConfigComponent jSFConfigComponent) {
            if (this.isElementQName(JSFConfigQNames.DESCRIPTION)) {
                this.created = new DescriptionImpl((JSFConfigModelImpl)jSFConfigComponent.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.DISPLAY_NAME)) {
                this.created = new DisplayNameImpl((JSFConfigModelImpl)jSFConfigComponent.getModel(), this.element);
            } else if (this.isElementQName(JSFConfigQNames.ICON)) {
                this.created = new IconImpl((JSFConfigModelImpl)jSFConfigComponent.getModel(), this.element);
            }
        }

        public void visit(ResourceBundle resourceBundle) {
            this.checkDescriptionGroup(resourceBundle);
        }
    }
}

