/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.refactoring.DiffElement;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionBounds;

public class JSFRenamePlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private TreePathHandle treePathHandle = null;
    private static final Logger LOGGER = Logger.getLogger(JSFRenamePlugin.class.getName());
    private final RenameRefactoring refactoring;

    public JSFRenamePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
    }

    public Problem preCheck() {
        LOGGER.fine("preCheck() called.");
        return null;
    }

    public Problem checkParameters() {
        LOGGER.fine("checkParameters() called.");
        return null;
    }

    public Problem fastCheckParameters() {
        LOGGER.fine("fastCheckParameters() called.");
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (semafor.get() == null) {
            String string;
            Object object;
            Object object2;
            String string2;
            String string3;
            semafor.set(new Object());
            FileObject fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
            this.treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            if (fileObject != null && (JSFRefactoringUtils.isJavaFile(fileObject) || fileObject.isFolder())) {
                if (fileObject.isFolder()) {
                    string3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    string2 = string3.findOwnerRoot(fileObject);
                    object2 = FileUtil.getRelativePath((FileObject)string2, (FileObject)fileObject.getParent()).replace('/', '.');
                    object = ((String)object2).length() == 0 ? fileObject.getName() : (String)object2 + "." + fileObject.getName();
                    string = ((String)object2).length() == 0 ? this.refactoring.getNewName() : (String)object2 + "." + this.refactoring.getNewName();
                    JSFRefactoringUtils.renamePackage((AbstractRefactoring)this.refactoring, refactoringElementsBag, fileObject, (String)object, string, true);
                } else if (JSFRefactoringUtils.isJavaFile(fileObject) && (string3 = JavaSource.forFileObject((FileObject)fileObject)) != null) {
                    try {
                        string3.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                                CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                                if (!compilationUnitTree.getTypeDecls().isEmpty()) {
                                    JSFRenamePlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                                    JSFRenamePlugin.this.refactoring.getContext().add((Object)compilationController);
                                }
                            }
                        }, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.log(Level.WARNING, "Exception in JSFRenamePlugin", illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, "Exception in JSFRenamePlugin", iOException);
                    }
                }
            }
            if (nonRecursiveFolder != null) {
                string3 = JSFRefactoringUtils.getPackageName(nonRecursiveFolder.getFolder());
                string2 = this.refactoring.getNewName();
                JSFRefactoringUtils.renamePackage((AbstractRefactoring)this.refactoring, refactoringElementsBag, nonRecursiveFolder.getFolder(), string3, string2, false);
            }
            if (this.treePathHandle != null && this.treePathHandle.getKind() == Tree.Kind.CLASS && (string3 = WebModule.getWebModule((FileObject)this.treePathHandle.getFileObject())) != null && (string2 = JSFRefactoringUtils.getCompilationInfo((AbstractRefactoring)this.refactoring, this.treePathHandle.getFileObject())) != null) {
                object2 = this.treePathHandle.resolveElement((CompilationInfo)string2);
                object = (TypeElement)object2;
                string = object.getQualifiedName().toString();
                String string4 = JSFRenamePlugin.renameClass(string, this.refactoring.getNewName());
                List<Occurrences.OccurrenceItem> list = Occurrences.getAllOccurrences((WebModule)string3, string, string4);
                Modifications modifications = new Modifications();
                for (Occurrences.OccurrenceItem occurrenceItem : list) {
                    PositionBounds positionBounds = occurrenceItem.getChangePosition();
                    Modifications.Difference difference = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, positionBounds.getBegin(), positionBounds.getEnd(), string, string4, occurrenceItem.getChangeMessage());
                    modifications.addDifference(occurrenceItem.getFacesConfig(), difference);
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new DiffElement.ChangeFQCNElement(difference, occurrenceItem, modifications));
                }
            }
            semafor.set(null);
        }
        return null;
    }

    private static boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private static String renameClass(String string, String string2) {
        if (JSFRenamePlugin.isEmpty(string) || JSFRenamePlugin.isEmpty(string2)) {
            throw new IllegalArgumentException("Old and new name of the class must be given.");
        }
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return string2;
        }
        return string.substring(0, n + 1) + string2;
    }
}

