/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occurrences {
    private static final Logger LOGGER = Logger.getLogger(Occurrences.class.getName());

    public static List<OccurrenceItem> getAllOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule)) != null) {
            for (FileObject fileObject : fileObjectArray) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObject, true).getRootComponent();
                for (Converter converter : facesConfig.getConverters()) {
                    if (string.equals(converter.getConverterClass())) {
                        arrayList.add(new ConverterClassItem(fileObject, converter, string2));
                        continue;
                    }
                    if (!string.equals(converter.getConverterForClass())) continue;
                    arrayList.add(new ConverterForClassItem(fileObject, converter, string2));
                }
                for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                    if (!string.equals(managedBean.getManagedBeanClass())) continue;
                    arrayList.add(new ManagedBeanClassItem(fileObject, managedBean, string2));
                }
            }
        }
        return arrayList;
    }

    public static List<OccurrenceItem> getPackageOccurrences(WebModule webModule, String string, String string2, boolean bl) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule)) != null) {
            for (FileObject fileObject : fileObjectArray) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObject, true).getRootComponent();
                for (Converter converter : facesConfig.getConverters()) {
                    if (JSFRefactoringUtils.containsRenamingPackage(converter.getConverterClass(), string, bl)) {
                        arrayList.add(new ConverterClassItem(fileObject, converter, Occurrences.getNewFQCN(string2, string, converter.getConverterClass())));
                    }
                    if (!JSFRefactoringUtils.containsRenamingPackage(converter.getConverterForClass(), string, bl)) continue;
                    arrayList.add(new ConverterForClassItem(fileObject, converter, Occurrences.getNewFQCN(string2, string, converter.getConverterForClass())));
                }
                for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                    if (!JSFRefactoringUtils.containsRenamingPackage(managedBean.getManagedBeanClass(), string, bl)) continue;
                    arrayList.add(new ManagedBeanClassItem(fileObject, managedBean, Occurrences.getNewFQCN(string2, string, managedBean.getManagedBeanClass())));
                }
            }
        }
        return arrayList;
    }

    public static String getNewFQCN(String string, String string2, String string3) {
        String string4 = string3;
        if (string2.length() == 0) {
            string4 = string + '.' + string3;
        } else if (string3.startsWith(string2)) {
            string4 = string4.substring(string2.length());
            if (string.length() > 0) {
                string4 = string + string4;
            }
            if (string4.charAt(0) == '.') {
                string4 = string4.substring(1);
            }
        }
        return string4;
    }

    public static class ConverterForClassItem
    extends OccurrenceItem {
        public ConverterForClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, converter, string, converter.getConverterForClass(), converter.getConverterId());
        }

        protected String getXMLElementName() {
            return "converter-for-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeConverterForClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterForClass(this.newValue, this.oldValue);
        }

        private void changeConverterForClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!string.equals(converter.getConverterForClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterForClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterForClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ConverterClassItem
    extends OccurrenceItem {
        public ConverterClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, converter, string, converter.getConverterClass(), converter.getConverterId());
        }

        protected String getXMLElementName() {
            return "converter-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeConverterClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterClass(this.newValue, this.oldValue);
        }

        private void changeConverterClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!string.equals(converter.getConverterClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ManagedBeanClassItem
    extends OccurrenceItem {
        public ManagedBeanClassItem(FileObject fileObject, ManagedBean managedBean, String string) {
            super(fileObject, managedBean, string, managedBean.getManagedBeanClass(), managedBean.getManagedBeanName());
        }

        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performChange() {
            this.changeBeanClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeBeanClass(this.newValue, this.oldValue);
        }

        private void changeBeanClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!string.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanClass(string2);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!this.oldValue.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeManagedBean(managedBean);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean((ManagedBean)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static abstract class OccurrenceItem {
        protected FileObject config;
        protected JSFConfigComponent component;
        protected JSFConfigComponent copy;
        protected String oldValue;
        protected String newValue;
        protected String name;

        public OccurrenceItem(FileObject fileObject, JSFConfigComponent jSFConfigComponent, String string, String string2, String string3) {
            this.config = fileObject;
            this.component = jSFConfigComponent;
            this.copy = (JSFConfigComponent)jSFConfigComponent.copy(jSFConfigComponent.getParent());
            this.newValue = string;
            this.oldValue = string2;
            this.name = string3;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public FileObject getFacesConfig() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"#0000FF\">");
            stringBuffer.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            stringBuffer.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            stringBuffer.append("&gt;</font>");
            return stringBuffer.toString();
        }

        protected abstract String getXMLElementName();

        public String getRenamePackageMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Package_Rename", (Object[])new Object[]{this.getElementText()});
        }

        public abstract String getWhereUsedMessage();

        public abstract String getChangeMessage();

        public abstract void performChange();

        public abstract void undoChange();

        public abstract String getSafeDeleteMessage();

        public abstract void performSafeDelete();

        public abstract void undoSafeDelete();

        public PositionBounds getChangePosition() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                if (!(dataObject instanceof JSFConfigDataObject)) {
                    return null;
                }
                BaseDocument baseDocument = JSFEditorUtilities.getBaseDocument(dataObject);
                int n = this.component.findPosition();
                String string = baseDocument.getText(n, baseDocument.getLength() - n);
                int n2 = string.indexOf(this.getXMLElementName());
                n2 = n + string.indexOf(this.oldValue, n2);
                int n3 = n2 + this.oldValue.length();
                CloneableEditorSupport cloneableEditorSupport = JSFEditorUtilities.findCloneableEditorSupport((DataObject)((JSFConfigDataObject)dataObject));
                if (cloneableEditorSupport != null) {
                    PositionRef positionRef = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
                    PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n3, Position.Bias.Backward);
                    return new PositionBounds(positionRef, positionRef2);
                }
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return null;
        }
    }
}

