/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class J2SELibraryTypeProvider
implements LibraryTypeProvider {
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String VOLUME_TYPE_MAVEN_POM = "maven-pom";
    public static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc", "maven-pom"};
    private static final Set<String> VOLUME_TYPES_REQUIRING_FOLDER = new HashSet<String>(Arrays.asList("classpath", "src", "javadoc"));

    private J2SELibraryTypeProvider() {
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(J2SELibraryTypeProvider.class, (String)"TXT_J2SELibraryType");
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return new J2SELibraryImpl();
    }

    public void libraryCreated(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = J2SELibraryTypeProvider.addLibraryIntoBuild(libraryImplementation, editableProperties);
                    if (bl) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String string = J2SELibraryTypeProvider.LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
                        editableProperties.remove((Object)string);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public Customizer getCustomizer(String string) {
        if (VOLUME_TYPES[0].equals(string) || VOLUME_TYPES[1].equals(string) || VOLUME_TYPES[2].equals(string)) {
            return new J2SEVolumeCustomizer(string);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public static LibraryTypeProvider create() {
        return new J2SELibraryTypeProvider();
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation libraryImplementation, EditableProperties editableProperties) {
        boolean bl = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            Object object2;
            String string = LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
            List list = libraryImplementation.getContent(VOLUME_TYPES[i]);
            if (list == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object2 : list) {
                URI uRI;
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile((URL)object2);
                }
                File file = null;
                FileObject fileObject = URLMapper.findFileObject((URL)object2);
                if (fileObject != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                } else if ("file".equals(((URL)object2).getProtocol()) && (uRI = URI.create(((URL)object2).toExternalForm())) != null) {
                    file = new File(uRI);
                }
                if (file != null) {
                    if (!bl2) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    bl2 = false;
                    file = FileUtil.normalizeFile((File)file);
                    stringBuffer.append(file.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("J2SELibraryTypeProvider: Can not resolve URL: " + object2);
            }
            String string2 = editableProperties.getProperty(string);
            object2 = stringBuffer.toString();
            if (((String)object2).equals(string2)) continue;
            editableProperties.setProperty(string, (String)object2);
            bl = true;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class J2SELibraryImpl
    implements LibraryImplementation {
        private String description;
        private Map<String, List<URL>> contents = new HashMap<String, List<URL>>();
        private String name;
        private String localizingBundle;
        private List<PropertyChangeListener> listeners;

        public J2SELibraryImpl() {
            for (String string : VOLUME_TYPES) {
                this.contents.put(string, Collections.emptyList());
            }
        }

        public String getType() {
            return J2SELibraryTypeProvider.LIBRARY_TYPE;
        }

        public void setName(String string) throws UnsupportedOperationException {
            String string2 = this.name;
            this.name = string;
            this.firePropertyChange("name", string2, this.name);
        }

        public String getName() {
            return this.name;
        }

        public List<URL> getContent(String string) throws IllegalArgumentException {
            List<URL> list = this.contents.get(string);
            if (list == null) {
                throw new IllegalArgumentException();
            }
            return Collections.unmodifiableList(list);
        }

        public void setContent(String string, List<URL> list) throws IllegalArgumentException {
            if (list == null) {
                throw new IllegalArgumentException();
            }
            if (this.contents.keySet().contains(string)) {
                if (VOLUME_TYPES_REQUIRING_FOLDER.contains(string)) {
                    list = J2SELibraryImpl.check(list);
                }
            } else {
                throw new IllegalArgumentException("Volume '" + string + "' is not support by this library. The only acceptable values are: " + this.contents.keySet());
            }
            this.contents.put(string, new ArrayList<URL>(list));
            this.firePropertyChange("content", null, null);
        }

        /*
         * WARNING - void declaration
         */
        private static List<URL> check(List<? extends URL> list) {
            ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
            for (URL uRL : list) {
                void uRL2;
                String string = uRL.toString();
                if (!string.endsWith("/")) {
                    try {
                        URL uRL3 = new URL(string + '/');
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
                arrayList.add((URL)uRL2);
            }
            return arrayList;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            String string2 = this.description;
            this.description = string;
            this.firePropertyChange("description", string2, this.description);
        }

        public String getLocalizingBundle() {
            return this.localizingBundle;
        }

        public void setLocalizingBundle(String string) {
            this.localizingBundle = string;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.name + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(String string, Object object, Object object2) {
            ArrayList<PropertyChangeListener> arrayList;
            Object object3 = this;
            synchronized (object3) {
                if (this.listeners == null) {
                    return;
                }
                arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
            }
            object3 = new PropertyChangeEvent(this, string, object, object2);
            for (PropertyChangeListener propertyChangeListener : arrayList) {
                propertyChangeListener.propertyChange((PropertyChangeEvent)object3);
            }
        }
    }
}

